/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.quests.ContextMenuBuilder;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RewardButton
extends Button {
    public final QuestScreen questScreen;
    public final Reward reward;

    public RewardButton(Panel panel, Reward r) {
        super(panel, r.getTitle(), r.getIcon());
        this.questScreen = (QuestScreen)panel.getGui();
        this.reward = r;
        this.setSize(18, 18);
    }

    public Component getTitle() {
        if (this.reward.isTeamReward()) {
            return super.getTitle().m_6881_().m_130940_(ChatFormatting.BLUE);
        }
        return super.getTitle();
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.reward);
        if (this.reward.addTitleInMouseOverText()) {
            list.add(this.getTitle());
        }
        if (this.reward.isTeamReward() || this.questScreen.file.self.isRewardBlocked(this.reward)) {
            Object object = this.getIngredientUnderMouse();
            if (object instanceof WrappedIngredient) {
                ItemStack stack;
                Object ingredient;
                WrappedIngredient wi = (WrappedIngredient)object;
                if (wi.tooltip && (ingredient = WrappedIngredient.unwrap((Object)object)) instanceof ItemStack && !(stack = (ItemStack)ingredient).m_41619_()) {
                    ArrayList list1 = new ArrayList();
                    GuiHelper.addStackTooltip((ItemStack)stack, list1);
                    list1.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                }
            }
            list.blankLine();
            this.reward.addMouseOverText(list);
            if (this.reward.isTeamReward()) {
                list.add((Component)Component.m_237115_((String)"ftbquests.reward.team_reward").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}));
            } else if (this.questScreen.file.self.isRewardBlocked(this.reward)) {
                list.add((Component)Component.m_237110_((String)"ftbquests.reward.this_blocked", (Object[])new Object[]{this.questScreen.file.self}).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            }
        } else {
            this.reward.addMouseOverText(list);
            if (!list.shouldRender()) {
                list.zOffset = 580;
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public WidgetType getWidgetType() {
        if (!ClientQuestFile.exists() || !ClientQuestFile.INSTANCE.self.isCompleted(this.reward.quest)) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (ClientQuestFile.exists()) {
                this.reward.onButtonClicked(this, ClientQuestFile.INSTANCE.self.getClaimType(Minecraft.m_91087_().f_91074_.m_20148_(), this.reward).canClaim());
            }
        } else if (button.isRight() && ClientQuestFile.exists() && ClientQuestFile.INSTANCE.canEdit()) {
            this.playClickSound();
            ContextMenuBuilder.create(this.reward, this.questScreen).openContextMenu(this.getGui());
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.reward.getIngredient();
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(matrixStack, theme, x, y, w, h);
        }
    }

    public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        String s;
        int bs = h >= 32 ? 32 : 16;
        GuiHelper.setupDrawing();
        this.drawBackground(matrixStack, theme, x, y, w, h);
        this.drawIcon(matrixStack, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.questScreen.file.self == null) {
            return;
        }
        if (this.questScreen.contextMenu != null) {
            // empty if block
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 200.0);
        RenderSystem.m_69478_();
        boolean completed = false;
        if (this.questScreen.file.self.getClaimType(Minecraft.m_91087_().f_91074_.m_20148_(), this.reward).isClaimed()) {
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(matrixStack, x + w - 9, y + 1, 8, 8);
            completed = true;
        } else if (this.questScreen.file.self.isCompleted(this.reward.quest)) {
            ((Icon)ThemeProperties.ALERT_ICON.get()).draw(matrixStack, x + w - 9, y + 1, 8, 8);
        }
        matrixStack.m_85849_();
        if (!completed && !(s = this.reward.getButtonText()).isEmpty()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(x + 19) - (double)theme.getStringWidth(s) / 2.0, (double)(y + 15), 200.0);
            matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
            theme.drawString(matrixStack, (Object)s, 0.0f, 0.0f, Color4I.WHITE, 2);
            matrixStack.m_85849_();
        }
    }
}

