/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class XPReward
extends Reward {
    public int xp;

    public XPReward(Quest quest, int x) {
        super(quest);
        this.xp = x;
    }

    public XPReward(Quest quest) {
        this(quest, 100);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.XP;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128405_("xp", this.xp);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.xp = nbt.m_128451_("xp");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130130_(this.xp);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.xp = buffer.m_130242_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("xp", this.xp, v -> {
            this.xp = v;
        }, 100, 1, Integer.MAX_VALUE).setNameKey("ftbquests.reward.ftbquests.xp");
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        player.m_6756_(this.xp);
        if (notify) {
            new DisplayRewardToastMessage(this.id, (Component)Component.m_237115_((String)"ftbquests.reward.ftbquests.xp").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)("+" + this.xp)).m_130940_(ChatFormatting.GREEN)), (Icon)Color4I.EMPTY).sendTo(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.reward.ftbquests.xp").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)("+" + this.xp)).m_130940_(ChatFormatting.GREEN));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return "+" + this.xp;
    }
}

