/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt.config;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.SNBTNet;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntArrayValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.LongValue;
import dev.ftb.mods.ftblibrary.snbt.config.StringListValue;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class SNBTConfig
extends BaseValue<List<BaseValue<?>>> {
    public static SNBTConfig create(String name) {
        return new SNBTConfig(null, name, new ArrayList());
    }

    private SNBTConfig(SNBTConfig c, String n, List<BaseValue<?>> defaultValue) {
        super(c, n, defaultValue);
    }

    @Override
    public void write(SNBTCompoundTag tag) {
        if (this.parent == null) {
            tag.comment("", String.join((CharSequence)"\n", this.comment));
            ((List)this.defaultValue).sort(null);
            for (BaseValue value : (List)this.defaultValue) {
                value.write(tag);
            }
            return;
        }
        tag.comment(this.key, String.join((CharSequence)"\n", this.comment));
        SNBTCompoundTag tag1 = new SNBTCompoundTag();
        ((List)this.defaultValue).sort(null);
        for (BaseValue value : (List)this.defaultValue) {
            value.write(tag1);
        }
        tag.m_128365_(this.key, (Tag)tag1);
    }

    @Override
    public void read(SNBTCompoundTag tag) {
        if (this.parent == null) {
            for (BaseValue value : (List)this.defaultValue) {
                if (!tag.m_128441_(value.key)) continue;
                value.read(tag);
            }
            return;
        }
        if (tag.m_128425_(this.key, 10)) {
            SNBTCompoundTag tag1 = tag.getCompound(this.key);
            for (BaseValue value : (List)this.defaultValue) {
                if (!tag1.m_128441_(value.key)) continue;
                value.read(tag1);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void createClientConfig(ConfigGroup group) {
        if (this.parent == null) {
            for (BaseValue value : (List)this.defaultValue) {
                if (value.excluded) continue;
                value.createClientConfig(group);
            }
        } else {
            ConfigGroup g = group.getGroup(this.key);
            for (BaseValue value : (List)this.defaultValue) {
                if (value.excluded) continue;
                value.createClientConfig(g);
            }
        }
    }

    public void write(FriendlyByteBuf buf) {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        this.write(tag);
        SNBTNet.write(buf, (Tag)tag);
    }

    public void read(FriendlyByteBuf buf) {
        this.read(SNBTNet.readCompound(buf));
    }

    public void load(Path path) {
        SNBTCompoundTag tag = SNBT.read(path);
        if (tag != null) {
            this.read(tag);
        }
        this.save(path);
    }

    public void save(Path path) {
        Util.m_183992_().execute(() -> this.saveNow(path));
    }

    public void saveNow(Path path) {
        if (this.parent != null) {
            this.parent.saveNow(path);
        } else {
            SNBTCompoundTag tag = new SNBTCompoundTag();
            this.write(tag);
            SNBT.write(path, tag);
        }
    }

    public void load(Path path, Path defaultPath, Supplier<String[]> comment) {
        if (Files.exists(defaultPath, new LinkOption[0])) {
            if (!Files.exists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.copy(defaultPath, path, new CopyOption[0]);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            SNBTConfig defaultConfigFile = SNBTConfig.create(this.key);
            defaultConfigFile.comment(comment.get());
            defaultConfigFile.save(defaultPath);
        }
        this.load(path);
    }

    public <T extends BaseValue<?>> T add(T value) {
        ((List)this.defaultValue).add(value);
        return value;
    }

    public SNBTConfig getGroup(String key) {
        return this.add(new SNBTConfig(this, key, new ArrayList()));
    }

    public BooleanValue getBoolean(String key, boolean def) {
        return this.add(new BooleanValue(this, key, def));
    }

    public IntValue getInt(String key, int def) {
        return this.add(new IntValue(this, key, def));
    }

    public IntValue getInt(String key, int def, int min, int max) {
        return (IntValue)this.getInt(key, def).range(min, max);
    }

    public LongValue getLong(String key, long def) {
        return this.add(new LongValue(this, key, def));
    }

    public LongValue getLong(String key, long def, long min, long max) {
        return (LongValue)this.getLong(key, def).range(min, max);
    }

    public DoubleValue getDouble(String key, double def) {
        return this.add(new DoubleValue(this, key, def));
    }

    public DoubleValue getDouble(String key, double def, double min, double max) {
        return (DoubleValue)this.getDouble(key, def).range(min, max);
    }

    public StringValue getString(String key, String def) {
        return this.add(new StringValue(this, key, def));
    }

    public StringListValue getStringList(String key, List<String> def) {
        return this.add(new StringListValue(this, key, def));
    }

    public <T> EnumValue<T> getEnum(String key, NameMap<T> nameMap) {
        return this.add(new EnumValue<T>(this, key, nameMap));
    }

    public IntArrayValue getIntArray(String key, int[] def) {
        return this.add(new IntArrayValue(this, key, def));
    }
}

