/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class CreatePartyMessage
extends BaseC2SMessage {
    private final String name;
    private final String description;
    private final int color;
    private final Set<GameProfile> invited;

    CreatePartyMessage(FriendlyByteBuf buffer) {
        this.name = buffer.m_130136_(Short.MAX_VALUE);
        this.description = buffer.m_130136_(Short.MAX_VALUE);
        this.color = buffer.readInt();
        int s = buffer.m_130242_();
        this.invited = new HashSet<GameProfile>(s);
        for (int i = 0; i < s; ++i) {
            this.invited.add(new GameProfile(buffer.m_130259_(), buffer.m_130136_(Short.MAX_VALUE)));
        }
    }

    public CreatePartyMessage(String n, String d, int c, Set<GameProfile> i) {
        this.name = n;
        this.description = d;
        this.color = c;
        this.invited = i;
    }

    public MessageType getType() {
        return FTBTeamsNet.CREATE_PARTY;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130072_(this.name, Short.MAX_VALUE);
        buffer.m_130072_(this.description, Short.MAX_VALUE);
        buffer.writeInt(this.color);
        buffer.m_130130_(this.invited.size());
        for (GameProfile p : this.invited) {
            buffer.m_130077_(p.getId());
            buffer.m_130072_(p.getName(), Short.MAX_VALUE);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        Team team = FTBTeamsAPI.getPlayerTeam(player);
        if (team instanceof PlayerTeam) {
            PlayerTeam pt = (PlayerTeam)team;
            pt.createParty(player, this.name, this.description, this.color, this.invited);
        }
    }
}

