/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class TeamArgument
implements ArgumentType<TeamArgumentProvider> {
    public static final SimpleCommandExceptionType ALREADY_IN_PARTY = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"ftbteams.already_in_party"));
    public static final DynamicCommandExceptionType PLAYER_IN_PARTY = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"ftbteams.player_already_in_party", (Object[])new Object[]{object}));
    public static final SimpleCommandExceptionType NOT_IN_PARTY = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"ftbteams.not_in_party"));
    public static final DynamicCommandExceptionType TEAM_NOT_FOUND = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"ftbteams.team_not_found", (Object[])new Object[]{object}));
    public static final DynamicCommandExceptionType CANT_EDIT = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"ftbteams.cant_edit", (Object[])new Object[]{object}));
    public static final Dynamic2CommandExceptionType NOT_MEMBER = new Dynamic2CommandExceptionType((a, b) -> Component.m_237110_((String)"ftbteams.not_member", (Object[])new Object[]{a, b}));
    public static final Dynamic2CommandExceptionType NOT_OFFICER = new Dynamic2CommandExceptionType((a, b) -> Component.m_237110_((String)"ftbteams.not_officer", (Object[])new Object[]{a, b}));
    public static final DynamicCommandExceptionType NOT_INVITED = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"ftbteams.not_invited", (Object[])new Object[]{object}));
    public static final SimpleCommandExceptionType OWNER_CANT_LEAVE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"ftbteams.owner_cant_leave"));
    public static final SimpleCommandExceptionType CANT_KICK_OWNER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"ftbteams.cant_kick_owner"));
    public static final SimpleCommandExceptionType API_OVERRIDE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"ftbteams.api_override"));
    public static final SimpleCommandExceptionType NAME_TOO_SHORT = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"ftbteams.name_too_short"));
    public static final SimpleCommandExceptionType NO_PERMISSION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"ftbteams.server_permissions_prevent"));

    public static TeamArgument create() {
        return new TeamArgument();
    }

    public static Team get(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return ((TeamArgumentProvider)context.getArgument(name, TeamArgumentProvider.class)).getTeam((CommandSourceStack)context.getSource());
    }

    private TeamArgument() {
    }

    public TeamArgumentProvider parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '@') {
            EntitySelector selector = new EntitySelectorParser(reader).m_121377_();
            if (selector.m_121159_()) {
                throw EntityArgument.f_91438_.create();
            }
            return new SelectorProvider(selector);
        }
        int i = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        return new IDProvider(reader.getString().substring(i, reader.getCursor()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
        if (commandContext.getSource() instanceof SharedSuggestionProvider) {
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            FTBTeamsAPI.API api = FTBTeamsAPI.api();
            if (commandContext.getSource() instanceof CommandSourceStack) {
                if (api.isManagerLoaded()) {
                    for (Team team : api.getManager().getTeams()) {
                        if (team.isPlayerTeam()) continue;
                        list.add(team.getShortName());
                    }
                }
            } else if (api.isClientManagerLoaded()) {
                for (Team team : api.getClientManager().getTeams()) {
                    if (team.isPlayerTeam()) continue;
                    list.add(team.getShortName());
                }
            }
            list.addAll(((SharedSuggestionProvider)commandContext.getSource()).m_5982_());
            return SharedSuggestionProvider.m_82970_(list, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    private static class SelectorProvider
    implements TeamArgumentProvider {
        private final EntitySelector selector;

        private SelectorProvider(EntitySelector s) {
            this.selector = s;
        }

        @Override
        public Team getTeam(CommandSourceStack source) throws CommandSyntaxException {
            ServerPlayer player = this.selector.m_121163_(source);
            return FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TEAM_NOT_FOUND.create((Object)player.m_20148_()));
        }
    }

    private static class IDProvider
    implements TeamArgumentProvider {
        private final String id;

        private IDProvider(String s) {
            this.id = s;
        }

        private CommandSyntaxException error() {
            return TEAM_NOT_FOUND.create((Object)this.id);
        }

        @Override
        public Team getTeam(CommandSourceStack source) throws CommandSyntaxException {
            Optional<Team> t = FTBTeamsAPI.api().getManager().getTeamByName(this.id);
            if (t.isPresent()) {
                return t.get();
            }
            return (Team)source.m_81377_().m_129927_().m_10996_(this.id).map(GameProfile::getId).map(FTBTeamsAPI.api().getManager()::getTeamForPlayerID).orElseThrow().orElseThrow(this::error);
        }
    }

    public static class Info
    implements ArgumentTypeInfo<TeamArgument, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf friendlyByteBuf) {
        }

        public Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return new Template();
        }

        public void serializeToJson(Template template, JsonObject jsonObject) {
        }

        public Template unpack(TeamArgument argumentType) {
            return new Template();
        }

        public final class Template
        implements ArgumentTypeInfo.Template<TeamArgument> {
            public TeamArgument instantiate(CommandBuildContext commandBuildContext) {
                return TeamArgument.create();
            }

            public ArgumentTypeInfo<TeamArgument, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

