/*
 * Decompiled with CFR 0.152.
 */
package draylar.gofish.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class BiomePredicate {
    public static final BiomePredicate EMPTY = new BiomePredicate(Collections.emptyList());
    private static final String VALID_KEY = "valid";
    private final List<String> valid;

    public BiomePredicate(List<String> valid) {
        this.valid = valid;
    }

    private BiomePredicate(Builder builder) {
        this.valid = builder.valid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getValid() {
        return this.valid;
    }

    public boolean test(class_1937 world, class_1959 biome) {
        class_2960 id = world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
        if (id != null) {
            String low = id.toString();
            for (String s : this.valid) {
                if (!new class_2960(s).toString().equals(low)) continue;
                return true;
            }
        }
        return false;
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        for (String s : this.valid) {
            arr.add(s);
        }
        obj.add(VALID_KEY, (JsonElement)arr);
        return obj;
    }

    public static BiomePredicate fromJson(JsonElement element) {
        JsonObject obj = class_3518.method_15295((JsonElement)element, (String)VALID_KEY);
        JsonArray arr = obj.getAsJsonArray(VALID_KEY);
        ArrayList<String> sArr = new ArrayList<String>();
        for (int i = 0; i < arr.size(); ++i) {
            sArr.add(arr.get(i).getAsString());
        }
        return new BiomePredicate(sArr);
    }

    public static class Builder {
        private List<String> valid;

        private Builder() {
        }

        public Builder setValid(List<String> valid) {
            this.valid = valid;
            return this;
        }

        public Builder add(String biome) {
            if (!biome.isEmpty()) {
                this.valid.add(biome);
            }
            return this;
        }

        public Builder of(BiomePredicate biomePredicate) {
            this.valid = biomePredicate.valid;
            return this;
        }

        public BiomePredicate build() {
            return new BiomePredicate(this);
        }
    }
}

