/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.GuardEntity;
import tallestegg.guardvillagers.entities.ai.goals.AttackEntityDaytimeGoal;
import tallestegg.guardvillagers.entities.ai.goals.HealGolemGoal;
import tallestegg.guardvillagers.entities.ai.goals.HealGuardAndPlayerGoal;

@Mod.EventBusSubscriber(modid="guardvillagers")
public class HandlerEvents {
    @SubscribeEvent
    public static void onEntityTarget(LivingSetAttackTargetEvent event) {
        boolean isVillager;
        LivingEntity entity = (LivingEntity)event.getEntity();
        LivingEntity target = event.getTarget();
        if (target == null || entity.func_200600_R() == GuardEntityType.GUARD.get()) {
            return;
        }
        boolean bl = isVillager = target.func_200600_R() == EntityType.field_200756_av || target.func_200600_R() == GuardEntityType.GUARD.get();
        if (isVillager) {
            List list = entity.field_70170_p.func_217357_a(MobEntity.class, entity.func_174813_aQ().func_72314_b(GuardConfig.GuardVillagerHelpRange, 5.0, GuardConfig.GuardVillagerHelpRange));
            for (MobEntity mob : list) {
                if (mob.func_200600_R() != GuardEntityType.GUARD.get() || mob.func_70638_az() != null) continue;
                mob.func_70624_b(entity);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        boolean isGolem;
        LivingEntity entity = (LivingEntity)event.getEntity();
        Entity trueSource = event.getSource().func_76346_g();
        if (entity == null || trueSource == null) {
            return;
        }
        boolean isVillager = entity.func_200600_R() == EntityType.field_200756_av || entity.func_200600_R() == GuardEntityType.GUARD.get();
        boolean bl = isGolem = isVillager || entity.func_200600_R() == EntityType.field_200757_aw;
        if (isGolem && trueSource.func_200600_R() == GuardEntityType.GUARD.get() && !GuardConfig.guardArrowsHurtVillagers) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if (isVillager && event.getSource().func_76346_g() instanceof MobEntity) {
            List list = trueSource.field_70170_p.func_217357_a(MobEntity.class, trueSource.func_174813_aQ().func_72314_b(GuardConfig.GuardVillagerHelpRange, 5.0, GuardConfig.GuardVillagerHelpRange));
            for (MobEntity mob : list) {
                if (mob.func_200600_R() != GuardEntityType.GUARD.get() || mob.func_70638_az() != null || trueSource.func_200600_R() == GuardEntityType.GUARD.get()) continue;
                mob.func_70624_b((LivingEntity)((MobEntity)event.getSource().func_76346_g()));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinWorldEvent event) {
        AbstractVillagerEntity villager;
        if (GuardConfig.AttackAllMobs) {
            if (event.getEntity() instanceof IMob && !GuardConfig.MobBlackList.contains(event.getEntity().func_70022_Q()) && !(event.getEntity() instanceof SpiderEntity)) {
                MobEntity mob = (MobEntity)event.getEntity();
                mob.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal(mob, GuardEntity.class, false));
            }
            if (event.getEntity() instanceof IMob && !GuardConfig.MobBlackList.contains(event.getEntity().func_70022_Q()) && event.getEntity() instanceof SpiderEntity) {
                SpiderEntity spider = (SpiderEntity)event.getEntity();
                spider.field_70715_bh.func_75776_a(3, new AttackEntityDaytimeGoal<GuardEntity>(spider, GuardEntity.class));
            }
        }
        if (event.getEntity() instanceof AbstractIllagerEntity) {
            AbstractIllagerEntity illager = (AbstractIllagerEntity)event.getEntity();
            illager.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)illager, GuardEntity.class, false));
            if (GuardConfig.IllagersRunFromPolarBears) {
                illager.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)illager, PolarBearEntity.class, 6.0f, 1.0, 1.2));
            }
            if (GuardConfig.RaidAnimals && illager.func_213657_el()) {
                illager.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)illager, AnimalEntity.class, false));
            }
        }
        if (event.getEntity() instanceof GuardEntity) {
            GuardEntity guard = (GuardEntity)event.getEntity();
            guard.func_98053_h(false);
        }
        if (event.getEntity() instanceof AbstractVillagerEntity) {
            villager = (AbstractVillagerEntity)event.getEntity();
            if (GuardConfig.VillagersRunFromPolarBears) {
                villager.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)villager, PolarBearEntity.class, 6.0f, 1.0, 1.2));
            }
            if (GuardConfig.WitchesVillager) {
                villager.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)villager, WitchEntity.class, 6.0f, 1.0, 1.2));
            }
        }
        if (event.getEntity() instanceof VillagerEntity) {
            villager = (VillagerEntity)event.getEntity();
            if (GuardConfig.BlackSmithHealing) {
                villager.field_70714_bg.func_75776_a(1, (Goal)new HealGolemGoal((MobEntity)villager));
            }
            if (GuardConfig.ClericHealing) {
                villager.field_70714_bg.func_75776_a(1, (Goal)new HealGuardAndPlayerGoal((MobEntity)villager, 1.0, 100, 0, 10.0f));
            }
        }
        if (event.getEntity() instanceof IronGolemEntity) {
            IronGolemEntity golem = (IronGolemEntity)event.getEntity();
            HurtByTargetGoal tolerateFriendlyFire = new HurtByTargetGoal((CreatureEntity)golem, new Class[]{GuardEntity.class}).func_220794_a(new Class[0]);
            golem.field_70715_bh.field_220892_d.stream().map(it -> it.field_220774_a).filter(it -> it instanceof HurtByTargetGoal).findFirst().ifPresent(angerGoal -> {
                golem.field_70715_bh.func_85156_a(angerGoal);
                golem.field_70715_bh.func_75776_a(2, (Goal)tolerateFriendlyFire);
            });
        }
        if (event.getEntity() instanceof ZombieEntity) {
            ZombieEntity zombie = (ZombieEntity)event.getEntity();
            zombie.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)zombie, GuardEntity.class, false));
        }
        if (event.getEntity() instanceof RavagerEntity) {
            RavagerEntity ravager = (RavagerEntity)event.getEntity();
            ravager.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)ravager, GuardEntity.class, false));
            if (GuardConfig.RaidAnimals && ravager.func_213657_el()) {
                ravager.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)ravager, AnimalEntity.class, false));
            }
        }
        if (event.getEntity() instanceof WitchEntity) {
            WitchEntity witch = (WitchEntity)event.getEntity();
            if (GuardConfig.WitchesVillager) {
                witch.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)witch, AbstractVillagerEntity.class, true));
                witch.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)witch, IronGolemEntity.class, true));
                witch.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)witch, GuardEntity.class, false));
            }
            if (GuardConfig.IllagersRunFromPolarBears) {
                witch.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)witch, PolarBearEntity.class, 6.0f, 1.0, 1.2));
            }
            if (GuardConfig.RaidAnimals && witch.func_213657_el()) {
                witch.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)witch, AnimalEntity.class, false));
            }
        }
        if (event.getEntity() instanceof CatEntity) {
            CatEntity cat = (CatEntity)event.getEntity();
            cat.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)cat, AbstractIllagerEntity.class, 12.0f, 1.0, 1.2));
        }
        if (event.getEntity() instanceof IllusionerEntity) {
            IllusionerEntity illusioner = (IllusionerEntity)event.getEntity();
            illusioner.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)illusioner, GuardEntity.class, false));
            if (GuardConfig.RaidAnimals && illusioner.func_213657_el()) {
                illusioner.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)illusioner, AnimalEntity.class, false));
            }
        }
    }
}

