/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockModelDefinition;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.Multipart;
import net.minecraft.client.renderer.model.multipart.Selector;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.BellTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ConduitTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EnchantmentTableTileEntityRenderer;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakery {
    public static final RenderMaterial field_207763_a = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/fire_0"));
    public static final RenderMaterial field_207764_b = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/fire_1"));
    public static final RenderMaterial field_207766_d = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/lava_flow"));
    public static final RenderMaterial field_207768_f = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/water_flow"));
    public static final RenderMaterial field_207769_g = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/water_overlay"));
    public static final RenderMaterial field_229315_f_ = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("entity/banner_base"));
    public static final RenderMaterial field_229316_g_ = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("entity/shield_base"));
    public static final RenderMaterial field_229317_h_ = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("entity/shield_base_nopattern"));
    public static final List<ResourceLocation> field_229318_i_ = IntStream.range(0, 10).mapToObj(destroyStage -> new ResourceLocation("block/destroy_stage_" + destroyStage)).collect(Collectors.toList());
    public static final List<ResourceLocation> field_229319_j_ = field_229318_i_.stream().map(resourceLocation -> new ResourceLocation("textures/" + resourceLocation.func_110623_a() + ".png")).collect(Collectors.toList());
    public static final List<RenderType> field_229320_k_ = field_229319_j_.stream().map(RenderType::func_228656_k_).collect(Collectors.toList());
    protected static final Set<RenderMaterial> field_177602_b = (Set)Util.func_200696_a((Object)Sets.newHashSet(), materialSet -> {
        materialSet.add(field_207768_f);
        materialSet.add(field_207766_d);
        materialSet.add(field_207769_g);
        materialSet.add(field_207763_a);
        materialSet.add(field_207764_b);
        materialSet.add(BellTileEntityRenderer.field_217653_c);
        materialSet.add(ConduitTileEntityRenderer.field_205118_a);
        materialSet.add(ConduitTileEntityRenderer.field_205119_d);
        materialSet.add(ConduitTileEntityRenderer.field_205120_e);
        materialSet.add(ConduitTileEntityRenderer.field_205121_f);
        materialSet.add(ConduitTileEntityRenderer.field_207746_g);
        materialSet.add(ConduitTileEntityRenderer.field_207747_h);
        materialSet.add(EnchantmentTableTileEntityRenderer.field_147540_b);
        materialSet.add(field_229315_f_);
        materialSet.add(field_229316_g_);
        materialSet.add(field_229317_h_);
        for (ResourceLocation resourcelocation : field_229318_i_) {
            materialSet.add(new RenderMaterial(AtlasTexture.field_110575_b, resourcelocation));
        }
        materialSet.add(new RenderMaterial(AtlasTexture.field_110575_b, PlayerContainer.field_226616_d_));
        materialSet.add(new RenderMaterial(AtlasTexture.field_110575_b, PlayerContainer.field_226617_e_));
        materialSet.add(new RenderMaterial(AtlasTexture.field_110575_b, PlayerContainer.field_226618_f_));
        materialSet.add(new RenderMaterial(AtlasTexture.field_110575_b, PlayerContainer.field_226619_g_));
        materialSet.add(new RenderMaterial(AtlasTexture.field_110575_b, PlayerContainer.field_226620_h_));
        Atlases.func_228775_a_(materialSet::add);
    });
    private static final Logger field_177603_c = LogManager.getLogger();
    public static final ModelResourceLocation field_177604_a = new ModelResourceLocation("builtin/missing", "missing");
    private static final String field_229321_r_ = field_177604_a.toString();
    @VisibleForTesting
    public static final String field_188641_d = ("{    'textures': {       'particle': '" + MissingTextureSprite.func_195675_b().func_110623_a() + "',       'missingno': '" + MissingTextureSprite.func_195675_b().func_110623_a() + "'    },    'elements': [         {  'from': [ 0, 0, 0 ],            'to': [ 16, 16, 16 ],            'faces': {                'down':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'down',  'texture': '#missingno' },                'up':    { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'up',    'texture': '#missingno' },                'north': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'north', 'texture': '#missingno' },                'south': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'south', 'texture': '#missingno' },                'west':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'west',  'texture': '#missingno' },                'east':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'east',  'texture': '#missingno' }            }        }    ]}").replace('\'', '\"');
    private static final Map<String, String> field_177600_d = Maps.newHashMap((Map)ImmutableMap.of((Object)"missing", (Object)field_188641_d));
    private static final Splitter field_209611_w = Splitter.on((char)',');
    private static final Splitter field_209612_x = Splitter.on((char)'=').limit(2);
    public static final BlockModel field_177606_o = (BlockModel)Util.func_200696_a((Object)BlockModel.func_178294_a((String)"{\"gui_light\": \"front\"}"), model2 -> {
        model2.field_178317_b = "generation marker";
    });
    public static final BlockModel field_177616_r = (BlockModel)Util.func_200696_a((Object)BlockModel.func_178294_a((String)"{\"gui_light\": \"side\"}"), blockModel2 -> {
        blockModel2.field_178317_b = "block entity marker";
    });
    private static final StateContainer<Block, BlockState> field_209613_y = new StateContainer.Builder((Object)Blocks.field_150350_a).func_206894_a(new Property[]{BooleanProperty.func_177716_a((String)"map")}).func_235882_a_(Block::func_176223_P, BlockState::new);
    private static final ItemModelGenerator field_217854_z = new ItemModelGenerator();
    private static final Map<ResourceLocation, StateContainer<Block, BlockState>> field_209607_C = ImmutableMap.of((Object)new ResourceLocation("item_frame"), field_209613_y);
    protected final IResourceManager field_177598_f;
    @Nullable
    private SpriteMap field_229322_z_;
    private final BlockColors field_225365_D;
    private final Set<ResourceLocation> field_217848_D = Sets.newHashSet();
    private final BlockModelDefinition.ContainerHolder field_209610_F = new BlockModelDefinition.ContainerHolder();
    private final Map<ResourceLocation, IUnbakedModel> field_217849_F = Maps.newHashMap();
    private final Map<Triple<ResourceLocation, TransformationMatrix, Boolean>, IBakedModel> field_217850_G = Maps.newHashMap();
    private final Map<ResourceLocation, IUnbakedModel> field_217851_H = Maps.newHashMap();
    private final Map<ResourceLocation, IBakedModel> field_217852_I = Maps.newHashMap();
    private Map<ResourceLocation, Pair<AtlasTexture, AtlasTexture.SheetData>> field_217853_J;
    private int field_225366_L = 1;
    private final Object2IntMap<BlockState> field_225367_M = (Object2IntMap)Util.func_200696_a((Object)new Object2IntOpenHashMap(), state2 -> state2.defaultReturnValue(-1));

    public ModelBakery(IResourceManager resourceManagerIn, BlockColors blockColorsIn, IProfiler profilerIn, int maxMipmapLevel) {
        this(resourceManagerIn, blockColorsIn, true);
        this.processLoading(profilerIn, maxMipmapLevel);
    }

    protected ModelBakery(IResourceManager resourceManagerIn, BlockColors blockColorsIn, boolean vanillaBakery) {
        this.field_177598_f = resourceManagerIn;
        this.field_225365_D = blockColorsIn;
    }

    protected void processLoading(IProfiler profilerIn, int maxMipmapLevel) {
        ModelLoaderRegistry.onModelLoadingStart();
        profilerIn.func_76320_a("missing_model");
        try {
            this.field_217849_F.put((ResourceLocation)field_177604_a, (IUnbakedModel)this.func_177594_c((ResourceLocation)field_177604_a));
            this.func_217843_a(field_177604_a);
        }
        catch (IOException ioexception) {
            field_177603_c.error("Error loading missing model, should never happen :(", (Throwable)ioexception);
            throw new RuntimeException(ioexception);
        }
        profilerIn.func_219895_b("static_definitions");
        field_209607_C.forEach((resourceLocation, container) -> container.func_177619_a().forEach(state2 -> this.func_217843_a(BlockModelShapes.func_209553_a((ResourceLocation)resourceLocation, (BlockState)state2))));
        profilerIn.func_219895_b("blocks");
        for (Block block : Registry.field_212618_g) {
            block.func_176194_O().func_177619_a().forEach(state2 -> this.func_217843_a(BlockModelShapes.func_209554_c((BlockState)state2)));
        }
        profilerIn.func_219895_b("items");
        for (ResourceLocation resourcelocation : Registry.field_212630_s.func_148742_b()) {
            this.func_217843_a(new ModelResourceLocation(resourcelocation, "inventory"));
        }
        profilerIn.func_219895_b("special");
        this.func_217843_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory"));
        for (ResourceLocation rl : this.getSpecialModels()) {
            this.addModelToCache(rl);
        }
        profilerIn.func_219895_b("textures");
        LinkedHashSet set = Sets.newLinkedHashSet();
        Set set1 = this.field_217851_H.values().stream().flatMap(unbaked -> unbaked.func_225614_a_(this::func_209597_a, set).stream()).collect(Collectors.toSet());
        set1.addAll(field_177602_b);
        ForgeHooksClient.gatherFluidTextures(set1);
        set.stream().filter(stringPair -> !((String)stringPair.getSecond()).equals(field_229321_r_)).forEach(textureReferenceErrors -> field_177603_c.warn("Unable to resolve texture reference: {} in {}", textureReferenceErrors.getFirst(), textureReferenceErrors.getSecond()));
        Map<ResourceLocation, List<RenderMaterial>> map = set1.stream().collect(Collectors.groupingBy(RenderMaterial::func_229310_a_));
        profilerIn.func_219895_b("stitching");
        this.field_217853_J = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, List<RenderMaterial>> entry : map.entrySet()) {
            AtlasTexture atlastexture = new AtlasTexture(entry.getKey());
            AtlasTexture.SheetData atlastexture$sheetdata = atlastexture.func_229220_a_(this.field_177598_f, entry.getValue().stream().map(RenderMaterial::func_229313_b_), profilerIn, maxMipmapLevel);
            this.field_217853_J.put(entry.getKey(), (Pair<AtlasTexture, AtlasTexture.SheetData>)Pair.of((Object)atlastexture, (Object)atlastexture$sheetdata));
        }
        profilerIn.func_76319_b();
    }

    public SpriteMap func_229333_a_(TextureManager resourceManagerIn, IProfiler profilerIn) {
        profilerIn.func_76320_a("atlas");
        for (Pair<AtlasTexture, AtlasTexture.SheetData> pair : this.field_217853_J.values()) {
            AtlasTexture atlastexture = (AtlasTexture)pair.getFirst();
            AtlasTexture.SheetData atlastexture$sheetdata = (AtlasTexture.SheetData)pair.getSecond();
            atlastexture.func_215260_a(atlastexture$sheetdata);
            resourceManagerIn.func_229263_a_(atlastexture.func_229223_g_(), (Texture)atlastexture);
            resourceManagerIn.func_110577_a(atlastexture.func_229223_g_());
            atlastexture.func_229221_b_(atlastexture$sheetdata);
        }
        this.field_229322_z_ = new SpriteMap((Collection)this.field_217853_J.values().stream().map(Pair::getFirst).collect(Collectors.toList()));
        profilerIn.func_219895_b("baking");
        this.field_217851_H.keySet().forEach(resourceLocation -> {
            IBakedModel ibakedmodel = null;
            try {
                ibakedmodel = this.func_217845_a((ResourceLocation)resourceLocation, (IModelTransform)ModelRotation.X0_Y0);
            }
            catch (Exception exception) {
                field_177603_c.warn("Unable to bake model: '{}': {}", resourceLocation, (Object)exception);
            }
            if (ibakedmodel != null) {
                this.field_217852_I.put((ResourceLocation)resourceLocation, ibakedmodel);
            }
        });
        profilerIn.func_76319_b();
        return this.field_229322_z_;
    }

    private static Predicate<BlockState> func_209605_a(StateContainer<Block, BlockState> containerIn, String variantIn) {
        HashMap map = Maps.newHashMap();
        for (String s : field_209611_w.split((CharSequence)variantIn)) {
            Iterator iterator2 = field_209612_x.split((CharSequence)s).iterator();
            if (!iterator2.hasNext()) continue;
            String s1 = (String)iterator2.next();
            Property property = containerIn.func_185920_a(s1);
            if (property != null && iterator2.hasNext()) {
                String s2 = (String)iterator2.next();
                Object comparable = ModelBakery.func_209592_a(property, s2);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + property.func_177700_c());
                }
                map.put(property, comparable);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        Block block = (Block)containerIn.func_177622_c();
        return state2 -> {
            if (state2 != null && block == state2.func_177230_c()) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(state2.func_177229_b((Property)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T func_209592_a(Property<T> property, String value) {
        return (T)property.func_185929_b(value).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUnbakedModel func_209597_a(ResourceLocation modelLocation) {
        if (this.field_217849_F.containsKey(modelLocation)) {
            return this.field_217849_F.get(modelLocation);
        }
        if (this.field_217848_D.contains(modelLocation)) {
            throw new IllegalStateException("Circular reference while loading " + modelLocation);
        }
        this.field_217848_D.add(modelLocation);
        IUnbakedModel iunbakedmodel = this.field_217849_F.get(field_177604_a);
        while (!this.field_217848_D.isEmpty()) {
            ResourceLocation resourcelocation = this.field_217848_D.iterator().next();
            try {
                if (this.field_217849_F.containsKey(resourcelocation)) continue;
                this.func_209598_b(resourcelocation);
            }
            catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                field_177603_c.warn(modelbakery$blockstatedefinitionexception.getMessage());
                this.field_217849_F.put(resourcelocation, iunbakedmodel);
            }
            catch (Exception exception) {
                field_177603_c.warn("Unable to load model: '{}' referenced from: {}: {}", (Object)resourcelocation, (Object)modelLocation, (Object)exception);
                this.field_217849_F.put(resourcelocation, iunbakedmodel);
            }
            finally {
                this.field_217848_D.remove(resourcelocation);
            }
        }
        return this.field_217849_F.getOrDefault(modelLocation, iunbakedmodel);
    }

    private void func_209598_b(ResourceLocation blockstateLocation) throws Exception {
        if (!(blockstateLocation instanceof ModelResourceLocation)) {
            this.func_209593_a(blockstateLocation, (IUnbakedModel)this.func_177594_c(blockstateLocation));
        } else {
            ModelResourceLocation modelresourcelocation = (ModelResourceLocation)blockstateLocation;
            if (Objects.equals(modelresourcelocation.func_177518_c(), "inventory")) {
                ResourceLocation resourcelocation2 = new ResourceLocation(blockstateLocation.func_110624_b(), "item/" + blockstateLocation.func_110623_a());
                BlockModel blockmodel = this.func_177594_c(resourcelocation2);
                this.func_209593_a((ResourceLocation)modelresourcelocation, (IUnbakedModel)blockmodel);
                this.field_217849_F.put(resourcelocation2, (IUnbakedModel)blockmodel);
            } else {
                ResourceLocation resourcelocation = new ResourceLocation(blockstateLocation.func_110624_b(), blockstateLocation.func_110623_a());
                StateContainer statecontainer = Optional.ofNullable(field_209607_C.get(resourcelocation)).orElseGet(() -> ((Block)Registry.field_212618_g.func_82594_a(resourcelocation)).func_176194_O());
                this.field_209610_F.func_209573_a(statecontainer);
                ImmutableList list = ImmutableList.copyOf((Collection)this.field_225365_D.func_225310_a((Block)statecontainer.func_177622_c()));
                ImmutableList immutablelist = statecontainer.func_177619_a();
                HashMap map = Maps.newHashMap();
                immutablelist.forEach(state2 -> {
                    BlockState blockstate = map.put(BlockModelShapes.func_209553_a((ResourceLocation)resourcelocation, (BlockState)state2), state2);
                });
                HashMap map1 = Maps.newHashMap();
                ResourceLocation resourcelocation1 = new ResourceLocation(blockstateLocation.func_110624_b(), "blockstates/" + blockstateLocation.func_110623_a() + ".json");
                IUnbakedModel iunbakedmodel = this.field_217849_F.get(field_177604_a);
                ModelListWrapper modelbakery$modellistwrapper = new ModelListWrapper((List<IUnbakedModel>)ImmutableList.of((Object)iunbakedmodel), (List<Object>)ImmutableList.of());
                Pair pair = Pair.of((Object)iunbakedmodel, () -> modelbakery$modellistwrapper);
                try {
                    List list1;
                    try {
                        list1 = this.field_177598_f.func_199004_b(resourcelocation1).stream().map(resource -> {
                            try (InputStream inputstream = resource.func_199027_b();){
                                Pair pair = Pair.of((Object)resource.func_199026_d(), (Object)BlockModelDefinition.func_209577_a((BlockModelDefinition.ContainerHolder)this.field_209610_F, (Reader)new InputStreamReader(inputstream, StandardCharsets.UTF_8)));
                                return pair;
                            }
                            catch (Exception exception1) {
                                throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s' in resourcepack: '%s': %s", resource.func_199029_a(), resource.func_199026_d(), exception1.getMessage()));
                            }
                        }).collect(Collectors.toList());
                    }
                    catch (IOException ioexception) {
                        field_177603_c.warn("Exception loading blockstate definition: {}: {}", (Object)resourcelocation1, (Object)ioexception);
                        HashMap lvt_20_1_ = Maps.newHashMap();
                        map.forEach((resourceLocation, state2) -> {
                            Pair pair2 = (Pair)map1.get(state2);
                            if (pair2 == null) {
                                field_177603_c.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)resourcelocation1, resourceLocation);
                                pair2 = pair;
                            }
                            this.func_209593_a((ResourceLocation)resourceLocation, (IUnbakedModel)pair2.getFirst());
                            try {
                                ModelListWrapper modelbakery$modellistwrapper1 = (ModelListWrapper)((Supplier)pair2.getSecond()).get();
                                lvt_20_1_.computeIfAbsent(modelbakery$modellistwrapper1, listWrapper -> Sets.newIdentityHashSet()).add(state2);
                            }
                            catch (Exception exception1) {
                                field_177603_c.warn("Exception evaluating model definition: '{}' : {}", resourceLocation, (Object)exception1.getMessage());
                            }
                        });
                        lvt_20_1_.forEach((listWrapper, stateSet) -> {
                            Iterator iterator2 = stateSet.iterator();
                            while (iterator2.hasNext()) {
                                BlockState blockstate = (BlockState)iterator2.next();
                                if (blockstate.func_185901_i() == BlockRenderType.MODEL) continue;
                                iterator2.remove();
                                this.field_225367_M.put((Object)blockstate, 0);
                            }
                            if (stateSet.size() > 1) {
                                this.func_225352_a((Iterable<BlockState>)stateSet);
                            }
                        });
                        return;
                    }
                    for (Pair pair1 : list1) {
                        Multipart multipart;
                        BlockModelDefinition blockmodeldefinition = (BlockModelDefinition)pair1.getSecond();
                        IdentityHashMap map2 = Maps.newIdentityHashMap();
                        if (blockmodeldefinition.func_188002_b()) {
                            multipart = blockmodeldefinition.func_188001_c();
                            immutablelist.forEach(arg_0 -> ModelBakery.lambda$loadBlockstate$19(map2, multipart, (List)list, arg_0));
                        } else {
                            multipart = null;
                        }
                        blockmodeldefinition.func_209578_a().forEach((arg_0, arg_1) -> ModelBakery.lambda$loadBlockstate$23(immutablelist, statecontainer, map2, (List)list, multipart, pair, blockmodeldefinition, resourcelocation1, pair1, arg_0, arg_1));
                        map1.putAll(map2);
                    }
                }
                catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                    throw modelbakery$blockstatedefinitionexception;
                }
                catch (Exception exception) {
                    throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s': %s", resourcelocation1, exception));
                }
                finally {
                    HashMap lvt_20_1_ = Maps.newHashMap();
                    map.forEach((resourceLocation, state2) -> {
                        Pair pair2 = (Pair)map1.get(state2);
                        if (pair2 == null) {
                            field_177603_c.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)resourcelocation1, resourceLocation);
                            pair2 = pair;
                        }
                        this.func_209593_a((ResourceLocation)resourceLocation, (IUnbakedModel)pair2.getFirst());
                        try {
                            ModelListWrapper modelbakery$modellistwrapper1 = (ModelListWrapper)((Supplier)pair2.getSecond()).get();
                            lvt_20_1_.computeIfAbsent(modelbakery$modellistwrapper1, listWrapper -> Sets.newIdentityHashSet()).add(state2);
                        }
                        catch (Exception exception1) {
                            field_177603_c.warn("Exception evaluating model definition: '{}' : {}", resourceLocation, (Object)exception1.getMessage());
                        }
                    });
                    lvt_20_1_.forEach((listWrapper, stateSet) -> {
                        Iterator iterator2 = stateSet.iterator();
                        while (iterator2.hasNext()) {
                            BlockState blockstate = (BlockState)iterator2.next();
                            if (blockstate.func_185901_i() == BlockRenderType.MODEL) continue;
                            iterator2.remove();
                            this.field_225367_M.put((Object)blockstate, 0);
                        }
                        if (stateSet.size() > 1) {
                            this.func_225352_a((Iterable<BlockState>)stateSet);
                        }
                    });
                }
            }
        }
    }

    private void func_209593_a(ResourceLocation locationIn, IUnbakedModel modelIn) {
        this.field_217849_F.put(locationIn, modelIn);
        this.field_217848_D.addAll(modelIn.func_187965_e());
    }

    private void addModelToCache(ResourceLocation locationIn) {
        IUnbakedModel iunbakedmodel = this.func_209597_a(locationIn);
        this.field_217849_F.put(locationIn, iunbakedmodel);
        this.field_217851_H.put(locationIn, iunbakedmodel);
    }

    private void func_217843_a(ModelResourceLocation locationIn) {
        IUnbakedModel iunbakedmodel = this.func_209597_a((ResourceLocation)locationIn);
        this.field_217849_F.put((ResourceLocation)locationIn, iunbakedmodel);
        this.field_217851_H.put((ResourceLocation)locationIn, iunbakedmodel);
    }

    private void func_225352_a(Iterable<BlockState> blockStatesIn) {
        int i2 = this.field_225366_L++;
        blockStatesIn.forEach(state2 -> this.field_225367_M.put(state2, i2));
    }

    @Nullable
    @Deprecated
    public IBakedModel func_217845_a(ResourceLocation locationIn, IModelTransform transformIn) {
        return this.getBakedModel(locationIn, transformIn, arg_0 -> ((SpriteMap)this.field_229322_z_).func_229151_a_(arg_0));
    }

    @Nullable
    public IBakedModel getBakedModel(ResourceLocation locationIn, IModelTransform transformIn, Function<RenderMaterial, TextureAtlasSprite> textureGetter) {
        BlockModel blockmodel;
        Triple triple = Triple.of((Object)locationIn, (Object)transformIn.func_225615_b_(), (Object)transformIn.func_188049_c());
        if (this.field_217850_G.containsKey(triple)) {
            return this.field_217850_G.get(triple);
        }
        if (this.field_229322_z_ == null) {
            throw new IllegalStateException("bake called too early");
        }
        IUnbakedModel iunbakedmodel = this.func_209597_a(locationIn);
        if (iunbakedmodel instanceof BlockModel && (blockmodel = (BlockModel)iunbakedmodel).func_178310_f() == field_177606_o) {
            return field_217854_z.func_209579_a(textureGetter, blockmodel).func_228813_a_(this, blockmodel, arg_0 -> ((SpriteMap)this.field_229322_z_).func_229151_a_(arg_0), transformIn, locationIn, false);
        }
        IBakedModel ibakedmodel = iunbakedmodel.func_225613_a_(this, textureGetter, transformIn, locationIn);
        this.field_217850_G.put((Triple<ResourceLocation, TransformationMatrix, Boolean>)triple, ibakedmodel);
        return ibakedmodel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockModel func_177594_c(ResourceLocation location) throws IOException {
        BlockModel blockmodel;
        IResource iresource;
        Reader reader;
        block8: {
            String s;
            block9: {
                reader = null;
                iresource = null;
                s = location.func_110623_a();
                if ("builtin/generated".equals(s)) break block8;
                if (!"builtin/entity".equals(s)) break block9;
                BlockModel blockModel2 = field_177616_r;
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(iresource);
                return blockModel2;
            }
            if (s.startsWith("builtin/")) {
                String s2 = s.substring("builtin/".length());
                String s1 = field_177600_d.get(s2);
                if (s1 == null) {
                    throw new FileNotFoundException(location.toString());
                }
                reader = new StringReader(s1);
            } else {
                iresource = this.field_177598_f.func_199002_a(new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json"));
                reader = new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8);
            }
            BlockModel blockmodel2 = BlockModel.func_178307_a((Reader)reader);
            blockmodel2.field_178317_b = location.toString();
            BlockModel blockModel3 = blockmodel2;
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Closeable)iresource);
            return blockModel3;
        }
        try {
            blockmodel = field_177606_o;
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(iresource);
        }
        return blockmodel;
    }

    public Map<ResourceLocation, IBakedModel> func_217846_a() {
        return this.field_217852_I;
    }

    public Object2IntMap<BlockState> func_225354_b() {
        return this.field_225367_M;
    }

    public Set<ResourceLocation> getSpecialModels() {
        return Collections.emptySet();
    }

    public SpriteMap getSpriteMap() {
        return this.field_229322_z_;
    }

    private static /* synthetic */ void lambda$loadBlockstate$23(ImmutableList immutablelist, StateContainer statecontainer, Map map2, List list, Multipart multipart, Pair pair, BlockModelDefinition blockmodeldefinition, ResourceLocation resourcelocation1, Pair pair1, String name, VariantList variantList) {
        try {
            immutablelist.stream().filter(ModelBakery.func_209605_a((StateContainer<Block, BlockState>)statecontainer, name)).forEach(state2 -> {
                Pair pair2 = map2.put(state2, Pair.of((Object)variantList, () -> ModelListWrapper.func_225336_a(state2, (IUnbakedModel)variantList, list)));
                if (pair2 != null && pair2.getFirst() != multipart) {
                    map2.put(state2, pair);
                    throw new RuntimeException("Overlapping definition with: " + (String)blockmodeldefinition.func_209578_a().entrySet().stream().filter(nameToVariantList -> nameToVariantList.getValue() == pair2.getFirst()).findFirst().get().getKey());
                }
            });
        }
        catch (Exception exception1) {
            field_177603_c.warn("Exception loading blockstate definition: '{}' in resourcepack: '{}' for variant: '{}': {}", (Object)resourcelocation1, pair1.getFirst(), (Object)name, (Object)exception1.getMessage());
        }
    }

    private static /* synthetic */ void lambda$loadBlockstate$19(Map map2, Multipart multipart, List list, BlockState state2) {
        Pair pair2 = map2.put(state2, Pair.of((Object)multipart, () -> ModelListWrapper.func_225335_a(state2, multipart, list)));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ModelListWrapper {
        private final List<IUnbakedModel> field_225339_a;
        private final List<Object> field_225340_b;

        public ModelListWrapper(List<IUnbakedModel> modelsIn, List<Object> colorValuesIn) {
            this.field_225339_a = modelsIn;
            this.field_225340_b = colorValuesIn;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof ModelListWrapper)) {
                return false;
            }
            ModelListWrapper modelbakery$modellistwrapper = (ModelListWrapper)p_equals_1_;
            return Objects.equals(this.field_225339_a, modelbakery$modellistwrapper.field_225339_a) && Objects.equals(this.field_225340_b, modelbakery$modellistwrapper.field_225340_b);
        }

        public int hashCode() {
            return 31 * this.field_225339_a.hashCode() + this.field_225340_b.hashCode();
        }

        public static ModelListWrapper func_225335_a(BlockState blockStateIn, Multipart multipartIn, Collection<Property<?>> propertiesIn) {
            StateContainer statecontainer = blockStateIn.func_177230_c().func_176194_O();
            List list = (List)multipartIn.func_188136_a().stream().filter(selector -> selector.func_188166_a(statecontainer).test(blockStateIn)).map(Selector::func_188165_a).collect(ImmutableList.toImmutableList());
            List<Object> list1 = ModelListWrapper.func_225337_a(blockStateIn, propertiesIn);
            return new ModelListWrapper(list, list1);
        }

        public static ModelListWrapper func_225336_a(BlockState blockStateIn, IUnbakedModel modelIn, Collection<Property<?>> propertiesIn) {
            List<Object> list = ModelListWrapper.func_225337_a(blockStateIn, propertiesIn);
            return new ModelListWrapper((List<IUnbakedModel>)ImmutableList.of((Object)modelIn), list);
        }

        private static List<Object> func_225337_a(BlockState blockStateIn, Collection<Property<?>> propertiesIn) {
            return (List)propertiesIn.stream().map(arg_0 -> ((BlockState)blockStateIn).func_177229_b(arg_0)).collect(ImmutableList.toImmutableList());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BlockStateDefinitionException
    extends RuntimeException {
        public BlockStateDefinitionException(String message) {
            super(message);
        }
    }
}

