/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.biome;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarvers;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.hardcoredungeons.registry.HEntities;
import thedarkcolour.hardcoredungeons.registry.HFeatures;
import thedarkcolour.hardcoredungeons.registry.HSurfaceBuilders;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015J\u001e\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0019*\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001cJ+\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0019*\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001d2\u0006\u0010\u001e\u001a\u0002H\u0019\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\nH\u0002J\u0006\u0010!\u001a\u00020\u0004J\u0006\u0010\"\u001a\u00020\u0004J\u0006\u0010#\u001a\u00020\u0004J\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020\u0004J\u0006\u0010&\u001a\u00020\u0004J\u0006\u0010'\u001a\u00020\u0004J\u0006\u0010(\u001a\u00020\u0004J\u0006\u0010)\u001a\u00020\u0004J\u0006\u0010*\u001a\u00020\u0004J\u0006\u0010+\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u0013J6\u0010,\u001a\u00020\u0013*\u00020\u00132\u0006\u0010-\u001a\u00020.2\n\u0010/\u001a\u0006\u0012\u0002\b\u0003002\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u0015J\n\u00104\u001a\u000205*\u00020\u0013\u00a8\u00066"}, d2={"Lthedarkcolour/hardcoredungeons/biome/HBiomeMaker;", "", "()V", "biome", "Lnet/minecraft/world/biome/Biome;", "precipitation", "Lnet/minecraft/world/biome/Biome$RainType;", "category", "Lnet/minecraft/world/biome/Biome$Category;", "depth", "", "scale", "temperature", "downfall", "effects", "Lnet/minecraft/world/biome/BiomeAmbience$Builder;", "genSettings", "Lnet/minecraft/world/biome/BiomeGenerationSettings$Builder;", "spawnSettings", "Lnet/minecraft/world/biome/MobSpawnInfo$Builder;", "waterColor", "", "waterFogColor", "skyColor", "skyFogColor", "C", "Lnet/minecraft/world/gen/surfacebuilders/ISurfaceBuilderConfig;", "surfaceBuilder", "Lnet/minecraft/world/gen/surfacebuilders/ConfiguredSurfaceBuilder;", "Lnet/minecraft/world/gen/surfacebuilders/SurfaceBuilder;", "config", "(Lnet/minecraft/world/gen/surfacebuilders/SurfaceBuilder;Lnet/minecraft/world/gen/surfacebuilders/ISurfaceBuilderConfig;)Lnet/minecraft/world/biome/BiomeGenerationSettings$Builder;", "getSkyForTemp", "makeAubrumMountainsBiome", "makeAubrumWastelandBiome", "makeAuriPlainsBiome", "makeCandyPlainsBiome", "makeCastletonHillsBiome", "makeGoldenForestBiome", "makeGumdropFieldsBiome", "makeKnightlyShrublandBiome", "makeMushroomCliffsBiome", "makeRainbowPlainsBiome", "makeThickForestBiome", "addSpawn", "classification", "Lnet/minecraft/entity/EntityClassification;", "entityType", "Lnet/minecraft/entity/EntityType;", "weight", "min", "max", "build", "Lnet/minecraft/world/biome/MobSpawnInfo;", "hardcoredungeons"})
public final class HBiomeMaker {
    @NotNull
    public static final HBiomeMaker INSTANCE = new HBiomeMaker();

    private HBiomeMaker() {
    }

    @NotNull
    public final Biome makeCastletonHillsBiome() {
        BiomeGenerationSettings.Builder genSettings = this.genSettings(HSurfaceBuilders.INSTANCE.getCASTLETON_SURFACE());
        genSettings.func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.field_243767_a);
        HFeatures.INSTANCE.addSparseLumlightTrees(genSettings);
        HFeatures.INSTANCE.addPurpleLumshrooms(genSettings);
        DefaultBiomeFeatures.func_243729_am((BiomeGenerationSettings.Builder)genSettings);
        return HBiomeMaker.biome$default(this, Biome.RainType.NONE, Biome.Category.PLAINS, 1.5f, 0.07f, 1.5f, 0.0f, this.effects(7316415, 2045938, 1129809, 1923701), genSettings, null, 256, null);
    }

    @NotNull
    public final Biome makeKnightlyShrublandBiome() {
        BiomeGenerationSettings.Builder genSettings = this.genSettings(HSurfaceBuilders.INSTANCE.getCASTLETON_SURFACE());
        HFeatures.INSTANCE.withLumlightCabin(genSettings);
        HFeatures.INSTANCE.withLumlightShrubs(genSettings);
        MobSpawnInfo.Builder spawnSettings = this.spawnSettings();
        this.addSpawn(spawnSettings, EntityClassification.CREATURE, HEntities.INSTANCE.getCASTLETON_DEER(), 6, 2, 6);
        return HBiomeMaker.biome$default(this, Biome.RainType.NONE, Biome.Category.PLAINS, 0.1f, 0.3f, 1.5f, 0.0f, this.effects(7316415, 2045938, 1129809, 1923701), genSettings, null, 256, null);
    }

    @NotNull
    public final Biome makeRainbowPlainsBiome() {
        BiomeGenerationSettings.Builder genSettings = this.genSettings(HSurfaceBuilders.INSTANCE.getRAINBOWLAND_SURFACE());
        HFeatures.INSTANCE.withRainbowlandOres(genSettings);
        HFeatures.INSTANCE.withRainbowlandStructures(genSettings);
        return HBiomeMaker.biome$default(this, Biome.RainType.NONE, Biome.Category.PLAINS, 0.1f, 0.2f, 1.5f, 0.0f, this.effects(5245106, 6430706, 13612031, 14911695), genSettings, null, 256, null);
    }

    @NotNull
    public final Biome makeThickForestBiome() {
        SurfaceBuilder surfaceBuilder = HSurfaceBuilders.INSTANCE.getTHICK_FOREST();
        SurfaceBuilderConfig surfaceBuilderConfig = SurfaceBuilder.field_215423_t;
        Intrinsics.checkNotNullExpressionValue((Object)surfaceBuilderConfig, (String)"PODZOL_DIRT_GRAVEL_CONFIG");
        BiomeGenerationSettings.Builder genSettings = this.genSettings(surfaceBuilder, (ISurfaceBuilderConfig)surfaceBuilderConfig);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243690_D((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243710_X((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243763_w((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243708_V((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)genSettings);
        HFeatures.INSTANCE.withOakShrubs(genSettings);
        MobSpawnInfo.Builder spawnSettings = this.spawnSettings();
        EntityType entityType = EntityType.field_200737_ac;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"SHEEP");
        this.addSpawn(spawnSettings, EntityClassification.CREATURE, entityType, 12, 4, 4);
        this.addSpawn(spawnSettings, EntityClassification.CREATURE, HEntities.INSTANCE.getDEER(), 7, 2, 3);
        entityType = EntityType.field_200791_e;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"BAT");
        this.addSpawn(spawnSettings, EntityClassification.AMBIENT, entityType, 8, 8, 8);
        entityType = EntityType.field_200748_an;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"SPIDER");
        this.addSpawn(spawnSettings, EntityClassification.MONSTER, entityType, 100, 4, 4);
        entityType = EntityType.field_200725_aD;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"ZOMBIE");
        this.addSpawn(spawnSettings, EntityClassification.MONSTER, entityType, 95, 4, 4);
        entityType = EntityType.field_200727_aF;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"ZOMBIE_VILLAGER");
        this.addSpawn(spawnSettings, EntityClassification.MONSTER, entityType, 5, 1, 1);
        entityType = EntityType.field_200741_ag;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"SKELETON");
        this.addSpawn(spawnSettings, EntityClassification.MONSTER, entityType, 100, 4, 4);
        entityType = EntityType.field_200797_k;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"CREEPER");
        this.addSpawn(spawnSettings, EntityClassification.MONSTER, entityType, 100, 4, 4);
        entityType = EntityType.field_200743_ai;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"SLIME");
        this.addSpawn(spawnSettings, EntityClassification.MONSTER, entityType, 100, 4, 4);
        entityType = EntityType.field_200803_q;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"ENDERMAN");
        this.addSpawn(spawnSettings, EntityClassification.MONSTER, entityType, 10, 1, 4);
        entityType = EntityType.field_200759_ay;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"WITCH");
        this.addSpawn(spawnSettings, EntityClassification.MONSTER, entityType, 5, 1, 1);
        return this.biome(Biome.RainType.RAIN, Biome.Category.FOREST, 0.2f, 0.25f, 0.7f, 0.8f, this.effects(4159204, 329011, this.getSkyForTemp(0.7f), 12638463), genSettings, spawnSettings);
    }

    @NotNull
    public final Biome makeMushroomCliffsBiome() {
        SurfaceBuilder surfaceBuilder = SurfaceBuilder.field_215396_G;
        Intrinsics.checkNotNullExpressionValue((Object)surfaceBuilder, (String)"DEFAULT");
        BiomeGenerationSettings.Builder genSettings = this.genSettings(surfaceBuilder, (ISurfaceBuilderConfig)SurfaceBuilder.field_215393_D);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243703_Q((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)genSettings);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)genSettings);
        HFeatures.INSTANCE.withShroomyBoulders(genSettings);
        return HBiomeMaker.biome$default(this, Biome.RainType.NONE, Biome.Category.MUSHROOM, 0.3625f, 1.225f, 0.9f, 1.0f, this.effects(4159204, 329011, this.getSkyForTemp(0.9f), 12638463), genSettings, null, 256, null);
    }

    @NotNull
    public final Biome makeAubrumWastelandBiome() {
        BiomeGenerationSettings.Builder genSettings = this.genSettings(HSurfaceBuilders.INSTANCE.getAUBRUM_WASTELAND_SURFACE());
        return HBiomeMaker.biome$default(this, Biome.RainType.NONE, Biome.Category.PLAINS, 0.02f, 0.4f, 1.5f, 0.0f, this.effects(0x669900, 2045938, 11244896, 12889980), genSettings, null, 256, null);
    }

    @NotNull
    public final Biome makeGoldenForestBiome() {
        BiomeGenerationSettings.Builder genSettings = this.genSettings(HSurfaceBuilders.INSTANCE.getAUBRUM_WASTELAND_SURFACE());
        return HBiomeMaker.biome$default(this, Biome.RainType.NONE, Biome.Category.MUSHROOM, 0.3625f, 0.1f, 1.5f, 0.0f, this.effects(0xFFBB33, 2045938, 11244896, 12889980), genSettings, null, 256, null);
    }

    @NotNull
    public final Biome makeAubrumMountainsBiome() {
        BiomeGenerationSettings.Builder genSettings = this.genSettings(HSurfaceBuilders.INSTANCE.getAUBRUM_WASTELAND_SURFACE());
        return HBiomeMaker.biome$default(this, Biome.RainType.NONE, Biome.Category.MUSHROOM, 0.3625f, 1.225f, 1.5f, 0.0f, this.effects(0x888888, 2045938, 11244896, 12889980), genSettings, null, 256, null);
    }

    @NotNull
    public final Biome makeAuriPlainsBiome() {
        BiomeGenerationSettings.Builder genSettings = this.genSettings(HSurfaceBuilders.INSTANCE.getAUBRUM_WASTELAND_SURFACE());
        HFeatures.INSTANCE.withAubrumFlowers(genSettings);
        return HBiomeMaker.biome$default(this, Biome.RainType.NONE, Biome.Category.MUSHROOM, 0.02f, 0.1f, 1.5f, 0.0f, this.effects(0x999966, 2045938, 11244896, 12889980), genSettings, null, 256, null);
    }

    @NotNull
    public final Biome makeGumdropFieldsBiome() {
        BiomeGenerationSettings.Builder genSettings = this.genSettings(HSurfaceBuilders.INSTANCE.getSUGARY_SURFACE());
        MobSpawnInfo.Builder spawnSettings = this.spawnSettings();
        return this.biome(Biome.RainType.NONE, Biome.Category.PLAINS, 0.04f, 0.2f, 1.5f, 0.4f, this.effects(13736924, 329011, this.getSkyForTemp(0.9f), 12638463), genSettings, spawnSettings);
    }

    @NotNull
    public final Biome makeCandyPlainsBiome() {
        BiomeGenerationSettings.Builder genSettings = this.genSettings(HSurfaceBuilders.INSTANCE.getSUGARY_SURFACE());
        MobSpawnInfo.Builder spawnSettings = this.spawnSettings();
        HFeatures.INSTANCE.withSparseCandyCanes(genSettings);
        HFeatures.INSTANCE.withSparseChocolateBars(genSettings);
        return this.biome(Biome.RainType.NONE, Biome.Category.PLAINS, 0.04f, 0.2f, 1.5f, 0.4f, this.effects(13736924, 329011, this.getSkyForTemp(0.9f), 12638463), genSettings, spawnSettings);
    }

    @NotNull
    public final Biome biome(@NotNull Biome.RainType precipitation, @NotNull Biome.Category category, float depth, float scale, float temperature, float downfall, @NotNull BiomeAmbience.Builder effects, @NotNull BiomeGenerationSettings.Builder genSettings, @Nullable MobSpawnInfo.Builder spawnSettings) {
        Intrinsics.checkNotNullParameter((Object)precipitation, (String)"precipitation");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)effects, (String)"effects");
        Intrinsics.checkNotNullParameter((Object)genSettings, (String)"genSettings");
        MobSpawnInfo.Builder builder = spawnSettings;
        Biome biome = new Biome.Builder().func_205415_a(precipitation).func_205419_a(category).func_205421_a(depth).func_205420_b(scale).func_205414_c(temperature).func_205417_d(downfall).func_235097_a_(effects.func_235238_a_()).func_242457_a(genSettings.func_242508_a()).func_242458_a(builder == null ? MobSpawnInfo.field_242551_b : this.build(builder)).func_242455_a();
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"Builder()\n            .precipitation(precipitation)\n            .category(category)\n            .depth(depth)\n            .scale(scale)\n            .temperature(temperature)\n            .downfall(downfall)\n            .setEffects(effects.build())\n            .withGenerationSettings(genSettings.build())\n            .withMobSpawnSettings(spawnSettings?.build() ?: MobSpawnInfo.EMPTY)\n            .build()");
        return biome;
    }

    public static /* synthetic */ Biome biome$default(HBiomeMaker hBiomeMaker, Biome.RainType rainType, Biome.Category category, float f, float f2, float f3, float f4, BiomeAmbience.Builder builder, BiomeGenerationSettings.Builder builder2, MobSpawnInfo.Builder builder3, int n, Object object) {
        if ((n & 0x100) != 0) {
            builder3 = null;
        }
        return hBiomeMaker.biome(rainType, category, f, f2, f3, f4, builder, builder2, builder3);
    }

    @NotNull
    public final BiomeAmbience.Builder effects(int waterColor, int waterFogColor, int skyColor, int skyFogColor) {
        BiomeAmbience.Builder builder = new BiomeAmbience.Builder().func_235246_b_(waterColor).func_235248_c_(waterFogColor).func_242539_d(skyColor).func_235239_a_(skyFogColor);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder()\n            .setWaterColor(waterColor)\n            .setWaterFogColor(waterFogColor)\n            .withSkyColor(skyColor)\n            .setFogColor(skyFogColor)");
        return builder;
    }

    @NotNull
    public final <C extends ISurfaceBuilderConfig> BiomeGenerationSettings.Builder genSettings(@NotNull SurfaceBuilder<C> surfaceBuilder, @NotNull C config) {
        Intrinsics.checkNotNullParameter(surfaceBuilder, (String)"surfaceBuilder");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(surfaceBuilder.func_242929_a(config));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder().withSurfaceBuilder(surfaceBuilder.func_242929_a(config))");
        return builder;
    }

    @NotNull
    public final <C extends ISurfaceBuilderConfig> BiomeGenerationSettings.Builder genSettings(@NotNull ConfiguredSurfaceBuilder<C> surfaceBuilder) {
        Intrinsics.checkNotNullParameter(surfaceBuilder, (String)"surfaceBuilder");
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(surfaceBuilder);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder().withSurfaceBuilder(surfaceBuilder)");
        return builder;
    }

    @NotNull
    public final MobSpawnInfo.Builder spawnSettings() {
        return new MobSpawnInfo.Builder();
    }

    @NotNull
    public final MobSpawnInfo build(@NotNull MobSpawnInfo.Builder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"<this>");
        MobSpawnInfo mobSpawnInfo = $this$build.func_242577_b();
        Intrinsics.checkNotNullExpressionValue((Object)mobSpawnInfo, (String)"copy()");
        return mobSpawnInfo;
    }

    @NotNull
    public final MobSpawnInfo.Builder addSpawn(@NotNull MobSpawnInfo.Builder $this$addSpawn, @NotNull EntityClassification classification, @NotNull EntityType<?> entityType, int weight, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)$this$addSpawn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classification, (String)"classification");
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        MobSpawnInfo.Builder builder = $this$addSpawn.func_242575_a(classification, new MobSpawnInfo.Spawners(entityType, weight, min, max));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"withSpawner(classification, MobSpawnInfo.Spawners(entityType, weight, min, max))");
        return builder;
    }

    private final int getSkyForTemp(float temperature) {
        float a = MathHelper.func_76131_a((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - a * 0.05f), (float)(0.5f + a * 0.1f), (float)1.0f);
    }
}

