/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.block.misc;

import java.text.DecimalFormat;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.hardcoredungeons.block.HBlock;
import thedarkcolour.hardcoredungeons.block.properties.HProperties;
import thedarkcolour.hardcoredungeons.registry.ExtensionsKt;
import thedarkcolour.hardcoredungeons.registry.HBlocks;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lthedarkcolour/hardcoredungeons/block/misc/CompressedBlock;", "", "block", "Lkotlin/Function0;", "Lnet/minecraft/block/Block;", "properties", "Lthedarkcolour/hardcoredungeons/block/properties/HProperties;", "(Lkotlin/jvm/functions/Function0;Lthedarkcolour/hardcoredungeons/block/properties/HProperties;)V", "getBlock", "()Lkotlin/jvm/functions/Function0;", "blockVariants", "", "Lthedarkcolour/hardcoredungeons/block/HBlock;", "getBlockVariants", "()[Lthedarkcolour/hardcoredungeons/block/HBlock;", "setBlockVariants", "([Lthedarkcolour/hardcoredungeons/block/HBlock;)V", "[Lthedarkcolour/hardcoredungeons/block/HBlock;", "compressionLevel", "", "getCompressedName", "", "registerBlocks", "", "registry", "Lnet/minecraftforge/registries/IForgeRegistry;", "Companion", "Variant", "hardcoredungeons"})
public final class CompressedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Block> block;
    @Nullable
    private final HProperties properties;
    public HBlock[] blockVariants;
    @NotNull
    private static final String[] compressionLevelNames;

    public CompressedBlock(@NotNull Function0<? extends Block> block, @Nullable HProperties properties) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.block = block;
        this.properties = properties;
    }

    @NotNull
    public final Function0<Block> getBlock() {
        return this.block;
    }

    @NotNull
    public final HBlock[] getBlockVariants() {
        HBlock[] hBlockArray = this.blockVariants;
        if (hBlockArray != null) {
            return hBlockArray;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"blockVariants");
        throw null;
    }

    public final void setBlockVariants(@NotNull HBlock[] hBlockArray) {
        Intrinsics.checkNotNullParameter((Object)hBlockArray, (String)"<set-?>");
        this.blockVariants = hBlockArray;
    }

    public final void registerBlocks(@NotNull IForgeRegistry<Block> registry) {
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        Block block = (Block)this.block.invoke();
        HProperties hProperties = this.properties;
        HProperties properties = hProperties == null ? (block instanceof HBlock ? (HProperties)HProperties.Companion.from((HBlock)block) : (HProperties)HProperties.Companion.fromVanilla(block)) : hProperties;
        int n = 0;
        HBlock[] hBlockArray = new HBlock[8];
        while (n < 8) {
            int n2 = n++;
            hBlockArray[n2] = (HBlock)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)new Variant(n2 + 1, properties), this.getCompressedName(n2));
        }
        this.setBlockVariants(hBlockArray);
        for (HBlock variant : this.getBlockVariants()) {
            HBlocks.registerSimpleBlock$default(HBlocks.INSTANCE, registry, variant, null, 2, null);
        }
    }

    private final String getCompressedName(int compressionLevel) {
        String string = compressionLevelNames[compressionLevel];
        ResourceLocation resourceLocation = ((Block)this.block.invoke()).getRegistryName();
        Intrinsics.checkNotNull((Object)resourceLocation);
        return Intrinsics.stringPlus((String)string, (Object)resourceLocation.func_110623_a());
    }

    @NotNull
    public final HBlock getBlock(int compressionLevel) {
        return this.getBlockVariants()[compressionLevel];
    }

    static {
        String[] stringArray = new String[]{"compressed_", "double_compressed_", "triple_compressed_", "quadruple_compressed_", "quintuple_compressed_", "sextuple_compressed_", "septuple_compressed_", "octuple_compressed_"};
        compressionLevelNames = stringArray;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lthedarkcolour/hardcoredungeons/block/misc/CompressedBlock$Variant;", "Lthedarkcolour/hardcoredungeons/block/HBlock;", "compressionLevel", "", "properties", "Lthedarkcolour/hardcoredungeons/block/properties/HProperties;", "(ILthedarkcolour/hardcoredungeons/block/properties/HProperties;)V", "tooltip", "Lnet/minecraft/util/text/ITextComponent;", "getTooltip", "()Lnet/minecraft/util/text/ITextComponent;", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/IBlockReader;", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "hardcoredungeons"})
    private static final class Variant
    extends HBlock {
        @NotNull
        private final ITextComponent tooltip;

        public Variant(int compressionLevel, @NotNull HProperties properties) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            super(properties);
            double d = 9.0;
            double d2 = compressionLevel;
            boolean bl = false;
            double amount = Math.pow(d, d2);
            DecimalFormat format = new DecimalFormat("#,###");
            IFormattableTextComponent iFormattableTextComponent = new StringTextComponent(Intrinsics.stringPlus((String)format.format(amount), (Object)" Blocks")).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY));
            Intrinsics.checkNotNullExpressionValue((Object)iFormattableTextComponent, (String)"StringTextComponent(format.format(amount) + \" Blocks\").setStyle(Style.EMPTY.setFormatting(TextFormatting.GRAY))");
            this.tooltip = (ITextComponent)iFormattableTextComponent;
        }

        @NotNull
        public final ITextComponent getTooltip() {
            return this.tooltip;
        }

        public void func_190948_a(@NotNull ItemStack stack, @Nullable IBlockReader worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
            Intrinsics.checkNotNullParameter((Object)flagIn, (String)"flagIn");
            tooltip.add(this.tooltip);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lthedarkcolour/hardcoredungeons/block/misc/CompressedBlock$Companion;", "", "()V", "compressionLevelNames", "", "", "[Ljava/lang/String;", "hardcoredungeons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

