/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.block.misc;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J(\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lthedarkcolour/hardcoredungeons/block/misc/GrassBlock;", "Lnet/minecraft/block/Block;", "soil", "Lkotlin/Function0;", "Lnet/minecraft/block/BlockState;", "nocturnal", "", "plantableTag", "Lnet/minecraft/tags/ITag;", "properties", "Lnet/minecraft/block/AbstractBlock$Properties;", "(Lkotlin/jvm/functions/Function0;ZLnet/minecraft/tags/ITag;Lnet/minecraft/block/AbstractBlock$Properties;)V", "canSpread", "state", "world", "Lnet/minecraft/world/server/ServerWorld;", "abovePos", "Lnet/minecraft/util/math/BlockPos;", "canSurvive", "canSustainPlant", "Lnet/minecraft/world/IBlockReader;", "pos", "facing", "Lnet/minecraft/util/Direction;", "plantable", "Lnet/minecraftforge/common/IPlantable;", "onPlantGrow", "", "Lnet/minecraft/world/IWorld;", "source", "tick", "random", "Ljava/util/Random;", "hardcoredungeons"})
public final class GrassBlock
extends Block {
    @NotNull
    private final Function0<BlockState> soil;
    private final boolean nocturnal;
    @NotNull
    private final ITag<Block> plantableTag;

    public GrassBlock(@NotNull Function0<? extends BlockState> soil, boolean nocturnal, @NotNull ITag<Block> plantableTag, @NotNull AbstractBlock.Properties properties) {
        Intrinsics.checkNotNullParameter(soil, (String)"soil");
        Intrinsics.checkNotNullParameter(plantableTag, (String)"plantableTag");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.soil = soil;
        this.nocturnal = nocturnal;
        this.plantableTag = plantableTag;
    }

    public void func_225534_a_(@NotNull BlockState state2, @NotNull ServerWorld world, @NotNull BlockPos pos, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        BlockPos abovePos = pos.func_177984_a();
        BlockState blockState = world.func_180495_p(abovePos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"world.getBlockState(abovePos)");
        Intrinsics.checkNotNullExpressionValue((Object)abovePos, (String)"abovePos");
        if (!this.canSurvive(blockState, world, abovePos)) {
            if (world.isAreaLoaded(pos, 3)) {
                world.func_175656_a(pos, (BlockState)this.soil.invoke());
            }
        } else if (world.func_201696_r(abovePos) >= 9 || this.nocturnal && world.func_175710_j(pos)) {
            int n = 0;
            do {
                int i2 = n++;
                BlockPos randomPos = abovePos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (!Intrinsics.areEqual((Object)world.func_180495_p(randomPos), (Object)this.soil.invoke()) || !this.canSpread(state2, world, abovePos)) continue;
                world.func_175656_a(randomPos, this.func_176223_P());
            } while (n <= 3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canSurvive(BlockState state2, ServerWorld world, BlockPos abovePos) {
        int i2;
        if (Intrinsics.areEqual((Object)state2.func_177230_c(), (Object)Blocks.field_150433_aE)) {
            Integer n = (Integer)state2.func_177229_b((Property)SnowBlock.field_176315_a);
            int n2 = 1;
            if (n != null && n == n2) {
                return true;
            }
        }
        if ((i2 = LightEngine.func_215613_a((IBlockReader)((IBlockReader)world), (BlockState)state2, (BlockPos)abovePos, (BlockState)state2, (BlockPos)abovePos, (Direction)Direction.UP, (int)state2.func_200016_a((IBlockReader)world, abovePos))) >= world.func_201572_C()) return false;
        return true;
    }

    private final boolean canSpread(BlockState state2, ServerWorld world, BlockPos abovePos) {
        return this.canSurvive(state2, world, abovePos) && !world.func_204610_c(abovePos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public void onPlantGrow(@NotNull BlockState state2, @NotNull IWorld world, @NotNull BlockPos pos, @NotNull BlockPos source) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (state2.func_235714_a_((ITag)Tags.Blocks.DIRT)) {
            world.func_180501_a(pos, (BlockState)this.soil.invoke(), 2);
        }
    }

    public boolean canSustainPlant(@NotNull BlockState state2, @NotNull IBlockReader world, @NotNull BlockPos pos, @NotNull Direction facing, @NotNull IPlantable plantable) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)plantable, (String)"plantable");
        return plantable.getPlant(world, pos.func_177972_a(facing)).func_235714_a_(this.plantableTag);
    }
}

