/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.block.portal;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.hardcoredungeons.block.properties.HProperties;
import thedarkcolour.hardcoredungeons.capability.PlayerHelper;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u001c\u0010\u0019\u001a\u00020\u00142\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u001bH\u0014J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0016J(\u0010!\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lthedarkcolour/hardcoredungeons/block/portal/PortalBlock;", "Lnet/minecraft/block/Block;", "dimensionKey", "Lkotlin/Function0;", "Lnet/minecraft/util/RegistryKey;", "Lnet/minecraft/world/World;", "frameState", "Lnet/minecraft/block/BlockState;", "properties", "Lthedarkcolour/hardcoredungeons/block/properties/HProperties;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lthedarkcolour/hardcoredungeons/block/properties/HProperties;)V", "canTeleport", "", "state", "worldIn", "pos", "Lnet/minecraft/util/math/BlockPos;", "entityIn", "Lnet/minecraft/entity/Entity;", "constructMatchingPortal", "", "destination", "Lnet/minecraft/world/IWorld;", "origin", "tpLocation", "fillStateContainer", "builder", "Lnet/minecraft/state/StateContainer$Builder;", "getShape", "Lnet/minecraft/util/math/shapes/VoxelShape;", "Lnet/minecraft/world/IBlockReader;", "ctx", "Lnet/minecraft/util/math/shapes/ISelectionContext;", "onEntityCollision", "blockPos", "Companion", "hardcoredungeons"})
public final class PortalBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<RegistryKey<World>> dimensionKey;
    @NotNull
    private final Function0<BlockState> frameState;
    private static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    private static final VoxelShape X_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape Z_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public PortalBlock(@NotNull Function0<? extends RegistryKey<World>> dimensionKey, @NotNull Function0<? extends BlockState> frameState, @NotNull HProperties properties) {
        Intrinsics.checkNotNullParameter(dimensionKey, (String)"dimensionKey");
        Intrinsics.checkNotNullParameter(frameState, (String)"frameState");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.build());
        this.dimensionKey = dimensionKey;
        this.frameState = frameState;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)AXIS, (Comparable)Direction.Axis.X));
    }

    public void func_196262_a(@NotNull BlockState state2, @NotNull World worldIn, @NotNull BlockPos blockPos, @NotNull Entity entityIn) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        BlockPos.Mutable pos = blockPos.func_239590_i_();
        if (!worldIn.field_72995_K) {
            Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
            if (this.canTeleport(state2, worldIn, (BlockPos)pos, entityIn)) {
                ServerWorld serverWorld;
                if (!(entityIn instanceof ServerPlayerEntity) || PlayerHelper.INSTANCE.getPortalCooldown((PlayerEntity)entityIn) > 0) {
                    return;
                }
                RegistryKey key = (RegistryKey)this.dimensionKey.invoke();
                RegistryKey type = Intrinsics.areEqual((Object)worldIn.func_234923_W_(), (Object)key) ? World.field_234918_g_ : key;
                MinecraftServer minecraftServer = worldIn.func_73046_m();
                Intrinsics.checkNotNull((Object)minecraftServer);
                ServerWorld serverWorld2 = minecraftServer.func_71218_a(type);
                if (serverWorld2 == null) {
                    return;
                }
                ServerWorld destination2 = serverWorld = serverWorld2;
                double portalOffset = 0.0;
                double x = ((ServerPlayerEntity)entityIn).func_226277_ct_();
                double z = ((ServerPlayerEntity)entityIn).func_226281_cx_();
                BlockPos.Mutable mutable = new BlockPos.Mutable(x, portalOffset, z);
                while ((portalOffset += 1.0) < 255.0 && !Intrinsics.areEqual((Object)destination2.func_180495_p((BlockPos)mutable.func_189532_c(x, portalOffset, z)).func_177230_c(), (Object)((Object)this))) {
                }
                if (!Intrinsics.areEqual((Object)destination2.func_180495_p((BlockPos)mutable).func_177230_c(), (Object)((Object)this))) {
                    portalOffset = 0.0;
                    mutable.func_189532_c(x, 0.0, z);
                    while ((portalOffset += 1.0) < 255.0 && !destination2.func_175623_d((BlockPos)mutable.func_189532_c(x, portalOffset, z))) {
                    }
                }
                PlayerHelper.INSTANCE.setPortalCooldown((PlayerEntity)entityIn, 30);
                ArrayList effects = new ArrayList(((ServerPlayerEntity)entityIn).func_70651_bq());
                ((ServerPlayerEntity)entityIn).func_200619_a(destination2, (double)((ServerPlayerEntity)entityIn).func_233580_cy_().func_177958_n(), portalOffset += 1.0, (double)((ServerPlayerEntity)entityIn).func_233580_cy_().func_177952_p(), entityIn.field_70177_z, entityIn.field_70125_A);
                for (EffectInstance effect : effects) {
                    ((ServerPlayerEntity)entityIn).func_195064_c(effect);
                }
                if (!Intrinsics.areEqual((Object)destination2.func_180495_p(new BlockPos((double)((ServerPlayerEntity)entityIn).func_233580_cy_().func_177958_n(), portalOffset, (double)((ServerPlayerEntity)entityIn).func_233580_cy_().func_177952_p())), (Object)state2)) {
                    IWorld iWorld = (IWorld)destination2;
                    IWorld iWorld2 = (IWorld)worldIn;
                    BlockPos blockPos2 = (BlockPos)pos;
                    BlockPos blockPos3 = ((ServerPlayerEntity)entityIn).func_233580_cy_();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"entityIn.position");
                    this.constructMatchingPortal(iWorld, iWorld2, blockPos2, blockPos3, state2);
                }
            }
        }
    }

    private final void constructMatchingPortal(IWorld destination2, IWorld origin, BlockPos pos, BlockPos tpLocation, BlockState state2) {
        Direction.Axis axis = (Direction.Axis)state2.func_177229_b((Property)AXIS);
        BlockPos.Mutable testCursor = pos.func_239590_i_();
        int endY = pos.func_177956_o();
        int startY = pos.func_177956_o();
        BlockState frame = (BlockState)this.frameState.invoke();
        while (Intrinsics.areEqual((Object)origin.func_180495_p((BlockPos)testCursor.func_196234_d(0, -1, 0)).func_177230_c(), (Object)((Object)this))) {
            --startY;
        }
        testCursor.func_189533_g((Vector3i)pos);
        while (Intrinsics.areEqual((Object)origin.func_180495_p((BlockPos)testCursor.func_196234_d(0, 1, 0)).func_177230_c(), (Object)((Object)this))) {
            ++endY;
        }
        testCursor.func_189533_g((Vector3i)pos);
        int minY = tpLocation.func_177956_o() - 1;
        int maxY = tpLocation.func_177956_o() + endY - pos.func_177956_o() + 1;
        if (axis == Direction.Axis.X) {
            int startX = pos.func_177958_n();
            int endX = pos.func_177958_n();
            while (Intrinsics.areEqual((Object)origin.func_180495_p((BlockPos)testCursor.func_196234_d(-1, 0, 0)).func_177230_c(), (Object)((Object)this))) {
                --startX;
            }
            testCursor.func_189533_g((Vector3i)pos);
            while (Intrinsics.areEqual((Object)origin.func_180495_p((BlockPos)testCursor.func_196234_d(1, 0, 0)).func_177230_c(), (Object)((Object)this))) {
                ++endX;
            }
            if (endX - startX < 1 || endY - startY < 2) {
                return;
            }
            int minX = startX - 1;
            int maxX = endX + 1;
            for (BlockPos cursor : BlockPos.func_191531_b((int)minX, (int)minY, (int)pos.func_177952_p(), (int)maxX, (int)maxY, (int)pos.func_177952_p())) {
                if (cursor.func_177958_n() == minX || cursor.func_177958_n() == maxX || cursor.func_177956_o() == minY || cursor.func_177956_o() == maxY) {
                    destination2.func_180501_a(cursor, frame, 18);
                    continue;
                }
                destination2.func_180501_a(cursor, state2, 18);
            }
        } else {
            int startZ = pos.func_177952_p();
            int endZ = pos.func_177952_p();
            while (Intrinsics.areEqual((Object)origin.func_180495_p((BlockPos)testCursor.func_196234_d(0, 0, -1)).func_177230_c(), (Object)((Object)this))) {
                --startZ;
            }
            testCursor.func_189533_g((Vector3i)pos);
            while (Intrinsics.areEqual((Object)origin.func_180495_p((BlockPos)testCursor.func_196234_d(0, 0, 1)).func_177230_c(), (Object)((Object)this))) {
                ++endZ;
            }
            if (endZ - startZ < 1 || endY - startY < 2) {
                return;
            }
            int minZ = startZ - 1;
            int maxZ = endZ + 1;
            for (BlockPos cursor : BlockPos.func_191531_b((int)pos.func_177958_n(), (int)minY, (int)minZ, (int)pos.func_177958_n(), (int)maxY, (int)maxZ)) {
                if (cursor.func_177952_p() == minZ || cursor.func_177952_p() == maxZ || cursor.func_177956_o() == minY || cursor.func_177956_o() == maxY) {
                    destination2.func_180501_a(cursor, frame, 18);
                    continue;
                }
                destination2.func_180501_a(cursor, state2, 18);
            }
        }
    }

    private final boolean canTeleport(BlockState state2, World worldIn, BlockPos pos, Entity entityIn) {
        return !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU() && VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entityIn.func_174813_aQ().func_72317_d(-((double)pos.func_177958_n()), -((double)pos.func_177956_o()), -((double)pos.func_177952_p()))), (VoxelShape)state2.func_196954_c((IBlockReader)worldIn, pos), (IBooleanFunction)IBooleanFunction.field_223238_i_);
    }

    protected void func_206840_a(@NotNull StateContainer.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{(Property)AXIS};
        builder.func_206894_a(propertyArray);
    }

    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState state2, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext ctx) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (state2.func_177229_b((Property)AXIS) == Direction.Axis.X) {
            VoxelShape voxelShape2 = X_SHAPE;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"{\n            X_SHAPE\n        }");
            voxelShape = voxelShape2;
        } else {
            VoxelShape voxelShape3 = Z_SHAPE;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"{\n            Z_SHAPE\n        }");
            voxelShape = voxelShape3;
        }
        return voxelShape;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lthedarkcolour/hardcoredungeons/block/portal/PortalBlock$Companion;", "", "()V", "AXIS", "Lnet/minecraft/state/EnumProperty;", "Lnet/minecraft/util/Direction$Axis;", "kotlin.jvm.PlatformType", "X_SHAPE", "Lnet/minecraft/util/math/shapes/VoxelShape;", "Z_SHAPE", "hardcoredungeons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

