/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.hardcoredungeons.client.model.entity.DoeModel;
import thedarkcolour.hardcoredungeons.client.model.entity.StagModel;
import thedarkcolour.hardcoredungeons.client.renderer.entity.layers.DeerFullbrightLayer;
import thedarkcolour.hardcoredungeons.entity.ReloadableRenderer;
import thedarkcolour.hardcoredungeons.entity.overworld.deer.DeerEntity;
import thedarkcolour.hardcoredungeons.entity.overworld.deer.DeerType;
import thedarkcolour.hardcoredungeons.util.UtilKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001d2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J8\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lthedarkcolour/hardcoredungeons/client/renderer/entity/DeerRenderer;", "Lthedarkcolour/hardcoredungeons/entity/ReloadableRenderer;", "Lthedarkcolour/hardcoredungeons/entity/overworld/deer/DeerEntity;", "Lthedarkcolour/hardcoredungeons/client/model/entity/DoeModel;", "manager", "Lnet/minecraft/client/renderer/entity/EntityRendererManager;", "(Lnet/minecraft/client/renderer/entity/EntityRendererManager;)V", "alpha", "", "doe", "stag", "Lthedarkcolour/hardcoredungeons/client/model/entity/StagModel;", "getEntityTexture", "Lnet/minecraft/util/ResourceLocation;", "entity", "getOverlayTexture", "Lnet/minecraft/client/renderer/RenderType;", "reload", "", "render", "entityYaw", "", "partialTicks", "stack", "Lcom/mojang/blaze3d/matrix/MatrixStack;", "buffer", "Lnet/minecraft/client/renderer/IRenderTypeBuffer;", "light", "", "Companion", "hardcoredungeons"})
public final class DeerRenderer
extends ReloadableRenderer<DeerEntity, DoeModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DoeModel doe;
    @NotNull
    private StagModel stag;
    @Nullable
    private Void alpha;
    @NotNull
    private static final ResourceLocation FOREST_STAG = UtilKt.modLoc("textures/entity/deer/overworld/forest_stag.png");
    @NotNull
    private static final ResourceLocation BLUE_EYED_FEMALE = UtilKt.modLoc("textures/entity/deer/castleton/blue_eyed_female.png");
    private static final RenderType BLUE_EYED_FEMALE_OVERLAY = RenderType.func_228652_i_((ResourceLocation)UtilKt.modLoc("textures/entity/deer/castleton/blue_eyed_female_overlay.png"));
    @NotNull
    private static final ResourceLocation BLUE_EYED_STAG = UtilKt.modLoc("textures/entity/deer/castleton/blue_eyed_stag.png");
    private static final RenderType BLUE_EYED_STAG_OVERLAY = RenderType.func_228652_i_((ResourceLocation)UtilKt.modLoc("textures/entity/deer/castleton/blue_eyed_stag_overlay.png"));
    @NotNull
    private static final ResourceLocation BLUE_SPOTTED_STAG = UtilKt.modLoc("textures/entity/deer/castleton/spotted_stag.png");
    private static final RenderType BLUE_SPOTTED_STAG_OVERLAY = RenderType.func_228652_i_((ResourceLocation)UtilKt.modLoc("textures/entity/deer/castleton/blue_spotted_stag_overlay.png"));
    @NotNull
    private static final ResourceLocation PURPLE_SPOTTED_STAG = UtilKt.modLoc("textures/entity/deer/castleton/spotted_stag.png");
    private static final RenderType PURPLE_SPOTTED_STAG_OVERLAY = RenderType.func_228652_i_((ResourceLocation)UtilKt.modLoc("textures/entity/deer/castleton/purple_spotted_stag_overlay.png"));
    @NotNull
    private static final ResourceLocation THEDARKCOLOUR = UtilKt.modLoc("textures/entity/deer/thedarkcolour.png");
    private static final RenderType THEDARKCOLOUR_OVERLAY = RenderType.func_228652_i_((ResourceLocation)UtilKt.modLoc("textures/entity/deer/thedarkcolour_overlay.png"));

    public DeerRenderer(@NotNull EntityRendererManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(manager, null, 0.4f);
        this.doe = new DoeModel();
        this.stag = new StagModel();
        this.func_177094_a(new DeerFullbrightLayer(this));
    }

    public void render(@NotNull DeerEntity entity2, float entityYaw, float partialTicks, @NotNull MatrixStack stack, @NotNull IRenderTypeBuffer buffer, int light2) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity2), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.field_77045_g = (EntityModel)(entity2.isTheDarkColour() ? (DoeModel)this.stag : (entity2.getDeerType().isStag() ? (DoeModel)this.stag : (entity2.getDeerType().isDoe() ? this.doe : (entity2.getDeerType().isAlpha() ? (DoeModel)((Object)this.alpha) : this.doe))));
        super.func_225623_a_((MobEntity)entity2, entityYaw, partialTicks, stack, buffer, light2);
    }

    @NotNull
    public ResourceLocation getEntityTexture(@NotNull DeerEntity entity2) {
        ResourceLocation resourceLocation;
        Intrinsics.checkNotNullParameter((Object)((Object)entity2), (String)"entity");
        if (entity2.isTheDarkColour()) {
            return THEDARKCOLOUR;
        }
        DeerType deerType = entity2.getDeerType();
        int n = WhenMappings.$EnumSwitchMapping$0[deerType.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                resourceLocation = FOREST_STAG;
                break;
            }
            case 3: {
                resourceLocation = BLUE_EYED_FEMALE;
                break;
            }
            case 4: {
                resourceLocation = BLUE_EYED_STAG;
                break;
            }
            case 5: {
                resourceLocation = BLUE_SPOTTED_STAG;
                break;
            }
            case 6: {
                resourceLocation = PURPLE_SPOTTED_STAG;
                break;
            }
            default: {
                resourceLocation = BLUE_EYED_FEMALE;
            }
        }
        return resourceLocation;
    }

    @Nullable
    public final RenderType getOverlayTexture(@NotNull DeerEntity entity2) {
        RenderType renderType;
        Intrinsics.checkNotNullParameter((Object)((Object)entity2), (String)"entity");
        if (entity2.isTheDarkColour()) {
            return THEDARKCOLOUR_OVERLAY;
        }
        DeerType deerType = entity2.getDeerType();
        int n = WhenMappings.$EnumSwitchMapping$0[deerType.ordinal()];
        switch (n) {
            case 4: {
                renderType = BLUE_EYED_STAG_OVERLAY;
                break;
            }
            case 3: {
                renderType = BLUE_EYED_FEMALE_OVERLAY;
                break;
            }
            case 5: {
                renderType = BLUE_SPOTTED_STAG_OVERLAY;
                break;
            }
            case 6: {
                renderType = PURPLE_SPOTTED_STAG_OVERLAY;
                break;
            }
            default: {
                renderType = null;
            }
        }
        return renderType;
    }

    @Override
    public void reload() {
        this.doe = new DoeModel();
        this.stag = new StagModel();
        this.alpha = null;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lthedarkcolour/hardcoredungeons/client/renderer/entity/DeerRenderer$Companion;", "", "()V", "BLUE_EYED_FEMALE", "Lnet/minecraft/util/ResourceLocation;", "BLUE_EYED_FEMALE_OVERLAY", "Lnet/minecraft/client/renderer/RenderType;", "kotlin.jvm.PlatformType", "BLUE_EYED_STAG", "BLUE_EYED_STAG_OVERLAY", "BLUE_SPOTTED_STAG", "BLUE_SPOTTED_STAG_OVERLAY", "FOREST_STAG", "PURPLE_SPOTTED_STAG", "PURPLE_SPOTTED_STAG_OVERLAY", "THEDARKCOLOUR", "THEDARKCOLOUR_OVERLAY", "hardcoredungeons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeerType.values().length];
            nArray[DeerType.FOREST_STAG.ordinal()] = 1;
            nArray[DeerType.FOREST_DOE.ordinal()] = 2;
            nArray[DeerType.BLUE_EYED_DOE.ordinal()] = 3;
            nArray[DeerType.BLUE_EYED_STAG.ordinal()] = 4;
            nArray[DeerType.BLUE_SPOTTED_STAG.ordinal()] = 5;
            nArray[DeerType.PURPLE_SPOTTED_STAG.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

