/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.entity.castleton.infinity;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.hardcoredungeons.entity.HEntityType;
import thedarkcolour.hardcoredungeons.entity.castleton.infinity.BlackStarEntity;
import thedarkcolour.hardcoredungeons.registry.HEntities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0005\u001e\u001f !\"B\u001d\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0012H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity;", "Lnet/minecraft/entity/LivingEntity;", "entityType", "Lnet/minecraft/entity/EntityType;", "worldIn", "Lnet/minecraft/world/World;", "(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V", "engagedPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "isIdle", "", "attackEntityFrom", "source", "Lnet/minecraft/util/DamageSource;", "damage", "", "getArmorInventoryList", "", "Lnet/minecraft/item/ItemStack;", "getItemStackFromSlot", "slotIn", "Lnet/minecraft/inventory/EquipmentSlotType;", "getPrimaryHand", "Lnet/minecraft/util/HandSide;", "getTrajectory", "Lnet/minecraft/util/math/vector/Vector3d;", "target", "setItemStackToSlot", "", "stack", "AwaitPlayerAI", "Companion", "CrossAttack", "InfinityGoal", "ShootBlackStars", "hardcoredungeons"})
public final class InfinityEntity
extends LivingEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isIdle;
    @Nullable
    private PlayerEntity engagedPlayer;
    @NotNull
    private static final AttributeModifierMap.MutableAttribute ATTRIBUTES;

    public InfinityEntity(@NotNull EntityType<? extends LivingEntity> entityType, @NotNull World worldIn) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        super(entityType, worldIn);
        this.isIdle = true;
    }

    @NotNull
    public Iterable<ItemStack> func_184193_aE() {
        return CollectionsKt.emptyList();
    }

    public void func_184201_a(@NotNull EquipmentSlotType slotIn, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)slotIn, (String)"slotIn");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
    }

    @NotNull
    public ItemStack func_184582_a(@NotNull EquipmentSlotType slotIn) {
        Intrinsics.checkNotNullParameter((Object)slotIn, (String)"slotIn");
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    @NotNull
    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }

    public boolean func_70097_a(@NotNull DamageSource source, float damage) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!Intrinsics.areEqual((Object)source.func_76346_g(), (Object)source.func_76364_f())) {
            bl = false;
        } else if (source instanceof PlayerEntity && !(source instanceof FakePlayer) && Intrinsics.areEqual((Object)this.engagedPlayer, (Object)source)) {
            this.func_70665_d(source, 0.5f);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Vector3d getTrajectory(@NotNull PlayerEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Vector3d vector3d = target.func_213303_ch().func_178788_d(this.func_213303_ch());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"target.positionVec.subtract(positionVec)");
        return vector3d;
    }

    static {
        AttributeModifierMap.MutableAttribute mutableAttribute = AttributeModifierMap.func_233803_a_().func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233814_a_(Attributes.field_233821_d_).func_233814_a_(Attributes.field_233826_i_).func_233814_a_(Attributes.field_233827_j_).func_233814_a_((Attribute)ForgeMod.SWIM_SPEED.get()).func_233814_a_((Attribute)ForgeMod.NAMETAG_DISTANCE.get()).func_233814_a_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233814_a_(Attributes.field_233824_g_);
        Intrinsics.checkNotNullExpressionValue((Object)mutableAttribute, (String)"createMutableAttribute()\n            .createMutableAttribute(Attributes.MAX_HEALTH, 300.0)\n            .createMutableAttribute(Attributes.KNOCKBACK_RESISTANCE, 1.0)\n            .createMutableAttribute(Attributes.MOVEMENT_SPEED)\n            .createMutableAttribute(Attributes.ARMOR)\n            .createMutableAttribute(Attributes.ARMOR_TOUGHNESS)\n            .createMutableAttribute(ForgeMod.SWIM_SPEED.get())\n            .createMutableAttribute(ForgeMod.NAMETAG_DISTANCE.get())\n            .createMutableAttribute(ForgeMod.ENTITY_GRAVITY.get())\n            .createMutableAttribute(Attributes.FOLLOW_RANGE, 16.0)\n            .createMutableAttribute(Attributes.ATTACK_KNOCKBACK)");
        ATTRIBUTES = mutableAttribute;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity$InfinityGoal;", "Lnet/minecraft/entity/ai/goal/Goal;", "infinity", "Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity;", "(Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity;)V", "getInfinity", "()Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity;", "shouldExecute", "", "hardcoredungeons"})
    public static class InfinityGoal
    extends Goal {
        @NotNull
        private final InfinityEntity infinity;

        public InfinityGoal(@NotNull InfinityEntity infinity) {
            Intrinsics.checkNotNullParameter((Object)((Object)infinity), (String)"infinity");
            this.infinity = infinity;
        }

        @NotNull
        public final InfinityEntity getInfinity() {
            return this.infinity;
        }

        public boolean func_75250_a() {
            return !this.infinity.isIdle && this.infinity.engagedPlayer != null;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity$Companion;", "", "()V", "ATTRIBUTES", "Lnet/minecraft/entity/ai/attributes/AttributeModifierMap$MutableAttribute;", "getATTRIBUTES", "()Lnet/minecraft/entity/ai/attributes/AttributeModifierMap$MutableAttribute;", "hardcoredungeons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeModifierMap.MutableAttribute getATTRIBUTES() {
            return ATTRIBUTES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity$AwaitPlayerAI;", "", "()V", "hardcoredungeons"})
    public static final class AwaitPlayerAI {
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity$ShootBlackStars;", "Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity$InfinityGoal;", "infinity", "Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity;", "target", "Lnet/minecraft/entity/player/PlayerEntity;", "(Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity;Lnet/minecraft/entity/player/PlayerEntity;)V", "progress", "", "getProgress", "()I", "setProgress", "(I)V", "getTarget", "()Lnet/minecraft/entity/player/PlayerEntity;", "resetTask", "", "shouldContinueExecuting", "", "tick", "hardcoredungeons"})
    public static final class ShootBlackStars
    extends InfinityGoal {
        @NotNull
        private final PlayerEntity target;
        private int progress;

        public ShootBlackStars(@NotNull InfinityEntity infinity, @NotNull PlayerEntity target) {
            Intrinsics.checkNotNullParameter((Object)((Object)infinity), (String)"infinity");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super(infinity);
            this.target = target;
        }

        @NotNull
        public final PlayerEntity getTarget() {
            return this.target;
        }

        public final int getProgress() {
            return this.progress;
        }

        public final void setProgress(int n) {
            this.progress = n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean func_75253_b() {
            if (!this.func_75250_a()) return false;
            ShootBlackStars shootBlackStars = this;
            int n = shootBlackStars.progress;
            shootBlackStars.progress = n + 1;
            if (n >= 200) return false;
            return true;
        }

        public void func_75251_c() {
            this.progress = 0;
        }

        public void func_75246_d() {
            if (this.progress % 4 == 0) {
                HEntityType<BlackStarEntity> hEntityType = HEntities.INSTANCE.getBLACK_STAR();
                World world = this.getInfinity().field_70170_p;
                Intrinsics.checkNotNullExpressionValue((Object)world, (String)"infinity.world");
                BlackStarEntity entity2 = hEntityType.invoke(world);
                Vector3d trajectory = this.getInfinity().getTrajectory(this.target);
                LivingEntity livingEntity = this.getInfinity();
                Vector3d vector3d = this.getInfinity().func_213303_ch();
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"infinity.positionVec");
                Vector3d vector3d2 = vector3d;
                vector3d = trajectory.func_216372_d(0.1, 0.1, 0.1);
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"trajectory.mul(0.1, 0.1, 0.1)");
                entity2.shoot(livingEntity, vector3d2, vector3d);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lthedarkcolour/hardcoredungeons/entity/castleton/infinity/InfinityEntity$CrossAttack;", "", "()V", "hardcoredungeons"})
    public static final class CrossAttack {
    }
}

