/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.entity.overworld.deer;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.hardcoredungeons.entity.overworld.deer.DeerEntity;
import thedarkcolour.hardcoredungeons.entity.overworld.deer.DeerType;
import thedarkcolour.hardcoredungeons.registry.HItems;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ6\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0004\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lthedarkcolour/hardcoredungeons/entity/overworld/deer/CastletonDeerEntity;", "Lthedarkcolour/hardcoredungeons/entity/overworld/deer/DeerEntity;", "type", "Lnet/minecraft/entity/EntityType;", "worldIn", "Lnet/minecraft/world/World;", "(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V", "getDefaultType", "Lthedarkcolour/hardcoredungeons/entity/overworld/deer/DeerType;", "isBreedingItem", "", "stack", "Lnet/minecraft/item/ItemStack;", "isSameColor", "goalOwner", "Lnet/minecraft/entity/MobEntity;", "onInitialSpawn", "Lnet/minecraft/entity/ILivingEntityData;", "Lnet/minecraft/world/IServerWorld;", "difficultyIn", "Lnet/minecraft/world/DifficultyInstance;", "reason", "Lnet/minecraft/entity/SpawnReason;", "spawnDataIn", "dataTag", "Lnet/minecraft/nbt/CompoundNBT;", "pickRandomPattern", "hardcoredungeons"})
public final class CastletonDeerEntity
extends DeerEntity {
    public CastletonDeerEntity(@NotNull EntityType<CastletonDeerEntity> type, @NotNull World worldIn) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        super(type, worldIn);
    }

    @Override
    public boolean func_70877_b(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)HItems.INSTANCE.getWILD_BERROOK());
    }

    @Override
    @NotNull
    public DeerType getDefaultType() {
        return this.pickRandomPattern();
    }

    private final DeerType pickRandomPattern() {
        DeerType deerType;
        block1: {
            float f;
            block0: {
                f = this.field_70146_Z.nextFloat();
                boolean bl = 0.0f <= f ? f <= 0.24f : false;
                if (!bl) break block0;
                deerType = DeerType.BLUE_EYED_DOE;
                break block1;
            }
            deerType = (0.25f <= f ? f <= 0.49f : false) ? DeerType.PURPLE_SPOTTED_STAG : ((0.5f <= f ? f <= 0.74f : false) ? DeerType.BLUE_SPOTTED_STAG : DeerType.BLUE_EYED_STAG);
        }
        return deerType;
    }

    @Nullable
    public ILivingEntityData func_213386_a(@NotNull IServerWorld worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)difficultyIn, (String)"difficultyIn");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (this.getDeerType().isDoe()) {
            this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 0.7));
        } else if (this.getDeerType().isStag()) {
            this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.3, false));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public final boolean isSameColor(@NotNull MobEntity goalOwner) {
        Intrinsics.checkNotNullParameter((Object)goalOwner, (String)"goalOwner");
        if (!(goalOwner instanceof CastletonDeerEntity)) {
            return false;
        }
        return ((CastletonDeerEntity)goalOwner).getDeerType().isBlue() == ((CastletonDeerEntity)goalOwner).getDeerType().isBlue();
    }
}

