/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.entity.overworld.mazeboss;

import com.google.common.base.Preconditions;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.hardcoredungeons.registry.HEntities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0002&'B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0013H\u0014J\u001e\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lthedarkcolour/hardcoredungeons/entity/overworld/mazeboss/MazeBossEntity;", "Lnet/minecraft/entity/MobEntity;", "Lnet/minecraft/entity/IRangedAttackMob;", "worldIn", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "type", "Lnet/minecraft/entity/EntityType;", "(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V", "bounds", "Lnet/minecraft/util/math/AxisAlignedBB;", "isAgro", "", "mazeCenter", "Lnet/minecraft/util/math/BlockPos;", "spawnLocation", "timeSinceLastEarthquake", "", "attackEntityWithRangedAttack", "", "target", "Lnet/minecraft/entity/LivingEntity;", "distanceFactor", "", "canBeRidden", "entityIn", "Lnet/minecraft/entity/Entity;", "earthquake", "livingTick", "readAdditional", "compound", "Lnet/minecraft/nbt/CompoundNBT;", "registerGoals", "setSpawnLocation", "pos", "direction", "Lnet/minecraft/util/Direction;", "writeAdditional", "Companion", "WalkToCenterGoal", "hardcoredungeons"})
public final class MazeBossEntity
extends MobEntity
implements IRangedAttackMob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int timeSinceLastEarthquake;
    private boolean isAgro;
    @Nullable
    private BlockPos spawnLocation;
    @Nullable
    private BlockPos mazeCenter;
    @Nullable
    private AxisAlignedBB bounds;
    @NotNull
    private static final AttributeModifierMap.MutableAttribute ATTRIBUTES;

    public MazeBossEntity(@NotNull EntityType<MazeBossEntity> type, @NotNull World worldIn) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        super(type, worldIn);
        this.isAgro = true;
    }

    public MazeBossEntity(@NotNull World worldIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        this(HEntities.INSTANCE.getMAZE_BOSS(), worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new WalkToCenterGoal());
    }

    public void func_82196_d(@NotNull LivingEntity target, float distanceFactor) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
    }

    public final void setSpawnLocation(@NotNull BlockPos pos, @NotNull AxisAlignedBB bounds, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Preconditions.checkArgument((!(pos instanceof BlockPos.Mutable) ? 1 : 0) != 0);
        this.spawnLocation = pos;
        this.mazeCenter = pos.func_177967_a(direction, 11).func_177972_a(Direction.DOWN);
        this.bounds = bounds;
        this.isAgro = false;
    }

    public void func_70037_a(@NotNull CompoundNBT compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_70037_a(compound);
        if (compound.func_150297_b("SpawnLocation", 10)) {
            this.spawnLocation = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("SpawnLocation"));
        }
        this.timeSinceLastEarthquake = RangesKt.coerceIn((int)compound.func_74762_e("TimeSinceLastEarthquake"), (ClosedRange)((ClosedRange)new IntRange(0, 200)));
    }

    public void func_213281_b(@NotNull CompoundNBT compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.func_213281_b(compound);
        BlockPos spawnLocation = this.spawnLocation;
        if (spawnLocation != null) {
            compound.func_218657_a("SpawnLocation", (INBT)NBTUtil.func_186859_a((BlockPos)spawnLocation));
        }
        compound.func_74768_a("TimeSinceLastEarthquake", RangesKt.coerceIn((int)this.timeSinceLastEarthquake, (ClosedRange)((ClosedRange)new IntRange(0, 200))));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isAgro) {
            AxisAlignedBB bounds;
            Object object = this.bounds;
            AxisAlignedBB axisAlignedBB = bounds = object == null ? this.func_174813_aQ().func_72314_b(7.0, 3.0, 7.0) : object;
            if (!this.field_70170_p.field_72995_K) {
                object = this;
                int n = object.timeSinceLastEarthquake;
                object.timeSinceLastEarthquake = n + 1;
                if (n >= 200) {
                    this.timeSinceLastEarthquake = 0;
                    this.earthquake();
                } else if (this.timeSinceLastEarthquake % 100 == 0) {
                    List players = this.field_70170_p.func_217357_a(PlayerEntity.class, bounds);
                    for (PlayerEntity player : players) {
                        player.func_195064_c(new EffectInstance(Effects.field_76440_q, 50, 1, false, false));
                    }
                }
            }
        }
    }

    private final void earthquake() {
        AxisAlignedBB axisAlignedBB = this.bounds;
        AxisAlignedBB bounds = axisAlignedBB == null ? this.func_174813_aQ().func_72314_b(7.0, 3.0, 7.0) : axisAlignedBB;
        List players = this.field_70170_p.func_175647_a(PlayerEntity.class, bounds, EntityPredicates.field_180132_d);
        for (PlayerEntity player : players) {
            player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 1.4, 0.0));
            player.field_70133_I = true;
            for (ItemStack armorItem : player.func_184193_aE()) {
                if (armorItem.func_190926_b()) continue;
                if (player == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
                }
                armorItem.func_96631_a(1, this.field_70170_p.field_73012_v, (ServerPlayerEntity)player);
                this.func_70652_k((Entity)player);
            }
        }
    }

    protected boolean func_184228_n(@NotNull Entity entityIn) {
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        return false;
    }

    static {
        AttributeModifierMap.MutableAttribute mutableAttribute = AttributeModifierMap.func_233803_a_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233820_c_, 0.2).func_233814_a_(Attributes.field_233821_d_).func_233814_a_(Attributes.field_233826_i_).func_233814_a_(Attributes.field_233827_j_).func_233814_a_((Attribute)ForgeMod.SWIM_SPEED.get()).func_233814_a_((Attribute)ForgeMod.NAMETAG_DISTANCE.get()).func_233814_a_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233824_g_, 2.0).func_233815_a_(Attributes.field_233823_f_, 2.0);
        Intrinsics.checkNotNullExpressionValue((Object)mutableAttribute, (String)"createMutableAttribute()\n            .createMutableAttribute(Attributes.MAX_HEALTH, 20.0)\n            .createMutableAttribute(Attributes.KNOCKBACK_RESISTANCE, 0.2)\n            .createMutableAttribute(Attributes.MOVEMENT_SPEED)\n            .createMutableAttribute(Attributes.ARMOR)\n            .createMutableAttribute(Attributes.ARMOR_TOUGHNESS)\n            .createMutableAttribute(ForgeMod.SWIM_SPEED.get())\n            .createMutableAttribute(ForgeMod.NAMETAG_DISTANCE.get())\n            .createMutableAttribute(ForgeMod.ENTITY_GRAVITY.get())\n            .createMutableAttribute(Attributes.FOLLOW_RANGE, 16.0)\n            .createMutableAttribute(Attributes.ATTACK_KNOCKBACK, 2.0)\n            .createMutableAttribute(Attributes.ATTACK_DAMAGE, 2.0)");
        ATTRIBUTES = mutableAttribute;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lthedarkcolour/hardcoredungeons/entity/overworld/mazeboss/MazeBossEntity$WalkToCenterGoal;", "Lnet/minecraft/entity/ai/goal/Goal;", "(Lthedarkcolour/hardcoredungeons/entity/overworld/mazeboss/MazeBossEntity;)V", "resetTask", "", "shouldContinueExecuting", "", "shouldExecute", "startExecuting", "hardcoredungeons"})
    private final class WalkToCenterGoal
    extends Goal {
        public WalkToCenterGoal() {
            Intrinsics.checkNotNullParameter((Object)((Object)MazeBossEntity.this), (String)"this$0");
        }

        public boolean func_75250_a() {
            return !MazeBossEntity.this.isAgro && MazeBossEntity.this.mazeCenter != null;
        }

        public void func_75249_e() {
            BlockPos blockPos = MazeBossEntity.this.mazeCenter;
            Intrinsics.checkNotNull((Object)blockPos);
            BlockPos pos = blockPos;
            MazeBossEntity.this.field_70699_by.func_75492_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.5);
        }

        public boolean func_75253_b() {
            return !MazeBossEntity.this.field_70699_by.func_75500_f();
        }

        public void func_75251_c() {
            if (!Intrinsics.areEqual((Object)MazeBossEntity.this.func_233580_cy_(), (Object)MazeBossEntity.this.mazeCenter)) {
                MazeBossEntity.this.isAgro = true;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lthedarkcolour/hardcoredungeons/entity/overworld/mazeboss/MazeBossEntity$Companion;", "", "()V", "ATTRIBUTES", "Lnet/minecraft/entity/ai/attributes/AttributeModifierMap$MutableAttribute;", "getATTRIBUTES", "()Lnet/minecraft/entity/ai/attributes/AttributeModifierMap$MutableAttribute;", "hardcoredungeons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeModifierMap.MutableAttribute getATTRIBUTES() {
            return ATTRIBUTES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

