/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.entity.projectile.bullet;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.hardcoredungeons.entity.projectile.ProjectileEntity;
import thedarkcolour.hardcoredungeons.item.misc.GunItem;
import thedarkcolour.hardcoredungeons.registry.HItems;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u001d\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J@\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020\fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lthedarkcolour/hardcoredungeons/entity/projectile/bullet/SmallBulletEntity;", "Lthedarkcolour/hardcoredungeons/entity/projectile/ProjectileEntity;", "Lnet/minecraft/entity/IRendersAsItem;", "type", "Lnet/minecraft/entity/EntityType;", "worldIn", "Lnet/minecraft/world/World;", "(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V", "damage", "", "drop", "applyProperties", "", "gun", "Lthedarkcolour/hardcoredungeons/item/misc/GunItem;", "getItem", "Lnet/minecraft/item/ItemStack;", "invertMotion", "", "motion", "onImpact", "result", "Lnet/minecraft/util/math/RayTraceResult;", "shoot", "shooter", "Lnet/minecraft/entity/LivingEntity;", "x", "y", "z", "mX", "mY", "mZ", "tick", "Companion", "hardcoredungeons"})
public final class SmallBulletEntity
extends ProjectileEntity
implements IRendersAsItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float drop;
    private float damage;
    @NotNull
    private static final ItemStack ICON = new ItemStack((IItemProvider)HItems.INSTANCE.getBULLET());

    public SmallBulletEntity(@NotNull EntityType<? extends ProjectileEntity> type, @NotNull World worldIn) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        super(type, worldIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        SmallBulletEntity smallBulletEntity = this;
        smallBulletEntity.field_70233_c -= (double)this.drop;
        if (this.field_70173_aa == 100) {
            this.func_70106_y();
        }
    }

    @Override
    public void shoot(@NotNull LivingEntity shooter, double x, double y, double z, double mX, double mY, double mZ) {
        Intrinsics.checkNotNullParameter((Object)shooter, (String)"shooter");
        Item gun = shooter.func_184607_cu().func_77973_b();
        if (gun instanceof GunItem) {
            this.applyProperties((GunItem)gun);
            super.shoot(shooter, x, y, z, mX * (double)((GunItem)gun).getVelocity(), mY * (double)((GunItem)gun).getVelocity(), mZ * (double)((GunItem)gun).getVelocity());
        } else {
            super.shoot(shooter, x, y, z, mX, mY, mZ);
        }
    }

    private final void applyProperties(GunItem gun) {
        this.drop = gun.getDrop();
        this.damage = gun.getBulletDamage();
    }

    @Override
    protected void func_70227_a(@NotNull RayTraceResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.func_70227_a(result);
        if (!this.field_70170_p.field_72995_K) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                LivingEntity shooter = this.getShootingEntity();
                Entity entity2 = ((EntityRayTraceResult)result).func_216348_a();
                boolean flag = entity2.func_70097_a((DamageSource)new IndirectEntityDamageSource("arrow", (Entity)shooter, (Entity)this), this.damage);
                if (this.func_223314_ad() > 0) {
                    entity2.func_70015_d(this.func_223314_ad());
                }
                if (flag && shooter != null) {
                    this.func_174815_a(shooter, entity2);
                }
                this.func_70106_y();
            } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                this.func_70106_y();
                return;
            }
        }
    }

    private final double invertMotion(double motion) {
        return -1.0 / motion;
    }

    @NotNull
    public ItemStack func_184543_l() {
        return ICON;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lthedarkcolour/hardcoredungeons/entity/projectile/bullet/SmallBulletEntity$Companion;", "", "()V", "ICON", "Lnet/minecraft/item/ItemStack;", "hardcoredungeons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

