/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.registry;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.hardcoredungeons.biome.HBiomeMaker;
import thedarkcolour.hardcoredungeons.config.HConfig;
import thedarkcolour.hardcoredungeons.registry.ExtensionsKt;
import thedarkcolour.hardcoredungeons.registry.HFeatures;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0014\u0010$\u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R5\u0010\u001b\u001a&\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00040\u0004 \u001d*\u0012\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lthedarkcolour/hardcoredungeons/registry/HBiomes;", "", "()V", "AUBRUM_MOUNTAINS", "Lnet/minecraft/world/biome/Biome;", "getAUBRUM_MOUNTAINS", "()Lnet/minecraft/world/biome/Biome;", "AUBRUM_WASTELAND", "getAUBRUM_WASTELAND", "AURI_PLAINS", "getAURI_PLAINS", "CANDY_PLAINS", "getCANDY_PLAINS", "CASTLETON_HILLS", "getCASTLETON_HILLS", "GOLDEN_FOREST", "getGOLDEN_FOREST", "GUMDROP_FIELDS", "getGUMDROP_FIELDS", "KNIGHTLY_SHRUBLAND", "getKNIGHTLY_SHRUBLAND", "MUSHROOM_CLIFFS", "getMUSHROOM_CLIFFS", "RAINBOW_PLAINS", "getRAINBOW_PLAINS", "THICK_FOREST", "getTHICK_FOREST", "THICK_FOREST_KEY", "Lnet/minecraft/util/RegistryKey;", "kotlin.jvm.PlatformType", "getTHICK_FOREST_KEY", "()Lnet/minecraft/util/RegistryKey;", "biomeLoading", "", "event", "Lnet/minecraftforge/event/world/BiomeLoadingEvent;", "registerBiomes", "biomes", "Lnet/minecraftforge/registries/IForgeRegistry;", "hardcoredungeons"})
public final class HBiomes {
    @NotNull
    public static final HBiomes INSTANCE = new HBiomes();
    @NotNull
    private static final Biome THICK_FOREST = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeThickForestBiome(), "thick_forest");
    @NotNull
    private static final Biome MUSHROOM_CLIFFS = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeMushroomCliffsBiome(), "mushroom_cliffs");
    @NotNull
    private static final Biome AUBRUM_WASTELAND = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeAubrumWastelandBiome(), "aubrum_wasteland");
    @NotNull
    private static final Biome GOLDEN_FOREST = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeGoldenForestBiome(), "golden_forest");
    @NotNull
    private static final Biome AUBRUM_MOUNTAINS = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeAubrumMountainsBiome(), "aubrum_mountains");
    @NotNull
    private static final Biome AURI_PLAINS = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeAuriPlainsBiome(), "auri_plains");
    @NotNull
    private static final Biome CASTLETON_HILLS = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeCastletonHillsBiome(), "castleton_hills");
    @NotNull
    private static final Biome KNIGHTLY_SHRUBLAND = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeKnightlyShrublandBiome(), "knightly_shrubland");
    @NotNull
    private static final Biome RAINBOW_PLAINS = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeRainbowPlainsBiome(), "rainbow_plains");
    @NotNull
    private static final Biome GUMDROP_FIELDS = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeGumdropFieldsBiome(), "gumdrop_fields");
    @NotNull
    private static final Biome CANDY_PLAINS = (Biome)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)HBiomeMaker.INSTANCE.makeCandyPlainsBiome(), "candy_plains");
    private static final RegistryKey<Biome> THICK_FOREST_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("hardcoredungeons", "thick_forest"));

    private HBiomes() {
    }

    @NotNull
    public final Biome getTHICK_FOREST() {
        return THICK_FOREST;
    }

    @NotNull
    public final Biome getMUSHROOM_CLIFFS() {
        return MUSHROOM_CLIFFS;
    }

    @NotNull
    public final Biome getAUBRUM_WASTELAND() {
        return AUBRUM_WASTELAND;
    }

    @NotNull
    public final Biome getGOLDEN_FOREST() {
        return GOLDEN_FOREST;
    }

    @NotNull
    public final Biome getAUBRUM_MOUNTAINS() {
        return AUBRUM_MOUNTAINS;
    }

    @NotNull
    public final Biome getAURI_PLAINS() {
        return AURI_PLAINS;
    }

    @NotNull
    public final Biome getCASTLETON_HILLS() {
        return CASTLETON_HILLS;
    }

    @NotNull
    public final Biome getKNIGHTLY_SHRUBLAND() {
        return KNIGHTLY_SHRUBLAND;
    }

    @NotNull
    public final Biome getRAINBOW_PLAINS() {
        return RAINBOW_PLAINS;
    }

    @NotNull
    public final Biome getGUMDROP_FIELDS() {
        return GUMDROP_FIELDS;
    }

    @NotNull
    public final Biome getCANDY_PLAINS() {
        return CANDY_PLAINS;
    }

    public final void registerBiomes(@NotNull IForgeRegistry<Biome> biomes) {
        Intrinsics.checkNotNullParameter(biomes, (String)"biomes");
        biomes.register((IForgeRegistryEntry)CASTLETON_HILLS);
        biomes.register((IForgeRegistryEntry)KNIGHTLY_SHRUBLAND);
        biomes.register((IForgeRegistryEntry)RAINBOW_PLAINS);
        biomes.register((IForgeRegistryEntry)AUBRUM_WASTELAND);
        biomes.register((IForgeRegistryEntry)GOLDEN_FOREST);
        biomes.register((IForgeRegistryEntry)AUBRUM_MOUNTAINS);
        biomes.register((IForgeRegistryEntry)AURI_PLAINS);
        biomes.register((IForgeRegistryEntry)GUMDROP_FIELDS);
        biomes.register((IForgeRegistryEntry)CANDY_PLAINS);
        biomes.register((IForgeRegistryEntry)THICK_FOREST);
        biomes.register((IForgeRegistryEntry)MUSHROOM_CLIFFS);
    }

    public final RegistryKey<Biome> getTHICK_FOREST_KEY() {
        return THICK_FOREST_KEY;
    }

    public final void biomeLoading(@NotNull BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder biomeGenerationSettingsBuilder;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getName(), (Object)THICK_FOREST.getRegistryName()) && HConfig.INSTANCE.getThickForestGenerates().getValue().booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(THICK_FOREST_KEY, 6));
        }
        if (Intrinsics.areEqual((Object)event.getName(), (Object)new ResourceLocation("minecraft:mushroom_islands"))) {
            biomeGenerationSettingsBuilder = event.getGeneration();
            Intrinsics.checkNotNullExpressionValue((Object)biomeGenerationSettingsBuilder, (String)"event.generation");
            HFeatures.INSTANCE.withMushroomHut(biomeGenerationSettingsBuilder);
        }
        if (HConfig.INSTANCE.getMalachiteCrystalGeneration().getValue().booleanValue()) {
            biomeGenerationSettingsBuilder = event.getGeneration();
            Intrinsics.checkNotNullExpressionValue((Object)biomeGenerationSettingsBuilder, (String)"event.generation");
            HFeatures.INSTANCE.withMalachiteCrystals(biomeGenerationSettingsBuilder);
        }
    }
}

