/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.tileentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.hardcoredungeons.registry.HTileEntities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\u0012\f\b\u0002\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0007J\n\u00106\u001a\u0004\u0018\u000107H\u0002J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u0002042\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u000209H\u0016J\b\u0010@\u001a\u00020\u0013H\u0016J\u0018\u0010A\u001a\u0002042\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020;H\u0016J\u0018\u0010E\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\u0007H\u0016J\b\u0010G\u001a\u000204H\u0002J\u0012\u0010H\u001a\u0002042\b\u0010I\u001a\u0004\u0018\u00010 H\u0002J\u0010\u0010J\u001a\u00020\u00132\u0006\u0010K\u001a\u00020\u0007H\u0002J\b\u0010L\u001a\u000204H\u0016J\u0010\u0010M\u001a\u00020;2\u0006\u0010N\u001a\u00020;H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000bR\u001a\u0010\u0018\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u000bR\u001a\u0010\u001b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000bR\u001e\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020 0\u001fj\b\u0012\u0004\u0012\u00020 `!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\t\"\u0004\b$\u0010\u000bR\u001a\u0010%\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\t\"\u0004\b'\u0010\u000bR\u001a\u0010(\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\t\"\u0004\b/\u0010\u000bR\u001a\u00100\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\t\"\u0004\b2\u0010\u000b\u00a8\u0006O"}, d2={"Lthedarkcolour/hardcoredungeons/tileentity/DungeonSpawnerTileEntity;", "Lnet/minecraft/tileentity/TileEntity;", "Lnet/minecraft/tileentity/ITickableTileEntity;", "tileEntityTypeIn", "Lnet/minecraft/tileentity/TileEntityType;", "(Lnet/minecraft/tileentity/TileEntityType;)V", "activatingRangeFromPlayer", "", "getActivatingRangeFromPlayer", "()I", "setActivatingRangeFromPlayer", "(I)V", "cachedEntity", "Lnet/minecraft/entity/Entity;", "getCachedEntity", "()Lnet/minecraft/entity/Entity;", "setCachedEntity", "(Lnet/minecraft/entity/Entity;)V", "isActive", "", "()Z", "maxNearbyEntities", "getMaxNearbyEntities", "setMaxNearbyEntities", "maxSpawnDelay", "getMaxSpawnDelay", "setMaxSpawnDelay", "minSpawnDelay", "getMinSpawnDelay", "setMinSpawnDelay", "potentialSpawns", "Ljava/util/ArrayList;", "Lnet/minecraft/util/WeightedSpawnerEntity;", "Lkotlin/collections/ArrayList;", "remainingKills", "getRemainingKills", "setRemainingKills", "spawnCount", "getSpawnCount", "setSpawnCount", "spawnData", "getSpawnData", "()Lnet/minecraft/util/WeightedSpawnerEntity;", "setSpawnData", "(Lnet/minecraft/util/WeightedSpawnerEntity;)V", "spawnDelay", "getSpawnDelay", "setSpawnDelay", "spawnRange", "getSpawnRange", "setSpawnRange", "broadcastEvent", "", "id", "getEntityId", "Lnet/minecraft/util/ResourceLocation;", "getUpdatePacket", "Lnet/minecraft/network/play/server/SUpdateTileEntityPacket;", "getUpdateTag", "Lnet/minecraft/nbt/CompoundNBT;", "onDataPacket", "net", "Lnet/minecraft/network/NetworkManager;", "pkt", "onlyOpsCanSetNbt", "read", "state", "Lnet/minecraft/block/BlockState;", "nbt", "receiveClientEvent", "type", "resetTimer", "setNextSpawnData", "nextSpawnData", "setSpawnDelayToMin", "delay", "tick", "write", "compound", "hardcoredungeons"})
public final class DungeonSpawnerTileEntity
extends TileEntity
implements ITickableTileEntity {
    @NotNull
    private final ArrayList<WeightedSpawnerEntity> potentialSpawns;
    private int remainingKills;
    private int spawnDelay;
    private int minSpawnDelay;
    private int maxSpawnDelay;
    private int spawnCount;
    @Nullable
    private Entity cachedEntity;
    private int maxNearbyEntities;
    private int activatingRangeFromPlayer;
    private int spawnRange;
    @NotNull
    private WeightedSpawnerEntity spawnData;

    public DungeonSpawnerTileEntity(@NotNull TileEntityType<?> tileEntityTypeIn) {
        Intrinsics.checkNotNullParameter(tileEntityTypeIn, (String)"tileEntityTypeIn");
        super(tileEntityTypeIn);
        this.potentialSpawns = new ArrayList();
        this.spawnDelay = 20;
        this.minSpawnDelay = 200;
        this.maxSpawnDelay = 800;
        this.spawnCount = 4;
        this.maxNearbyEntities = 6;
        this.activatingRangeFromPlayer = 16;
        this.spawnRange = 4;
        this.spawnData = new WeightedSpawnerEntity();
    }

    public /* synthetic */ DungeonSpawnerTileEntity(TileEntityType tileEntityType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            TileEntityType<DungeonSpawnerTileEntity> tileEntityType2 = HTileEntities.INSTANCE.getDUNGEON_SPAWNER();
            Intrinsics.checkNotNullExpressionValue(tileEntityType2, (String)"HTileEntities.DUNGEON_SPAWNER");
            tileEntityType = tileEntityType2;
        }
        this(tileEntityType);
    }

    public final int getRemainingKills() {
        return this.remainingKills;
    }

    public final void setRemainingKills(int n) {
        this.remainingKills = n;
    }

    public final int getSpawnDelay() {
        return this.spawnDelay;
    }

    public final void setSpawnDelay(int n) {
        this.spawnDelay = n;
    }

    public final int getMinSpawnDelay() {
        return this.minSpawnDelay;
    }

    public final void setMinSpawnDelay(int n) {
        this.minSpawnDelay = n;
    }

    public final int getMaxSpawnDelay() {
        return this.maxSpawnDelay;
    }

    public final void setMaxSpawnDelay(int n) {
        this.maxSpawnDelay = n;
    }

    public final int getSpawnCount() {
        return this.spawnCount;
    }

    public final void setSpawnCount(int n) {
        this.spawnCount = n;
    }

    @Nullable
    public final Entity getCachedEntity() {
        return this.cachedEntity;
    }

    public final void setCachedEntity(@Nullable Entity entity2) {
        this.cachedEntity = entity2;
    }

    public final int getMaxNearbyEntities() {
        return this.maxNearbyEntities;
    }

    public final void setMaxNearbyEntities(int n) {
        this.maxNearbyEntities = n;
    }

    public final int getActivatingRangeFromPlayer() {
        return this.activatingRangeFromPlayer;
    }

    public final void setActivatingRangeFromPlayer(int n) {
        this.activatingRangeFromPlayer = n;
    }

    public final int getSpawnRange() {
        return this.spawnRange;
    }

    public final void setSpawnRange(int n) {
        this.spawnRange = n;
    }

    @NotNull
    public final WeightedSpawnerEntity getSpawnData() {
        return this.spawnData;
    }

    public final void setSpawnData(@NotNull WeightedSpawnerEntity weightedSpawnerEntity) {
        Intrinsics.checkNotNullParameter((Object)weightedSpawnerEntity, (String)"<set-?>");
        this.spawnData = weightedSpawnerEntity;
    }

    public void func_230337_a_(@NotNull BlockState state2, @NotNull CompoundNBT nbt) {
        ListNBT list;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.func_230337_a_(state2, nbt);
        this.spawnDelay = nbt.func_74765_d("Delay");
        this.potentialSpawns.clear();
        if (nbt.func_150297_b("SpawnPotentials", 9) && (n2 = 0) <= (n = (list = nbt.func_150295_c("SpawnPotentials", 10)).size() + -1)) {
            do {
                int i2 = n2++;
                this.potentialSpawns.add(new WeightedSpawnerEntity(list.func_150305_b(i2)));
            } while (n2 <= n);
        }
        if (nbt.func_150297_b("SpawnData", 10)) {
            this.setNextSpawnData(new WeightedSpawnerEntity(1, nbt.func_74775_l("SpawnData")));
        } else {
            Collection collection = this.potentialSpawns;
            n2 = 0;
            if (!collection.isEmpty()) {
                collection = this.field_145850_b;
                Intrinsics.checkNotNull((Object)collection);
                this.setNextSpawnData((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)((World)collection).field_73012_v, (List)this.potentialSpawns));
            }
        }
        if (nbt.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = nbt.func_74765_d("MaxSpawnDelay");
            this.spawnCount = nbt.func_74765_d("SpawnCount");
        }
        if (nbt.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.func_74765_d("MaxNearbyEntities");
            this.activatingRangeFromPlayer = nbt.func_74765_d("RequiredPlayerRange");
        }
        if (nbt.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = nbt.func_74765_d("SpawnRange");
        }
        if (this.func_145831_w() != null) {
            this.cachedEntity = null;
        }
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        ResourceLocation resourceLocation = this.getEntityId();
        if (resourceLocation == null) {
            super.func_189515_b(compound);
        }
        compound.func_74777_a("Delay", (short)this.spawnDelay);
        compound.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        compound.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        compound.func_74777_a("SpawnCount", (short)this.spawnCount);
        compound.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        compound.func_74777_a("RequiredPlayerRange", (short)this.activatingRangeFromPlayer);
        compound.func_74777_a("SpawnRange", (short)this.spawnRange);
        compound.func_218657_a("SpawnData", (INBT)this.spawnData.func_185277_b().func_74737_b());
        ListNBT nbtList = new ListNBT();
        if (this.potentialSpawns.isEmpty()) {
            nbtList.add((Object)this.spawnData.func_185278_a());
        } else {
            for (WeightedSpawnerEntity spawn : this.potentialSpawns) {
                nbtList.add((Object)spawn.func_185278_a());
            }
        }
        compound.func_218657_a("SpawnPotentials", (INBT)nbtList);
        CompoundNBT compoundNBT = super.func_189515_b(compound);
        Intrinsics.checkNotNullExpressionValue((Object)compoundNBT, (String)"super.write(compound)");
        return compoundNBT;
    }

    private final ResourceLocation getEntityId() {
        ResourceLocation resourceLocation;
        String s = this.spawnData.func_185277_b().func_74779_i("id");
        try {
            resourceLocation = StringUtils.func_151246_b((String)s) ? null : new ResourceLocation(s);
        }
        catch (ResourceLocationException loc) {
            resourceLocation = null;
        }
        return resourceLocation;
    }

    public final boolean isActive() {
        World world = this.field_145850_b;
        Intrinsics.checkNotNull((Object)world);
        return world.func_217358_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.activatingRangeFromPlayer);
    }

    public void func_73660_a() {
        if (this.isActive()) {
            Object object;
            World world = this.field_145850_b;
            Intrinsics.checkNotNull((Object)world);
            World world2 = object = world;
            if (!(world2 instanceof ServerWorld)) {
                if (this.spawnDelay > 0) {
                    object = this;
                    object.spawnDelay += -1;
                    int cfr_ignored_0 = object.spawnDelay;
                }
            } else {
                if (this.spawnDelay == -1) {
                    this.resetTimer();
                }
                if (this.spawnDelay > 0) {
                    object = this;
                    object.spawnDelay += -1;
                    int cfr_ignored_1 = object.spawnDelay;
                }
                boolean successful = false;
                int n = 0;
                int n2 = this.spawnCount;
                if (n < n2) {
                    do {
                        double posZ;
                        int i2 = n++;
                        CompoundNBT nbt = this.spawnData.func_185277_b();
                        Optional optional = EntityType.func_220347_a((CompoundNBT)nbt);
                        if (!optional.isPresent()) {
                            this.resetTimer();
                            return;
                        }
                        ListNBT positions = nbt.func_150295_c("Pos", 6);
                        int j = positions.size();
                        double posX = j >= 1 ? positions.func_150309_d(0) : (double)this.field_174879_c.func_177958_n() + (world2.field_73012_v.nextDouble() - world2.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                        double posY = j >= 2 ? positions.func_150309_d(1) : (double)(this.field_174879_c.func_177956_o() - world2.field_73012_v.nextInt(3)) - 1.0;
                        double d = posZ = j >= 3 ? positions.func_150309_d(2) : (double)this.field_174879_c.func_177952_p() + (world2.field_73012_v.nextDouble() - world2.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                        if (!world2.func_226664_a_(((EntityType)optional.get()).func_220328_a(posX, posY, posZ)) || !EntitySpawnPlacementRegistry.func_223515_a((EntityType)((EntityType)optional.get()), (IServerWorld)((IServerWorld)world2), (SpawnReason)SpawnReason.SPAWNER, (BlockPos)new BlockPos(posX, posY, posZ), (Random)world2.field_73012_v)) continue;
                        Entity entity2 = EntityType.func_220335_a((CompoundNBT)nbt, (World)world2, (Function)new Function<Entity, Entity>(posX, posY, posZ){
                            final /* synthetic */ double $posX;
                            final /* synthetic */ double $posY;
                            final /* synthetic */ double $posZ;
                            {
                                this.$posX = $posX;
                                this.$posY = $posY;
                                this.$posZ = $posZ;
                            }

                            public final Entity apply(Entity e) {
                                e.func_70012_b(this.$posX, this.$posY, this.$posZ, e.field_70177_z, e.field_70125_A);
                                return e;
                            }
                        });
                        if (entity2 == null) {
                            this.resetTimer();
                            return;
                        }
                        int k = world2.func_217357_a(entity2.getClass(), new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 1.0).func_186662_g((double)this.spawnRange)).size();
                        if (k >= this.maxNearbyEntities) {
                            this.resetTimer();
                            return;
                        }
                        entity2.func_70012_b(entity2.func_226277_ct_(), entity2.func_226278_cu_(), entity2.func_226281_cx_(), world2.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (entity2 instanceof MobEntity && this.spawnData.func_185277_b().func_186856_d() == 1 && this.spawnData.func_185277_b().func_150297_b("id", 8)) {
                            ((MobEntity)entity2).func_213386_a((IServerWorld)world2, world2.func_175649_E(((MobEntity)entity2).func_233580_cy_()), SpawnReason.SPAWNER, null, null);
                        }
                        if (!((ServerWorld)world2).func_242106_g(entity2)) {
                            this.resetTimer();
                            return;
                        }
                        world2.func_217379_c(2004, this.field_174879_c, 0);
                        if (entity2 instanceof MobEntity) {
                            ((MobEntity)entity2).func_70656_aK();
                        }
                        successful = true;
                    } while (n < n2);
                }
                if (successful) {
                    this.resetTimer();
                }
            }
        }
    }

    private final void resetTimer() {
        int n;
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            n = this.minSpawnDelay;
        } else {
            int i2 = this.maxSpawnDelay - this.minSpawnDelay;
            World world = this.func_145831_w();
            Intrinsics.checkNotNull((Object)world);
            n = this.spawnDelay = this.minSpawnDelay + world.field_73012_v.nextInt(i2);
        }
        if (!this.potentialSpawns.isEmpty()) {
            World world = this.func_145831_w();
            Intrinsics.checkNotNull((Object)world);
            this.setNextSpawnData((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)world.field_73012_v, (List)this.potentialSpawns));
        }
        this.broadcastEvent(1);
    }

    private final void setNextSpawnData(WeightedSpawnerEntity nextSpawnData) {
        Intrinsics.checkNotNull((Object)nextSpawnData);
        this.spawnData = nextSpawnData;
        if (this.field_145850_b != null) {
            World world = this.field_145850_b;
            Intrinsics.checkNotNull((Object)world);
            BlockState state2 = world.func_180495_p(this.field_174879_c);
            world = this.field_145850_b;
            Intrinsics.checkNotNull((Object)world);
            world.func_184138_a(this.field_174879_c, state2, state2, 4);
        }
    }

    @NotNull
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = this.func_189515_b(new CompoundNBT());
        nbt.func_82580_o("SpawnPotentials");
        return nbt;
    }

    public void onDataPacket(@NotNull NetworkManager net, @NotNull SUpdateTileEntityPacket pkt) {
        Intrinsics.checkNotNullParameter((Object)net, (String)"net");
        Intrinsics.checkNotNullParameter((Object)pkt, (String)"pkt");
        World world = this.field_145850_b;
        Intrinsics.checkNotNull((Object)world);
        BlockState blockState = world.func_180495_p(pkt.func_179823_a());
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"world!!.getBlockState(pkt.pos)");
        BlockState blockState2 = blockState;
        blockState = pkt.func_148857_g();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"pkt.nbtCompound");
        this.func_230337_a_(blockState2, (CompoundNBT)blockState);
    }

    public final void broadcastEvent(int id) {
        World world = this.field_145850_b;
        Intrinsics.checkNotNull((Object)world);
        world.func_175641_c(this.field_174879_c, Blocks.field_150474_ac, id, 0);
    }

    public boolean func_145842_c(int id, int type) {
        return this.setSpawnDelayToMin(id) || super.func_145842_c(id, type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean setSpawnDelayToMin(int delay) {
        if (delay != 1) return false;
        World world = this.field_145850_b;
        Intrinsics.checkNotNull((Object)world);
        if (!world.field_72995_K) return false;
        boolean bl = true;
        boolean successful = bl;
        if (!successful) return successful;
        this.spawnDelay = this.minSpawnDelay;
        return successful;
    }

    public boolean func_183000_F() {
        return true;
    }

    public DungeonSpawnerTileEntity() {
        this(null, 1, null);
    }
}

