/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.asm;

import java.util.List;
import java.util.ListIterator;
import java.util.function.LongFunction;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.coremod.api.ASMAPI;
import net.minecraftforge.registries.GameData;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import thedarkcolour.hardcoredungeons.biome.overworld.MushroomCliffsBiome;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00050\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007J\u001e\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u000eH\u0003\u00a8\u0006\u001e"}, d2={"Lthedarkcolour/hardcoredungeons/asm/ASMHooks;", "", "()V", "applyToWorld", "Lnet/minecraft/world/gen/area/IAreaFactory;", "T", "Lnet/minecraft/world/gen/area/IArea;", "context", "Ljava/util/function/LongFunction;", "Lnet/minecraft/world/gen/IExtendedNoiseRandom;", "area", "isMushroomBiome", "", "biomeId", "", "organizeRegistries", "", "keys", "", "Lnet/minecraft/util/ResourceLocation;", "patchBiomeLayer", "Lorg/objectweb/asm/tree/MethodNode;", "method", "patchLayerUtil", "patchShoreLayer", "nextInsn", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "insnList", "Lorg/objectweb/asm/tree/InsnList;", "aheadIndex", "hardcoredungeons"})
public final class ASMHooks {
    public static final ASMHooks INSTANCE;

    @JvmStatic
    @NotNull
    public static final MethodNode patchBiomeLayer(@NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        InsnList insnList = method.instructions;
        ListIterator listIterator = insnList.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode insn;
            AbstractInsnNode abstractInsnNode = insn = (AbstractInsnNode)listIterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"insn");
            if (abstractInsnNode.getOpcode() != 21) continue;
            AbstractInsnNode abstractInsnNode2 = insn.getPrevious();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode2, (String)"insn.previous");
            if (abstractInsnNode2.getOpcode() != 154) continue;
            InsnList insnList2 = insnList;
            Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"insnList");
            AbstractInsnNode a = ASMHooks.nextInsn(insn, insnList2, 1);
            insnList.insertBefore(a, (AbstractInsnNode)new MethodInsnNode(184, "thedarkcolour/hardcoredungeons/asm/ASMHooks", "isMushroomBiome", "(I)Z", false));
            insnList.remove(a);
            AbstractInsnNode abstractInsnNode3 = ASMHooks.nextInsn(insn, insnList, 2);
            if (abstractInsnNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.JumpInsnNode");
            }
            ((JumpInsnNode)abstractInsnNode3).setOpcode(154);
            return method;
        }
        throw (Throwable)new IllegalStateException("Failed to patch method " + method.name + " with descriptor " + method.desc);
    }

    @JvmStatic
    @NotNull
    public static final MethodNode patchShoreLayer(@NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        InsnList insnList = method.instructions;
        ListIterator listIterator = insnList.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode insn;
            AbstractInsnNode abstractInsnNode = insn = (AbstractInsnNode)listIterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"insn");
            if (abstractInsnNode.getOpcode() != 21) continue;
            AbstractInsnNode abstractInsnNode2 = insn.getPrevious();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode2, (String)"insn.previous");
            if (abstractInsnNode2.getOpcode() != 154) continue;
            InsnList insnList2 = insnList;
            Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"insnList");
            AbstractInsnNode a = ASMHooks.nextInsn(insn, insnList2, 1);
            insnList.insertBefore(a, (AbstractInsnNode)new MethodInsnNode(184, "thedarkcolour/hardcoredungeons/asm/ASMHooks", "isMushroomBiome", "(I)Z", false));
            insnList.remove(a);
            AbstractInsnNode abstractInsnNode3 = ASMHooks.nextInsn(insn, insnList, 2);
            if (abstractInsnNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.JumpInsnNode");
            }
            ((JumpInsnNode)abstractInsnNode3).setOpcode(154);
            return method;
        }
        throw (Throwable)new IllegalStateException("Failed to patch method " + method.name + " with descriptor " + method.desc);
    }

    @JvmStatic
    @NotNull
    public static final MethodNode patchLayerUtil(@NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        InsnList insnList = method.instructions;
        for (AbstractInsnNode insn : insnList) {
            if (!(insn instanceof MethodInsnNode) || !Intrinsics.areEqual((Object)((MethodInsnNode)insn).owner, (Object)"net/minecraft/world/gen/layer/AddMushroomIslandLayer")) continue;
            InsnList insnList2 = insnList;
            Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"insnList");
            AbstractInsnNode nextNext = ASMHooks.nextInsn(insn, insnList2, 2);
            InsnList toAdd = new InsnList();
            toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toAdd.add((AbstractInsnNode)new LdcInsnNode((Object)43L));
            toAdd.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/function/LongFunction", ASMAPI.mapMethod((String)"func_202713_a"), "(J)Ljava/lang/Object;", true));
            toAdd.add((AbstractInsnNode)new TypeInsnNode(192, "net/minecraft/world/gen/IExtendedNoiseRandom"));
            toAdd.add((AbstractInsnNode)new VarInsnNode(25, 3));
            toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "thedarkcolour/hardcoredungeons/asm/ASMHooks", "applyToWorld", "(Lnet/minecraft/world/gen/IExtendedNoiseRandom;Lnet/minecraft/world/gen/area/IAreaFactory;)Lnet/minecraft/world/gen/area/IAreaFactory;", false));
            toAdd.add((AbstractInsnNode)new VarInsnNode(58, 3));
            insnList.insertBefore(nextNext, toAdd);
            return method;
        }
        throw (Throwable)new IllegalStateException("Failed to patch method " + method.name + " with descriptor " + method.desc);
    }

    @JvmStatic
    private static final AbstractInsnNode nextInsn(AbstractInsnNode $this$nextInsn, InsnList insnList, int aheadIndex) {
        AbstractInsnNode abstractInsnNode = insnList.get(insnList.indexOf($this$nextInsn) + aheadIndex);
        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"insnList[insnList.indexOf(this) + aheadIndex]");
        return abstractInsnNode;
    }

    static /* synthetic */ AbstractInsnNode nextInsn$default(AbstractInsnNode abstractInsnNode, InsnList insnList, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return ASMHooks.nextInsn(abstractInsnNode, insnList, n);
    }

    @JvmStatic
    public static final boolean isMushroomBiome(int biomeId) {
        Biome biome = (Biome)Registry.field_212624_m.func_148745_a(biomeId);
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH);
    }

    @JvmStatic
    @NotNull
    public static final <T extends IArea> IAreaFactory<T> applyToWorld(@NotNull LongFunction<? extends IExtendedNoiseRandom<T>> context, @NotNull IAreaFactory<T> area) {
        IAreaFactory area2;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter(area, (String)"area");
        IAreaFactory iAreaFactory = area2 = MushroomCliffsBiome.Layer.INSTANCE.func_202713_a(context.apply(4L), area);
        Intrinsics.checkNotNullExpressionValue((Object)iAreaFactory, (String)"area");
        return iAreaFactory;
    }

    @JvmStatic
    public static final void organizeRegistries(@NotNull List<ResourceLocation> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        keys.remove(GameData.SURFACE_BUILDERS);
        keys.remove(GameData.FEATURES);
        keys.remove(GameData.BLOCK_PLACER_TYPES);
        keys.remove(GameData.ENTITIES);
        int i2 = keys.indexOf(GameData.BIOMES);
        ResourceLocation resourceLocation = GameData.SURFACE_BUILDERS;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"GameData.SURFACE_BUILDERS");
        keys.add(i2, resourceLocation);
        ResourceLocation resourceLocation2 = GameData.FEATURES;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"GameData.FEATURES");
        keys.add(i2, resourceLocation2);
        ResourceLocation resourceLocation3 = GameData.BLOCK_PLACER_TYPES;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"GameData.BLOCK_PLACER_TYPES");
        keys.add(i2, resourceLocation3);
        ResourceLocation resourceLocation4 = GameData.ENTITIES;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"GameData.ENTITIES");
        keys.add(i2, resourceLocation4);
    }

    private ASMHooks() {
    }

    static {
        ASMHooks aSMHooks;
        INSTANCE = aSMHooks = new ASMHooks();
    }
}

