/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.block.misc;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.hardcoredungeons.registry.HBlocks;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J(\u0010\u0015\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lthedarkcolour/hardcoredungeons/block/misc/GrassBlock;", "Lnet/minecraft/block/Block;", "soil", "nocturnal", "", "properties", "Lnet/minecraft/block/Block$Properties;", "(Lnet/minecraft/block/Block;ZLnet/minecraft/block/Block$Properties;)V", "canSpread", "state", "Lnet/minecraft/block/BlockState;", "world", "Lnet/minecraft/world/server/ServerWorld;", "abovePos", "Lnet/minecraft/util/math/BlockPos;", "canSurvive", "onPlantGrow", "", "Lnet/minecraft/world/IWorld;", "pos", "source", "tick", "random", "Ljava/util/Random;", "hardcoredungeons"})
public final class GrassBlock
extends Block {
    private final Block soil;
    private final boolean nocturnal;

    /*
     * WARNING - void declaration
     */
    public void func_225534_a_(@NotNull BlockState state2, @NotNull ServerWorld world, @NotNull BlockPos pos, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        BlockPos abovePos = pos.func_177984_a();
        BlockState blockState = world.func_180495_p(abovePos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"world.getBlockState(abovePos)");
        BlockPos blockPos = abovePos;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"abovePos");
        if (!this.canSurvive(blockState, world, blockPos)) {
            if (world.isAreaLoaded(pos, 3)) {
                world.func_175656_a(pos, this.soil.func_176223_P());
            }
        } else if (world.func_201696_r(abovePos) >= 9 || this.nocturnal && world.func_175710_j(pos)) {
            int n = 0;
            int n2 = 3;
            while (n <= n2) {
                void i2;
                BlockPos randomPos = abovePos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                BlockState blockState2 = world.func_180495_p(randomPos);
                Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"world.getBlockState(randomPos)");
                if (Intrinsics.areEqual((Object)blockState2.func_177230_c(), (Object)this.soil) && this.canSpread(state2, world, abovePos)) {
                    world.func_175656_a(randomPos, this.func_176223_P());
                }
                ++i2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canSurvive(BlockState state2, ServerWorld world, BlockPos abovePos) {
        int i2;
        if (Intrinsics.areEqual((Object)state2.func_177230_c(), (Object)Blocks.field_150433_aE)) {
            Integer n = (Integer)state2.func_177229_b((IProperty)SnowBlock.field_176315_a);
            if (n != null && n == 1) {
                return true;
            }
        }
        if ((i2 = LightEngine.func_215613_a((IBlockReader)((IBlockReader)world), (BlockState)state2, (BlockPos)abovePos, (BlockState)state2, (BlockPos)abovePos, (Direction)Direction.UP, (int)state2.func_200016_a((IBlockReader)world, abovePos))) >= world.func_201572_C()) return false;
        return true;
    }

    private final boolean canSpread(BlockState state2, ServerWorld world, BlockPos abovePos) {
        return this.canSurvive(state2, world, abovePos) && !world.func_204610_c(abovePos).func_206884_a(FluidTags.field_206959_a);
    }

    public void onPlantGrow(@NotNull BlockState state2, @NotNull IWorld world, @NotNull BlockPos pos, @NotNull BlockPos source) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (state2.func_203425_a(Tags.Blocks.DIRT)) {
            world.func_180501_a(pos, HBlocks.INSTANCE.getCASTLETON_SOIL().func_176223_P(), 2);
        }
    }

    public GrassBlock(@NotNull Block soil, boolean nocturnal, @NotNull Block.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)soil, (String)"soil");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.soil = soil;
        this.nocturnal = nocturnal;
    }
}

