/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.hardcoredungeons.command.GenerateStructureCommand;
import thedarkcolour.hardcoredungeons.command.LocateBiomeCommand;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\u001a\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lthedarkcolour/hardcoredungeons/command/GenerateStructureCommand;", "", "()V", "ALL_STRUCTURES", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "Lnet/minecraft/command/CommandSource;", "kotlin.jvm.PlatformType", "execute", "", "source", "pos", "Lnet/minecraft/util/math/BlockPos;", "biome", "Lnet/minecraft/world/biome/Biome;", "structure", "Lnet/minecraft/world/gen/feature/structure/Structure;", "register", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "suggestStructure", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "hardcoredungeons"})
public final class GenerateStructureCommand {
    private static final SuggestionProvider<CommandSource> ALL_STRUCTURES;
    public static final GenerateStructureCommand INSTANCE;

    public final void register(@NotNull CommandDispatcher<CommandSource> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"generate_structure").requires((Predicate)register.1.INSTANCE)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"structure", (ArgumentType)((ArgumentType)ResourceLocationArgument.func_197197_a())).suggests(ALL_STRUCTURES).executes((Command)register.2.INSTANCE)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"pos", (ArgumentType)((ArgumentType)BlockPosArgument.func_197276_a())).executes((Command)register.3.INSTANCE)).then(Commands.func_197056_a((String)"biome", (ArgumentType)((ArgumentType)ResourceLocationArgument.func_197197_a())).suggests(LocateBiomeCommand.INSTANCE.getALL_BIOMES()).executes((Command)register.4.INSTANCE)))));
    }

    private final Structure<?> suggestStructure(CommandContext<CommandSource> ctx) {
        ResourceLocation location = (ResourceLocation)ctx.getArgument("structure", ResourceLocation.class);
        IForgeRegistryEntry iForgeRegistryEntry = ForgeRegistries.FEATURES.getValue(location);
        if (iForgeRegistryEntry == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.world.gen.feature.structure.Structure<*>");
        }
        return (Structure)iForgeRegistryEntry;
    }

    private final int execute(CommandSource source, BlockPos pos, Biome biome, Structure<?> structure) {
        ServerWorld world = source.func_197023_e();
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        Structure.IStartFactory iStartFactory = structure.func_214557_a();
        MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_78887_a();
        ServerWorld serverWorld = world;
        Intrinsics.checkNotNullExpressionValue((Object)serverWorld, (String)"world");
        StructureStart start = iStartFactory.create(structure, chunkX, chunkZ, mutableBoundingBox, 0, serverWorld.func_72905_C());
        ServerChunkProvider serverChunkProvider = world.func_72863_F();
        Intrinsics.checkNotNullExpressionValue((Object)serverChunkProvider, (String)"world.chunkProvider");
        ChunkGenerator generator = serverChunkProvider.func_201711_g();
        start.func_214625_a(generator, world.func_184163_y(), chunkX, chunkZ, biome);
        start.func_225565_a_((IWorld)world, generator, world.field_73012_v, MutableBoundingBox.func_78887_a(), new ChunkPos(chunkX, chunkZ));
        return 0;
    }

    private GenerateStructureCommand() {
    }

    static {
        GenerateStructureCommand generateStructureCommand;
        INSTANCE = generateStructureCommand = new GenerateStructureCommand();
        ALL_STRUCTURES = SuggestionProviders.func_197494_a((ResourceLocation)new ResourceLocation("all_structures"), (SuggestionProvider)ALL_STRUCTURES.1.INSTANCE);
    }

    public static final /* synthetic */ int access$execute(GenerateStructureCommand $this, CommandSource source, BlockPos pos, Biome biome, Structure structure) {
        return $this.execute(source, pos, biome, structure);
    }

    public static final /* synthetic */ Structure access$suggestStructure(GenerateStructureCommand $this, CommandContext ctx) {
        return $this.suggestStructure((CommandContext<CommandSource>)ctx);
    }
}

