/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.hardcoredungeons.command.BiomeLocator;
import thedarkcolour.hardcoredungeons.command.LocateBiomeCommand;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014J\u0014\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017JV\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020%H\u0002R5\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lthedarkcolour/hardcoredungeons/command/LocateBiomeCommand;", "", "()V", "ALL_BIOMES", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "Lnet/minecraft/command/CommandSource;", "kotlin.jvm.PlatformType", "getALL_BIOMES", "()Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "INVALID_EXCEPTION", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "NOT_FOUND_EXCEPTION", "execute", "", "source", "biome", "Lnet/minecraft/world/biome/Biome;", "register", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "suggestBiome", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "locateBiome", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/world/biome/provider/BiomeProvider;", "x", "y", "z", "radius", "grid", "biomes", "", "random", "Ljava/util/Random;", "findFirst", "", "hardcoredungeons"})
public final class LocateBiomeCommand {
    private static final SuggestionProvider<CommandSource> ALL_BIOMES;
    private static final DynamicCommandExceptionType INVALID_EXCEPTION;
    private static final DynamicCommandExceptionType NOT_FOUND_EXCEPTION;
    public static final LocateBiomeCommand INSTANCE;

    public final SuggestionProvider<CommandSource> getALL_BIOMES() {
        return ALL_BIOMES;
    }

    public final void register(@NotNull CommandDispatcher<CommandSource> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"locatebiome").requires((Predicate)register.1.INSTANCE)).then(Commands.func_197056_a((String)"biome", (ArgumentType)((ArgumentType)ResourceLocationArgument.func_197197_a())).suggests(ALL_BIOMES).executes((Command)register.2.INSTANCE)));
    }

    public final int execute(@NotNull CommandSource source, @NotNull Biome biome) {
        ServerWorld world;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        BlockPos pos = new BlockPos(source.func_197036_d());
        ServerWorld serverWorld = world = source.func_197023_e();
        Intrinsics.checkNotNullExpressionValue((Object)serverWorld, (String)"world");
        ServerChunkProvider serverChunkProvider = serverWorld.func_72863_F();
        Intrinsics.checkNotNullExpressionValue((Object)serverChunkProvider, (String)"world.chunkProvider");
        ChunkGenerator chunkGenerator = serverChunkProvider.func_201711_g();
        Intrinsics.checkNotNullExpressionValue((Object)chunkGenerator, (String)"world.chunkProvider.chunkGenerator");
        BiomeProvider biomeProvider = chunkGenerator.func_202090_b();
        Intrinsics.checkNotNullExpressionValue((Object)biomeProvider, (String)"world.chunkProvider.chunkGenerator.biomeProvider");
        int n = pos.func_177958_n();
        int n2 = pos.func_177956_o();
        int n3 = pos.func_177952_p();
        Set set = SetsKt.setOf((Object)biome);
        Random random = world.field_73012_v;
        Intrinsics.checkNotNullExpressionValue((Object)random, (String)"world.rand");
        BlockPos blockPos = LocateBiomeCommand.locateBiome$default(this, biomeProvider, n, n2, n3, 6400, 8, set, random, false, 128, null);
        if (blockPos == null) {
            CommandSyntaxException commandSyntaxException = NOT_FOUND_EXCEPTION.create((Object)new TranslationTextComponent(biome.func_210773_k(), new Object[0]).func_150254_d());
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"NOT_FOUND_EXCEPTION.crea\u2026lationKey).formattedText)");
            throw (Throwable)commandSyntaxException;
        }
        BlockPos pos2 = blockPos;
        int posX = pos.func_177958_n() - pos2.func_177958_n();
        int posZ = pos.func_177952_p() - pos2.func_177952_p();
        float f = posX * posX + posZ * posZ;
        boolean bl = false;
        int i2 = MathHelper.func_76141_d((float)((float)Math.sqrt(f)));
        ITextComponent text2 = TextComponentUtils.func_197676_a((ITextComponent)((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{pos2.func_177958_n(), "~", pos2.func_177952_p()}))).func_211710_a((Consumer)new Consumer<Style>(pos2){
            final /* synthetic */ BlockPos $pos2;

            public final void accept(Style it) {
                it.func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + this.$pos2.func_177958_n() + " ~ " + this.$pos2.func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.coordinates.tooltip", new Object[0])));
            }
            {
                this.$pos2 = blockPos;
            }
        });
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.locate.success", new Object[]{new TranslationTextComponent(biome.func_210773_k(), new Object[0]).func_150254_d(), text2, i2}), false);
        return 1;
    }

    private final BlockPos locateBiome(BiomeProvider $this$locateBiome, int x, int y, int z, int radius, int grid, Set<? extends Biome> biomes, Random random, boolean findFirst) {
        return BiomeLocator.locateBiome($this$locateBiome, x, y, z, radius, grid, biomes, random, findFirst);
    }

    static /* synthetic */ BlockPos locateBiome$default(LocateBiomeCommand locateBiomeCommand, BiomeProvider biomeProvider, int n, int n2, int n3, int n4, int n5, Set set, Random random, boolean bl, int n6, Object object) {
        if ((n6 & 0x80) != 0) {
            bl = true;
        }
        return locateBiomeCommand.locateBiome(biomeProvider, n, n2, n3, n4, n5, set, random, bl);
    }

    @NotNull
    public final Biome suggestBiome(@NotNull CommandContext<CommandSource> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        ResourceLocation location = (ResourceLocation)ctx.getArgument("biome", ResourceLocation.class);
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(location);
        if (biome == null) {
            CommandSyntaxException commandSyntaxException = INVALID_EXCEPTION.create((Object)location);
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"INVALID_EXCEPTION.create(location)");
            throw (Throwable)commandSyntaxException;
        }
        return biome;
    }

    private LocateBiomeCommand() {
    }

    static {
        LocateBiomeCommand locateBiomeCommand;
        INSTANCE = locateBiomeCommand = new LocateBiomeCommand();
        ALL_BIOMES = SuggestionProviders.func_197494_a((ResourceLocation)new ResourceLocation("all_biomes"), (SuggestionProvider)ALL_BIOMES.1.INSTANCE);
        INVALID_EXCEPTION = new DynamicCommandExceptionType((Function)INVALID_EXCEPTION.1.INSTANCE);
        NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType((Function)NOT_FOUND_EXCEPTION.1.INSTANCE);
    }
}

