/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.item.debug;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.hardcoredungeons.item.debug.AbstractFillingWand;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lthedarkcolour/hardcoredungeons/item/debug/FillWandItem;", "Lthedarkcolour/hardcoredungeons/item/debug/AbstractFillingWand;", "properties", "Lnet/minecraft/item/Item$Properties;", "(Lnet/minecraft/item/Item$Properties;)V", "fillMessage", "", "getFillMessage", "()Ljava/lang/String;", "onItemUse", "Lnet/minecraft/util/ActionResultType;", "context", "Lnet/minecraft/item/ItemUseContext;", "hardcoredungeons"})
public final class FillWandItem
extends AbstractFillingWand {
    @NotNull
    private final String fillMessage;

    @Override
    @NotNull
    public String getFillMessage() {
        return this.fillMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ActionResultType func_195939_a(@NotNull ItemUseContext context) {
        BlockState state2;
        BlockState blockState;
        PlayerEntity playerIn;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        World worldIn = context.func_195991_k();
        if (worldIn.field_72995_K) return ActionResultType.SUCCESS;
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        PlayerEntity playerEntity = playerIn = context.func_195999_j();
        if (playerEntity != null) {
            if (playerEntity.func_225608_bj_()) {
                BlockState state3 = worldIn.func_180495_p(pos);
                stack.func_77983_a("FillBlock", (INBT)NBTUtil.func_190009_a((BlockState)state3));
                playerIn.func_146105_b((ITextComponent)new StringTextComponent("Set block to " + state3), true);
                return ActionResultType.SUCCESS;
            }
        }
        ItemStack itemStack = stack;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack");
        if (!this.hasStartPos(itemStack)) {
            BlockPos blockPos = pos;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos");
            this.saveStartPosition(stack, blockPos, playerIn);
            return ActionResultType.SUCCESS;
        }
        try {
            CompoundNBT compoundNBT = stack.func_179543_a("FillBlock");
            Intrinsics.checkNotNull((Object)compoundNBT);
            blockState = NBTUtil.func_190008_d((CompoundNBT)compoundNBT);
        }
        catch (NullPointerException e) {
            PlayerEntity playerEntity2 = playerIn;
            if (playerEntity2 == null) return ActionResultType.SUCCESS;
            playerEntity2.func_146105_b((ITextComponent)new StringTextComponent("No filler block"), true);
            return ActionResultType.SUCCESS;
        }
        BlockState blockState2 = state2 = blockState;
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"state");
        BlockPos blockPos = pos;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos");
        World world = worldIn;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldIn");
        this.place(stack, blockState2, blockPos, world, playerIn);
        return ActionResultType.SUCCESS;
    }

    public FillWandItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.fillMessage = "item.hardcoredungeons.wand.fill";
    }
}

