/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.hardcoredungeons.registry.HRecipes;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lthedarkcolour/hardcoredungeons/recipe/ExtractorRecipe;", "Lnet/minecraft/item/crafting/AbstractCookingRecipe;", "idIn", "Lnet/minecraft/util/ResourceLocation;", "groupIn", "", "ingredientIn", "Lnet/minecraft/item/crafting/Ingredient;", "resultIn", "Lnet/minecraft/item/ItemStack;", "experienceIn", "", "cookTimeIn", "", "(Lnet/minecraft/util/ResourceLocation;Ljava/lang/String;Lnet/minecraft/item/crafting/Ingredient;Lnet/minecraft/item/ItemStack;FI)V", "getSerializer", "Lnet/minecraft/item/crafting/IRecipeSerializer;", "Serializer", "hardcoredungeons"})
public final class ExtractorRecipe
extends AbstractCookingRecipe {
    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return HRecipes.INSTANCE.getEXTRACTOR_SERIALIZER();
    }

    public ExtractorRecipe(@NotNull ResourceLocation idIn, @NotNull String groupIn, @NotNull Ingredient ingredientIn, @NotNull ItemStack resultIn, float experienceIn, int cookTimeIn) {
        Intrinsics.checkNotNullParameter((Object)idIn, (String)"idIn");
        Intrinsics.checkNotNullParameter((Object)groupIn, (String)"groupIn");
        Intrinsics.checkNotNullParameter((Object)ingredientIn, (String)"ingredientIn");
        Intrinsics.checkNotNullParameter((Object)resultIn, (String)"resultIn");
        super(HRecipes.INSTANCE.getEXTRACTION(), idIn, groupIn, ingredientIn, resultIn, experienceIn, cookTimeIn);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lthedarkcolour/hardcoredungeons/recipe/ExtractorRecipe$Serializer;", "Lnet/minecraftforge/registries/ForgeRegistryEntry;", "Lnet/minecraft/item/crafting/IRecipeSerializer;", "Lthedarkcolour/hardcoredungeons/recipe/ExtractorRecipe;", "()V", "read", "recipeId", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "hardcoredungeons"})
    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ExtractorRecipe> {
        @NotNull
        public ExtractorRecipe read(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            ItemStack itemStack;
            Intrinsics.checkNotNullParameter((Object)recipeId, (String)"recipeId");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            JsonElement jsonElement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? (JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : (JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            if (jsonElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.google.gson.JsonElement");
            }
            JsonElement element = jsonElement;
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)element);
            if (!json.has("result")) {
                throw (Throwable)new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            JsonElement jsonElement2 = json.get("result");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"json.get(\"result\")");
            if (jsonElement2.isJsonObject()) {
                itemStack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            } else {
                String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
                ResourceLocation location = new ResourceLocation(s1);
                IForgeRegistryEntry iForgeRegistryEntry = ForgeRegistries.ITEMS.getValue(location);
                Intrinsics.checkNotNull((Object)iForgeRegistryEntry);
                itemStack = new ItemStack((IItemProvider)iForgeRegistryEntry);
            }
            ItemStack result = itemStack;
            float f = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
            int i2 = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)600);
            String string = s;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"s");
            Ingredient ingredient2 = ingredient;
            Intrinsics.checkNotNullExpressionValue((Object)ingredient2, (String)"ingredient");
            ItemStack itemStack2 = result;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"result");
            return new ExtractorRecipe(recipeId, string, ingredient2, itemStack2, f, i2);
        }

        @Nullable
        public ExtractorRecipe read(@NotNull ResourceLocation recipeId, @NotNull PacketBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)recipeId, (String)"recipeId");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack stack = buffer.func_150791_c();
            float f = buffer.readFloat();
            int i2 = buffer.func_150792_a();
            String string = s;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"s");
            Ingredient ingredient2 = ingredient;
            Intrinsics.checkNotNullExpressionValue((Object)ingredient2, (String)"ingredient");
            ItemStack itemStack = stack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack");
            return new ExtractorRecipe(recipeId, string, ingredient2, itemStack, f, i2);
        }

        public void write(@NotNull PacketBuffer buffer, @NotNull ExtractorRecipe recipe) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)((Object)recipe), (String)"recipe");
            buffer.func_180714_a(recipe.field_222141_c);
            recipe.field_222142_d.func_199564_a(buffer);
            buffer.func_150788_a(recipe.field_222143_e);
            buffer.writeFloat(recipe.field_222144_f);
            buffer.func_150787_b(recipe.field_222145_g);
        }
    }
}

