/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.registry;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.hardcoredungeons.feature.tree.LumlightTreeFeature;
import thedarkcolour.hardcoredungeons.feature.tree.TallTreeFeature;
import thedarkcolour.hardcoredungeons.registry.ExtensionsKt;
import thedarkcolour.hardcoredungeons.registry.HBlocks;
import thedarkcolour.hardcoredungeons.registry.HFeatures;
import thedarkcolour.hardcoredungeons.registry.HStructures;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020\u001f2\u0010\u0010-\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0.J \u00100\u001a\u0002012\u0006\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020+2\u0006\u00104\u001a\u000205H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u0019\u0010\u0012\u001a\n \t*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0006R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0018\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00066"}, d2={"Lthedarkcolour/hardcoredungeons/registry/HFeatures;", "", "()V", "GOLDEN_TULIP_CONFIG", "Lnet/minecraft/world/gen/feature/BlockClusterFeatureConfig;", "getGOLDEN_TULIP_CONFIG", "()Lnet/minecraft/world/gen/feature/BlockClusterFeatureConfig;", "LUMLIGHT_LOG_LEAVES_CONFIG", "Lnet/minecraft/world/gen/feature/TreeFeatureConfig;", "kotlin.jvm.PlatformType", "getLUMLIGHT_LOG_LEAVES_CONFIG", "()Lnet/minecraft/world/gen/feature/TreeFeatureConfig;", "LUMLIGHT_TREE_FEATURE", "Lthedarkcolour/hardcoredungeons/feature/tree/LumlightTreeFeature;", "getLUMLIGHT_TREE_FEATURE", "()Lthedarkcolour/hardcoredungeons/feature/tree/LumlightTreeFeature;", "PURPLE_LUMSHROOM_CONFIG", "getPURPLE_LUMSHROOM_CONFIG", "RUNED_CASTLETON_STONE_CONFIG", "getRUNED_CASTLETON_STONE_CONFIG", "SHROOMY_BOULDER_CONFIG", "Lnet/minecraft/world/gen/feature/BlockBlobConfig;", "getSHROOMY_BOULDER_CONFIG", "()Lnet/minecraft/world/gen/feature/BlockBlobConfig;", "TALL_LUMLIGHT_LOG_LEAVES_CONFIG", "getTALL_LUMLIGHT_LOG_LEAVES_CONFIG", "TALL_LUMLIGHT_TREE_FEATURE", "Lthedarkcolour/hardcoredungeons/feature/tree/TallTreeFeature;", "getTALL_LUMLIGHT_TREE_FEATURE", "()Lthedarkcolour/hardcoredungeons/feature/tree/TallTreeFeature;", "addAubrumFlowers", "", "biome", "Lnet/minecraft/world/biome/Biome;", "addLumlightShrubs", "addOakShrubs", "addPurpleLumshrooms", "addRainbowlandOres", "addShroomyBoulders", "addSparseLumlightTrees", "addTallLumlightTrees", "flowerPatchConfig", "flower", "Lnet/minecraft/block/Block;", "registerFeatures", "features", "Lnet/minecraftforge/registries/IForgeRegistry;", "Lnet/minecraft/world/gen/feature/Feature;", "treeConfigBuilder", "Lnet/minecraft/world/gen/feature/TreeFeatureConfig$Builder;", "log", "leaves", "placer", "Lnet/minecraft/world/gen/foliageplacer/FoliagePlacer;", "hardcoredungeons"})
public final class HFeatures {
    @NotNull
    private static final LumlightTreeFeature LUMLIGHT_TREE_FEATURE;
    @NotNull
    private static final TallTreeFeature TALL_LUMLIGHT_TREE_FEATURE;
    @NotNull
    private static final BlockBlobConfig SHROOMY_BOULDER_CONFIG;
    @NotNull
    private static final BlockClusterFeatureConfig GOLDEN_TULIP_CONFIG;
    @NotNull
    private static final BlockClusterFeatureConfig PURPLE_LUMSHROOM_CONFIG;
    private static final BlockClusterFeatureConfig RUNED_CASTLETON_STONE_CONFIG;
    private static final TreeFeatureConfig LUMLIGHT_LOG_LEAVES_CONFIG;
    private static final TreeFeatureConfig TALL_LUMLIGHT_LOG_LEAVES_CONFIG;
    public static final HFeatures INSTANCE;

    @NotNull
    public final LumlightTreeFeature getLUMLIGHT_TREE_FEATURE() {
        return LUMLIGHT_TREE_FEATURE;
    }

    @NotNull
    public final TallTreeFeature getTALL_LUMLIGHT_TREE_FEATURE() {
        return TALL_LUMLIGHT_TREE_FEATURE;
    }

    @NotNull
    public final BlockBlobConfig getSHROOMY_BOULDER_CONFIG() {
        return SHROOMY_BOULDER_CONFIG;
    }

    @NotNull
    public final BlockClusterFeatureConfig getGOLDEN_TULIP_CONFIG() {
        return GOLDEN_TULIP_CONFIG;
    }

    @NotNull
    public final BlockClusterFeatureConfig getPURPLE_LUMSHROOM_CONFIG() {
        return PURPLE_LUMSHROOM_CONFIG;
    }

    public final BlockClusterFeatureConfig getRUNED_CASTLETON_STONE_CONFIG() {
        return RUNED_CASTLETON_STONE_CONFIG;
    }

    public final TreeFeatureConfig getLUMLIGHT_LOG_LEAVES_CONFIG() {
        return LUMLIGHT_LOG_LEAVES_CONFIG;
    }

    public final TreeFeatureConfig getTALL_LUMLIGHT_LOG_LEAVES_CONFIG() {
        return TALL_LUMLIGHT_LOG_LEAVES_CONFIG;
    }

    public final void registerFeatures(@NotNull IForgeRegistry<Feature<?>> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        features.register((IForgeRegistryEntry)LUMLIGHT_TREE_FEATURE);
        features.register((IForgeRegistryEntry)TALL_LUMLIGHT_TREE_FEATURE);
        HStructures.INSTANCE.registerStructures(features);
    }

    public final void addShroomyBoulders(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Feature.field_202283_ac.func_225566_b_((IFeatureConfig)SHROOMY_BOULDER_CONFIG).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
    }

    public final void addAubrumFlowers(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)GOLDEN_TULIP_CONFIG).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public final void addPurpleLumshrooms(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)PURPLE_LUMSHROOM_CONFIG).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(12))));
    }

    public final void addSparseLumlightTrees(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, LUMLIGHT_TREE_FEATURE.func_225566_b_((IFeatureConfig)LUMLIGHT_LOG_LEAVES_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.01f, 1))));
    }

    public final void addTallLumlightTrees(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, TALL_LUMLIGHT_TREE_FEATURE.func_225566_b_((IFeatureConfig)LUMLIGHT_LOG_LEAVES_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.01f, 1))));
    }

    public final void addLumlightShrubs(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202342_t.func_225566_b_((IFeatureConfig)LUMLIGHT_LOG_LEAVES_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(6, 0.3f, 2))));
    }

    public final void addOakShrubs(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202342_t.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(6, 0.3f, 2))));
    }

    private final BlockClusterFeatureConfig flowerPatchConfig(Block flower) {
        BlockClusterFeatureConfig blockClusterFeatureConfig = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(flower.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        Intrinsics.checkNotNullExpressionValue((Object)blockClusterFeatureConfig, (String)"BlockClusterFeatureConfi\u2026acer()).tries(64).build()");
        return blockClusterFeatureConfig;
    }

    private final TreeFeatureConfig.Builder treeConfigBuilder(Block log, Block leaves, FoliagePlacer placer) {
        return new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(leaves.func_176223_P()), placer);
    }

    public final void addRainbowlandOres(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.create((String)"RAINBOW_ROCK", (String)"rainbow_rock", (Predicate)((Predicate)new BlockMatcher(HBlocks.INSTANCE.getRAINBOW_ROCK()))), HBlocks.INSTANCE.getRAINBOWSTONE_ORE().func_176223_P(), 3)).func_227228_a_(Placement.field_215035_u.func_227446_a_((IPlacementConfig)new DepthAverageConfig(2, 16, 12))));
    }

    private HFeatures() {
    }

    static {
        HFeatures hFeatures;
        INSTANCE = hFeatures = new HFeatures();
        LUMLIGHT_TREE_FEATURE = (LumlightTreeFeature)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)new LumlightTreeFeature(LUMLIGHT_TREE_FEATURE.1.INSTANCE), "lumlight_tree");
        TALL_LUMLIGHT_TREE_FEATURE = (TallTreeFeature)ExtensionsKt.setRegistryKey((ForgeRegistryEntry)new TallTreeFeature(TALL_LUMLIGHT_TREE_FEATURE.1.INSTANCE), "tall_lumlight_tree");
        SHROOMY_BOULDER_CONFIG = new BlockBlobConfig(HBlocks.INSTANCE.getSHROOMY_COBBLESTONE().func_176223_P(), 0);
        GOLDEN_TULIP_CONFIG = hFeatures.flowerPatchConfig((Block)HBlocks.INSTANCE.getGOLDEN_TULIP());
        PURPLE_LUMSHROOM_CONFIG = hFeatures.flowerPatchConfig((Block)HBlocks.INSTANCE.getPURPLE_LUMSHROOM());
        RUNED_CASTLETON_STONE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(HBlocks.INSTANCE.getRUNED_CASTLETON_STONE().func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        LUMLIGHT_LOG_LEAVES_CONFIG = hFeatures.treeConfigBuilder((Block)HBlocks.INSTANCE.getLUMLIGHT_LOG(), (Block)HBlocks.INSTANCE.getLUMLIGHT_LEAVES(), (FoliagePlacer)new BlobFoliagePlacer(2, 4)).func_225568_b_();
        TALL_LUMLIGHT_LOG_LEAVES_CONFIG = hFeatures.treeConfigBuilder((Block)HBlocks.INSTANCE.getLUMLIGHT_LOG(), (Block)HBlocks.INSTANCE.getLUMLIGHT_LEAVES(), (FoliagePlacer)new BlobFoliagePlacer(4, 6)).func_225568_b_();
    }
}

