/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.hardcoredungeons.util;

import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.hardcoredungeons.util.IDarkInventory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000bH\u0016J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(H\u0096\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J \u0010*\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000bH\u0016J\b\u0010+\u001a\u00020\u0019H\u0016J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006."}, d2={"Lthedarkcolour/hardcoredungeons/util/DarkInventory;", "Lthedarkcolour/hardcoredungeons/util/IDarkInventory;", "size", "", "defaultName", "", "(ILjava/lang/String;)V", "getSize", "()I", "stacks", "", "Lnet/minecraft/item/ItemStack;", "getStacks", "()[Lnet/minecraft/item/ItemStack;", "setStacks", "([Lnet/minecraft/item/ItemStack;)V", "[Lnet/minecraft/item/ItemStack;", "canTakeStack", "", "slot", "playerIn", "Lnet/minecraft/entity/player/PlayerEntity;", "deserializeNBT", "", "tag", "Lnet/minecraft/nbt/CompoundNBT;", "extractItem", "amount", "simulate", "getSlotLimit", "getSlots", "getStackInSlot", "getVanillaInventory", "Lnet/minecraft/inventory/Inventory;", "range", "Lkotlin/ranges/IntRange;", "insertItem", "stack", "isItemValid", "iterator", "", "onContentsChanged", "onTake", "serializeNBT", "setSize", "setStackInSlot", "hardcoredungeons"})
public class DarkInventory
implements IDarkInventory {
    @NotNull
    private ItemStack[] stacks;
    private final int size;

    @Override
    @NotNull
    public final ItemStack[] getStacks() {
        return this.stacks;
    }

    @Override
    public final void setStacks(@NotNull ItemStack[] itemStackArray) {
        Intrinsics.checkNotNullParameter((Object)itemStackArray, (String)"<set-?>");
        this.stacks = itemStackArray;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        if (size == this.stacks.length) {
            Arrays.fill(this.stacks, ItemStack.field_190927_a);
        } else {
            ItemStack[] itemStackArray;
            DarkInventory darkInventory = this;
            ItemStack[] itemStackArray2 = new ItemStack[size];
            int n = 0;
            while (n < size) {
                ItemStack itemStack;
                int n2 = n;
                int n3 = n++;
                itemStackArray = itemStackArray2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)ItemStack.field_190927_a, (String)"ItemStack.EMPTY");
                itemStackArray[n3] = itemStack;
            }
            itemStackArray = itemStackArray2;
            darkInventory.stacks = itemStackArray;
        }
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.stacks[slot] = stack;
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.stacks.length;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.stacks[slot];
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack itemStack;
        boolean reachedLimit;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.func_190926_b() || !this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = this.stacks[slot];
        int limit = this.getSlotLimit(slot);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                Intrinsics.checkNotNullExpressionValue((Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack), (String)"if (reachedLimit) ItemHa\u2026(stack, limit) else stack");
                this.stacks[slot] = this.stacks[slot];
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        if (reachedLimit) {
            ItemStack itemStack2 = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit));
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"ItemHandlerHelper.copySt\u2026ack, stack.count - limit)");
        } else {
            ItemStack itemStack3 = ItemStack.field_190927_a;
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"ItemStack.EMPTY");
        }
        return itemStack;
    }

    @Override
    public boolean canTakeStack(int slot, @NotNull PlayerEntity playerIn) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        return true;
    }

    @Override
    @NotNull
    public ItemStack onTake(int slot, @NotNull PlayerEntity playerIn, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack itemStack;
        if (amount == 0) {
            ItemStack itemStack2 = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"ItemStack.EMPTY");
            return itemStack2;
        }
        ItemStack existing = this.stacks[slot];
        if (existing.func_190926_b()) {
            ItemStack itemStack3 = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"ItemStack.EMPTY");
            return itemStack3;
        }
        int toExtract = RangesKt.coerceAtMost((int)amount, (int)existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                Intrinsics.checkNotNullExpressionValue((Object)ItemStack.field_190927_a, (String)"ItemStack.EMPTY");
                this.onContentsChanged(slot);
            }
            itemStack = existing;
        } else {
            if (!simulate) {
                Intrinsics.checkNotNullExpressionValue((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)), (String)"ItemHandlerHelper.copySt\u2026isting.count - toExtract)");
                this.onContentsChanged(slot);
            }
            ItemStack itemStack4 = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
            itemStack = itemStack4;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"ItemHandlerHelper.copySt\u2026Size(existing, toExtract)");
        }
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        int n = 0;
        int n2 = this.stacks.length;
        while (n < n2) {
            void i2;
            if (!this.stacks[i2].func_190926_b()) {
                CompoundNBT itemTag = new CompoundNBT();
                itemTag.func_74768_a("Slot", (int)i2);
                this.stacks[i2].func_77955_b(itemTag);
                nbtTagList.add((Object)itemTag);
            }
            ++i2;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.length);
        return nbt;
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeNBT(@NotNull CompoundNBT tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.setSize(tag.func_150297_b("Size", 3) ? tag.func_74762_e("Size") : this.stacks.length);
        ListNBT tagList = tag.func_150295_c("Items", 10);
        int n = 0;
        int n2 = tagList.size();
        while (n < n2) {
            void i2;
            CompoundNBT itemTags = tagList.func_150305_b((int)i2);
            int slot = itemTags.func_74762_e("Slot");
            if (slot >= 0 && slot < this.stacks.length) {
                Intrinsics.checkNotNullExpressionValue((Object)ItemStack.func_199557_a((CompoundNBT)itemTags), (String)"ItemStack.read(itemTags)");
            }
            ++i2;
        }
    }

    @Override
    @NotNull
    public Iterator<ItemStack> iterator() {
        return ArrayIteratorKt.iterator((Object[])this.stacks);
    }

    @Override
    public void onContentsChanged(int slot) {
    }

    @Override
    @NotNull
    public Inventory getVanillaInventory(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Object[] objectArray = this.stacks;
        int n = range.getFirst();
        int n2 = range.getLast();
        boolean bl = false;
        ItemStack[] itemStackArray = (ItemStack[])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2);
        return new Inventory(Arrays.copyOf(itemStackArray, itemStackArray.length));
    }

    public DarkInventory(int size, @Nullable String defaultName) {
        ItemStack[] itemStackArray;
        DarkInventory darkInventory = this;
        ItemStack[] itemStackArray2 = new ItemStack[size];
        int n = 0;
        while (n < size) {
            ItemStack itemStack;
            int n2 = n;
            int n3 = n++;
            itemStackArray = itemStackArray2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)ItemStack.field_190927_a, (String)"ItemStack.EMPTY");
            itemStackArray[n3] = itemStack;
        }
        itemStackArray = itemStackArray2;
        darkInventory.stacks = itemStackArray;
        this.size = this.stacks.length;
    }

    public /* synthetic */ DarkInventory(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        this(n, string);
    }

    @Override
    public boolean canInteractWith(@NotNull PlayerEntity playerIn) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        return IDarkInventory.DefaultImpls.canInteractWith(this, playerIn);
    }

    @Override
    public boolean anyMatch(@NotNull Function1<? super ItemStack, Boolean> test) {
        Intrinsics.checkNotNullParameter(test, (String)"test");
        return IDarkInventory.DefaultImpls.anyMatch(this, test);
    }

    @Override
    @NotNull
    public ItemStack get(int index) {
        return IDarkInventory.DefaultImpls.get(this, index);
    }

    @Override
    public void set(int index, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        IDarkInventory.DefaultImpls.set(this, index, stack);
    }
}

