/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.hotbarlock;

import de.keksuccino.hotbarlock.DropKeybinding;
import de.keksuccino.hotbarlock.HotbarLock;
import de.keksuccino.hotbarlock.Keybinding;
import de.keksuccino.hotbarlock.core.config.exceptions.InvalidValueException;
import java.awt.Color;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;

public class HotbarHandler
extends Gui {
    private static boolean init = false;
    private static DropKeybinding keybind;
    private static final Color GREEN;
    private static final Color RED;
    private static final Color PINK;

    public static void init() {
        if (!init) {
            init = true;
            try {
                GameSettings s = Minecraft.func_71410_x().field_71474_y;
                keybind = new DropKeybinding("key.drop", 16, "key.categories.inventory");
                s.field_74324_K = (KeyBinding[])ArrayUtils.removeElement((Object[])s.field_74324_K, (Object)s.field_74316_C);
                Field f = ReflectionHelper.findField(GameSettings.class, (String[])new String[]{"keyBindDrop", "field_74316_C"});
                f.set(s, (Object)keybind);
                s.field_74324_K = (KeyBinding[])ArrayUtils.add((Object[])s.field_74324_K, (Object)((Object)keybind));
                s.func_74300_a();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            MinecraftForge.EVENT_BUS.register((Object)new HotbarHandler());
        }
    }

    public static void setSlotBlocked(int slot, boolean blocked) {
        if (slot >= 0 && slot <= 8) {
            try {
                HotbarLock.config.setValue("slot" + slot, blocked);
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isDropBlockedForCurrentSlot() {
        int slot;
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71071_by != null && Minecraft.func_71410_x().field_71462_r == null && (slot = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c) >= 0 && slot <= 8) {
            return HotbarLock.config.getOrDefault("slot" + slot, false);
        }
        return false;
    }

    public static DropKeybinding getKeybinding() {
        return keybind;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.HOTBAR && HotbarLock.config.getOrDefault("showgui", true).booleanValue()) {
            HotbarHandler.renderSlotLock(0);
            HotbarHandler.renderSlotLock(1);
            HotbarHandler.renderSlotLock(2);
            HotbarHandler.renderSlotLock(3);
            HotbarHandler.renderSlotLock(4);
            HotbarHandler.renderSlotLock(5);
            HotbarHandler.renderSlotLock(6);
            HotbarHandler.renderSlotLock(7);
            HotbarHandler.renderSlotLock(8);
        }
    }

    private static void renderSlotLock(int slot) {
        if (slot >= 0 && slot <= 8) {
            boolean lock = HotbarLock.config.getOrDefault("slot" + slot, false);
            Color c = lock ? (HotbarLock.config.getOrDefault("colorblindmode", false).booleanValue() ? PINK : RED) : GREEN;
            ScaledResolution scale = new ScaledResolution(Minecraft.func_71410_x());
            int originX = scale.func_78326_a() / 2 - 90;
            int x = originX + slot * 20;
            int y = scale.func_78328_b() - 22;
            HotbarHandler.func_73734_a((int)x, (int)y, (int)(x + 20), (int)(y - 1), (int)c.getRGB());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71071_by != null) {
            int slot = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c;
            if (Keybinding.keybindLockSlot.func_151468_f() && slot >= 0 && slot <= 8) {
                boolean b = BooleanUtils.negate((Boolean)HotbarLock.config.getOrDefault("slot" + slot, false));
                HotbarHandler.setSlotBlocked(slot, b);
                if (HotbarLock.config.getOrDefault("chatoutput", false).booleanValue()) {
                    if (b) {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("\u00a76Slot \u00a77" + slot + " \u00a76is now \u00a7clocked!"));
                    } else {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("\u00a76Slot \u00a77" + slot + " \u00a76is now \u00a7aunlocked!"));
                    }
                }
            }
        }
    }

    static {
        GREEN = new Color(76, 172, 38, 255);
        RED = new Color(217, 56, 2, 255);
        PINK = new Color(208, 28, 139, 255);
    }
}

