/*
 * Decompiled with CFR 0.152.
 */
package blueduck.jollyboxes;

import blueduck.jollyboxes.config.ConfigHelper;
import blueduck.jollyboxes.config.JollyBoxesConfig;
import blueduck.jollyboxes.registry.JollyBoxesBlocks;
import blueduck.jollyboxes.registry.JollyBoxesSounds;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jolly_boxes")
public class JollyBoxesMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static JollyBoxesConfig CONFIG;
    public static String MODID;

    public JollyBoxesMod() {
        CONFIG = ConfigHelper.register(ModConfig.Type.COMMON, JollyBoxesConfig::new);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerWakeUp);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
        JollyBoxesBlocks.init();
        JollyBoxesSounds.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onPlayerWakeUp(PlayerWakeUpEvent event) {
        if (!JollyBoxesMod.CONFIG.ONLY_IN_SNOWY_BIOMES.get().booleanValue() || JollyBoxesMod.CONFIG.ONLY_IN_SNOWY_BIOMES.get().booleanValue() && (double)event.getPlayer().func_130014_f_().func_226691_t_(event.getPlayer().func_233580_cy_()).func_242445_k() <= 0.15 && (!JollyBoxesMod.CONFIG.ONLY_IN_DECEMBER.get().booleanValue() || JollyBoxesMod.CONFIG.ONLY_IN_DECEMBER.get().booleanValue() && JollyBoxesMod.isDecember())) {
            event.getPlayer().getPersistentData().func_74757_a("slept", true);
        }
    }

    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.getPersistentData().func_74767_n("slept") && event.player.func_130014_f_().func_72935_r()) {
            event.player.getPersistentData().func_74757_a("slept", false);
            BlockPos pos = event.player.func_233580_cy_();
            if (!event.player.func_130014_f_().func_201670_d() && event.player.func_130014_f_().func_201674_k().nextDouble() < JollyBoxesMod.CONFIG.PRESENT_CHANCE.get()) {
                for (int i = 0; i < event.player.func_130014_f_().func_201674_k().nextInt(JollyBoxesMod.CONFIG.MAXIMUM_PRESENTS.get() + JollyBoxesMod.CONFIG.MINIMUM_PRESENTS.get()) + JollyBoxesMod.CONFIG.MINIMUM_PRESENTS.get(); ++i) {
                    BlockPos pos2 = new BlockPos((double)pos.func_177958_n() + event.player.func_130014_f_().func_201674_k().nextDouble() * 32.0 - 16.0, (double)(pos.func_177956_o() + 100), (double)pos.func_177952_p() + event.player.func_130014_f_().func_201674_k().nextDouble() * 32.0 - 16.0);
                    if (this.getGroundPos(pos2, event.player.func_130014_f_()) == null) continue;
                    event.player.func_130014_f_().func_175656_a(this.getGroundPos(pos2, event.player.func_130014_f_()), ((Block)JollyBoxesBlocks.SMALL_JOLLY_BOX.get()).func_176223_P());
                }
                event.player.func_213823_a((SoundEvent)JollyBoxesSounds.SLEIGH_BELLS.get(), SoundCategory.AMBIENT, 1.0f, 1.0f);
            }
        }
    }

    public BlockPos getGroundPos(BlockPos pos, World world) {
        for (int i = pos.func_177956_o(); i > 0; --i) {
            if (!this.isValidPos(pos.func_177979_c(pos.func_177956_o() - i), world) || !world.func_180495_p(pos).equals(Blocks.field_150350_a.func_176223_P()) && !world.func_180495_p(pos).equals(Blocks.field_150433_aE.func_176223_P())) continue;
            return pos.func_177979_c(pos.func_177956_o() - i);
        }
        return null;
    }

    public boolean isValidPos(BlockPos pos, World world) {
        return (world.func_180495_p(pos).equals(Blocks.field_150350_a.func_176223_P()) || world.func_180495_p(pos).equals(Blocks.field_150433_aE.func_176223_P())) && world.func_180495_p(pos.func_177977_b()).func_200132_m();
    }

    private static boolean isDecember() {
        LocalDate localDate = LocalDate.now();
        int month = localDate.get(ChronoField.MONTH_OF_YEAR);
        return month == 12;
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)JollyBoxesBlocks.SMALL_JOLLY_BOX.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)JollyBoxesBlocks.MEDIUM_JOLLY_BOX.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)JollyBoxesBlocks.LARGE_JOLLY_BOX.get()), (RenderType)RenderType.func_228641_d_());
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    static {
        MODID = "jolly_boxes";
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

