/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.internal.InlineOnly;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.ExperimentalPathApi;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=5, xi=1, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0087\b\u001a%\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0087\b\u001a%\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0087\b\u001a\u001e\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u001a:\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010\u0015\u001a:\u0010\u0016\u001a\u00020\u0017*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010\u0018\u001a=\u0010\u0019\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00010\u001bH\u0087\b\u00f8\u0001\u0000\u001a&\u0010 \u001a\u00020!*\u00020\u00022\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010\"\u001a&\u0010#\u001a\u00020$*\u00020\u00022\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010%\u001a\r\u0010&\u001a\u00020\u0004*\u00020\u0002H\u0087\b\u001a\u001d\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0(*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\nH\u0087\b\u001a\u0016\u0010)\u001a\u00020\u001c*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u001a0\u0010*\u001a\u00020+*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010,\u001a?\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\u0018\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u000b\u0012\u0004\u0012\u0002H.0\u001bH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100\u001a.\u00101\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u00102\u001a>\u00103\u001a\u00020\u0002*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u00104\u001a>\u00103\u001a\u00020\u0002*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u00105\u001a7\u00106\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0007\u00a2\u0006\u0002\u00107\u001a0\u00108\u001a\u000209*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0087\b\u00a2\u0006\u0002\u0010:\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006;"}, d2={"appendBytes", "", "Ljava/nio/file/Path;", "array", "", "appendLines", "lines", "", "", "charset", "Ljava/nio/charset/Charset;", "Lkotlin/sequences/Sequence;", "appendText", "text", "bufferedReader", "Ljava/io/BufferedReader;", "bufferSize", "", "options", "", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;I[Ljava/nio/file/OpenOption;)Ljava/io/BufferedReader;", "bufferedWriter", "Ljava/io/BufferedWriter;", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;I[Ljava/nio/file/OpenOption;)Ljava/io/BufferedWriter;", "forEachLine", "action", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "line", "inputStream", "Ljava/io/InputStream;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStream;", "readBytes", "readLines", "", "readText", "reader", "Ljava/io/InputStreamReader;", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/io/InputStreamReader;", "useLines", "T", "block", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "writeBytes", "(Ljava/nio/file/Path;[B[Ljava/nio/file/OpenOption;)V", "writeLines", "(Ljava/nio/file/Path;Ljava/lang/Iterable;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/sequences/Sequence;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/nio/file/Path;", "writeText", "(Ljava/nio/file/Path;Ljava/lang/CharSequence;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)V", "writer", "Ljava/io/OutputStreamWriter;", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStreamWriter;", "kotlin-stdlib-jdk7"}, xs="kotlin/io/path/PathsKt")
class PathsKt__PathReadWriteKt {
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final InputStreamReader reader(Path $this$reader, Charset charset, OpenOption ... options) {
        int $i$f$reader = 0;
        return new InputStreamReader(Files.newInputStream($this$reader, Arrays.copyOf(options, options.length)), charset);
    }

    static /* synthetic */ InputStreamReader reader$default(Path $this$reader, Charset charset, OpenOption[] options, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        boolean $i$f$reader = false;
        return new InputStreamReader(Files.newInputStream($this$reader, Arrays.copyOf(options, options.length)), charset);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final BufferedReader bufferedReader(Path $this$bufferedReader, Charset charset, int bufferSize, OpenOption ... options) {
        int $i$f$bufferedReader = 0;
        return new BufferedReader(new InputStreamReader(Files.newInputStream($this$bufferedReader, Arrays.copyOf(options, options.length)), charset), bufferSize);
    }

    static /* synthetic */ BufferedReader bufferedReader$default(Path $this$bufferedReader, Charset charset, int bufferSize, OpenOption[] options, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 2) != 0) {
            bufferSize = 8192;
        }
        boolean $i$f$bufferedReader = false;
        return new BufferedReader(new InputStreamReader(Files.newInputStream($this$bufferedReader, Arrays.copyOf(options, options.length)), charset), bufferSize);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final OutputStreamWriter writer(Path $this$writer, Charset charset, OpenOption ... options) {
        int $i$f$writer = 0;
        return new OutputStreamWriter(Files.newOutputStream($this$writer, Arrays.copyOf(options, options.length)), charset);
    }

    static /* synthetic */ OutputStreamWriter writer$default(Path $this$writer, Charset charset, OpenOption[] options, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        boolean $i$f$writer = false;
        return new OutputStreamWriter(Files.newOutputStream($this$writer, Arrays.copyOf(options, options.length)), charset);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final BufferedWriter bufferedWriter(Path $this$bufferedWriter, Charset charset, int bufferSize, OpenOption ... options) {
        int $i$f$bufferedWriter = 0;
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream($this$bufferedWriter, Arrays.copyOf(options, options.length)), charset), bufferSize);
    }

    static /* synthetic */ BufferedWriter bufferedWriter$default(Path $this$bufferedWriter, Charset charset, int bufferSize, OpenOption[] options, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 2) != 0) {
            bufferSize = 8192;
        }
        boolean $i$f$bufferedWriter = false;
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream($this$bufferedWriter, Arrays.copyOf(options, options.length)), charset), bufferSize);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final byte[] readBytes(Path $this$readBytes) {
        int $i$f$readBytes = 0;
        byte[] byArray = Files.readAllBytes($this$readBytes);
        Intrinsics.checkNotNullExpressionValue(byArray, "Files.readAllBytes(this)");
        return byArray;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final void writeBytes(Path $this$writeBytes, byte[] array, OpenOption ... options) {
        int $i$f$writeBytes = 0;
        Files.write($this$writeBytes, array, Arrays.copyOf(options, options.length));
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final void appendBytes(Path $this$appendBytes, byte[] array) {
        int $i$f$appendBytes = 0;
        Files.write($this$appendBytes, array, StandardOpenOption.APPEND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @NotNull
    public static final String readText(@NotNull Path $this$readText, @NotNull Charset charset) {
        String string;
        Intrinsics.checkNotNullParameter($this$readText, "$this$readText");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Object object = $this$readText;
        OpenOption[] openOptionArray = new OpenOption[]{};
        boolean bl = false;
        object = new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset);
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            InputStreamReader it = (InputStreamReader)object;
            boolean bl3 = false;
            string = TextStreamsKt.readText(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        return string;
    }

    public static /* synthetic */ String readText$default(Path path, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return PathsKt.readText(path, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    public static final void writeText(@NotNull Path $this$writeText, @NotNull CharSequence text, @NotNull Charset charset, OpenOption ... options) {
        Intrinsics.checkNotNullParameter($this$writeText, "$this$writeText");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(options, "options");
        OutputStream outputStream = Files.newOutputStream($this$writeText, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(outputStream, "Files.newOutputStream(this, *options)");
        Closeable closeable = outputStream;
        boolean bl = false;
        closeable = new OutputStreamWriter((OutputStream)closeable, charset);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)closeable;
            boolean bl3 = false;
            Writer writer = it.append(text);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static /* synthetic */ void writeText$default(Path path, CharSequence charSequence, Charset charset, OpenOption[] openOptionArray, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        PathsKt.writeText(path, charSequence, charset, openOptionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    public static final void appendText(@NotNull Path $this$appendText, @NotNull CharSequence text, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$appendText, "$this$appendText");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(charset, "charset");
        OutputStream outputStream = Files.newOutputStream($this$appendText, StandardOpenOption.APPEND);
        Intrinsics.checkNotNullExpressionValue(outputStream, "Files.newOutputStream(th\u2026tandardOpenOption.APPEND)");
        Closeable closeable = outputStream;
        boolean bl = false;
        closeable = new OutputStreamWriter((OutputStream)closeable, charset);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)closeable;
            boolean bl3 = false;
            Writer writer = it.append(text);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static /* synthetic */ void appendText$default(Path path, CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        PathsKt.appendText(path, charSequence, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final void forEachLine(Path $this$forEachLine, Charset charset, Function1<? super String, Unit> action) {
        int $i$f$forEachLine = 0;
        BufferedReader bufferedReader = Files.newBufferedReader($this$forEachLine, charset);
        Intrinsics.checkNotNullExpressionValue(bufferedReader, "Files.newBufferedReader(this, charset)");
        Reader $this$useLines$iv = bufferedReader;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n = 8192;
        boolean bl = false;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl2 = false;
            Sequence<String> it = TextStreamsKt.lineSequence(it$iv);
            boolean bl3 = false;
            Sequence<String> $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            Iterator<String> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                String element$iv = iterator2.next();
                action.invoke(element$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable);
                } else if (throwable == null) {
                    closeable.close();
                } else {
                    try {
                        closeable.close();
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, throwable);
        } else {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void forEachLine$default(Path $this$forEachLine, Charset charset, Function1 action, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        boolean $i$f$forEachLine = false;
        BufferedReader bufferedReader = Files.newBufferedReader($this$forEachLine, charset);
        Intrinsics.checkNotNullExpressionValue(bufferedReader, "Files.newBufferedReader(this, charset)");
        Reader $this$useLines$iv = bufferedReader;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n2 = 8192;
        boolean bl = false;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        n2 = 0;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl2 = false;
            Sequence<String> it = TextStreamsKt.lineSequence(it$iv);
            boolean bl3 = false;
            Sequence<String> $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            Iterator<String> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                String element$iv = iterator2.next();
                action.invoke(element$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable);
                } else if (throwable == null) {
                    closeable.close();
                } else {
                    try {
                        closeable.close();
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, throwable);
        } else {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final InputStream inputStream(Path $this$inputStream, OpenOption ... options) {
        int $i$f$inputStream = 0;
        InputStream inputStream = Files.newInputStream($this$inputStream, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(inputStream, "Files.newInputStream(this, *options)");
        return inputStream;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final OutputStream outputStream(Path $this$outputStream, OpenOption ... options) {
        int $i$f$outputStream = 0;
        OutputStream outputStream = Files.newOutputStream($this$outputStream, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(outputStream, "Files.newOutputStream(this, *options)");
        return outputStream;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final List<String> readLines(Path $this$readLines, Charset charset) {
        int $i$f$readLines = 0;
        List<String> list = Files.readAllLines($this$readLines, charset);
        Intrinsics.checkNotNullExpressionValue(list, "Files.readAllLines(this, charset)");
        return list;
    }

    static /* synthetic */ List readLines$default(Path $this$readLines, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        boolean $i$f$readLines = false;
        List<String> list = Files.readAllLines($this$readLines, charset);
        Intrinsics.checkNotNullExpressionValue(list, "Files.readAllLines(this, charset)");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final <T> T useLines(Path $this$useLines, Charset charset, Function1<? super Sequence<String>, ? extends T> block) {
        T t;
        int $i$f$useLines = 0;
        Closeable closeable = Files.newBufferedReader($this$useLines, charset);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl3 = false;
            BufferedReader bufferedReader = it;
            Intrinsics.checkNotNullExpressionValue(bufferedReader, "it");
            t = block.invoke(TextStreamsKt.lineSequence(bufferedReader));
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable);
                } else if (closeable != null) {
                    if (throwable == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable4) {
                            // empty catch block
                        }
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, throwable);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Object useLines$default(Path $this$useLines, Charset charset, Function1 block, int n, Object object) {
        Object r;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        boolean $i$f$useLines = false;
        object = Files.newBufferedReader($this$useLines, charset);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl3 = false;
            BufferedReader bufferedReader = it;
            Intrinsics.checkNotNullExpressionValue(bufferedReader, "it");
            r = block.invoke(TextStreamsKt.lineSequence(bufferedReader));
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                } else if (object != null) {
                    if (throwable == null) {
                        object.close();
                    } else {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable4) {
                            // empty catch block
                        }
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally((Closeable)object, throwable);
        } else if (object != null) {
            object.close();
        }
        InlineMarker.finallyEnd(1);
        return r;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path writeLines(Path $this$writeLines, Iterable<? extends CharSequence> lines, Charset charset, OpenOption ... options) {
        int $i$f$writeLines = 0;
        Path path = Files.write($this$writeLines, lines, charset, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(path, "Files.write(this, lines, charset, *options)");
        return path;
    }

    static /* synthetic */ Path writeLines$default(Path $this$writeLines, Iterable lines, Charset charset, OpenOption[] options, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        boolean $i$f$writeLines = false;
        Path path = Files.write($this$writeLines, (Iterable<? extends CharSequence>)lines, charset, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(path, "Files.write(this, lines, charset, *options)");
        return path;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path writeLines(Path $this$writeLines, Sequence<? extends CharSequence> lines, Charset charset, OpenOption ... options) {
        int $i$f$writeLines = 0;
        Path path = Files.write($this$writeLines, SequencesKt.asIterable(lines), charset, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(path, "Files.write(this, lines.\u2026ble(), charset, *options)");
        return path;
    }

    static /* synthetic */ Path writeLines$default(Path $this$writeLines, Sequence lines, Charset charset, OpenOption[] options, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        boolean $i$f$writeLines = false;
        Path path = Files.write($this$writeLines, SequencesKt.asIterable(lines), charset, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(path, "Files.write(this, lines.\u2026ble(), charset, *options)");
        return path;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path appendLines(Path $this$appendLines, Iterable<? extends CharSequence> lines, Charset charset) {
        int $i$f$appendLines = 0;
        Path path = Files.write($this$appendLines, lines, charset, StandardOpenOption.APPEND);
        Intrinsics.checkNotNullExpressionValue(path, "Files.write(this, lines,\u2026tandardOpenOption.APPEND)");
        return path;
    }

    static /* synthetic */ Path appendLines$default(Path $this$appendLines, Iterable lines, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        boolean $i$f$appendLines = false;
        Path path = Files.write($this$appendLines, (Iterable<? extends CharSequence>)lines, charset, StandardOpenOption.APPEND);
        Intrinsics.checkNotNullExpressionValue(path, "Files.write(this, lines,\u2026tandardOpenOption.APPEND)");
        return path;
    }

    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    private static final Path appendLines(Path $this$appendLines, Sequence<? extends CharSequence> lines, Charset charset) {
        int $i$f$appendLines = 0;
        Path path = Files.write($this$appendLines, SequencesKt.asIterable(lines), charset, StandardOpenOption.APPEND);
        Intrinsics.checkNotNullExpressionValue(path, "Files.write(this, lines.\u2026tandardOpenOption.APPEND)");
        return path;
    }

    static /* synthetic */ Path appendLines$default(Path $this$appendLines, Sequence lines, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        boolean $i$f$appendLines = false;
        Path path = Files.write($this$appendLines, SequencesKt.asIterable(lines), charset, StandardOpenOption.APPEND);
        Intrinsics.checkNotNullExpressionValue(path, "Files.write(this, lines.\u2026tandardOpenOption.APPEND)");
        return path;
    }
}

