/*
 * Decompiled with CFR 0.152.
 */
package com.ma;

import com.ma.KeybindInit;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.BlockClientInit;
import com.ma.blocks.BlockInit;
import com.ma.blocks.tileentities.TileEntityClientInit;
import com.ma.blocks.tileentities.TileEntityInit;
import com.ma.brewing.BrewingInit;
import com.ma.commands.CommandInit;
import com.ma.config.MAClientConfig;
import com.ma.config.MAConfig;
import com.ma.config.MASpellConfig;
import com.ma.effects.EffectInit;
import com.ma.enchantments.EnchantmentInit;
import com.ma.entities.EntityClientInit;
import com.ma.entities.EntityInit;
import com.ma.entities.attributes.AttributeInit;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.events.ClientEventHandler;
import com.ma.gui.GuiInit;
import com.ma.gui.HUDOverlayRenderer;
import com.ma.gui.containers.ContainerInit;
import com.ma.guide.GuideBookEntries;
import com.ma.items.ItemClientInit;
import com.ma.items.ItemInit;
import com.ma.items.artifice.ItemThaumaturgicCompass;
import com.ma.loot.GlobalLootModifiers;
import com.ma.particles.ParticleClientInit;
import com.ma.recipes.RecipeInit;
import com.ma.tools.ClientProxy;
import com.ma.tools.ISidedProxy;
import com.ma.worldgen.structures.MAStructures;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="mana-and-artifice")
public class ManaAndArtifice {
    public static final Logger LOGGER = LogManager.getLogger();
    public static ManaAndArtifice instance;
    public static final ResourceLocation EMPTY;
    final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
    public ISidedProxy proxy;

    public ManaAndArtifice() {
        boolean HIDE_CONSOLE_NOISE = false;
        MAConfig.loadServerConfig(MAConfig.SERVERCONFIG, FMLPaths.CONFIGDIR.get().resolve("mana-and-artifice-general.toml"));
        MASpellConfig.initServerConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, MAClientConfig.CLIENT_SPEC);
        LOGGER.info("M&A -> Config Loaded");
        instance = this;
        ItemInit.ITEMS.register(this.modEventBus);
        BlockInit.BLOCKS.register(this.modEventBus);
        TileEntityInit.TILE_ENTITY_TYPES.register(this.modEventBus);
        AttributeInit.ATTRIBUTES.register(this.modEventBus);
        EntityInit.ENTITY_TYPES.register(this.modEventBus);
        ParticleInit.PARTICLES.register(this.modEventBus);
        ContainerInit.CONTAINERS.register(this.modEventBus);
        RecipeInit.SERIALIZERS.register(this.modEventBus);
        GlobalLootModifiers.LOOT_MODIFIERS.register(this.modEventBus);
        MAStructures.DEFERRED_REGISTRY_STRUCTURE.register(this.modEventBus);
        EffectInit.EFFECTS.register(this.modEventBus);
        EnchantmentInit.ENCHANTMENTS.register(this.modEventBus);
        BrewingInit.POTIONS.register(this.modEventBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.register(HUDOverlayRenderer.class);
            MinecraftForge.EVENT_BUS.register(ClientEventHandler.class);
            MinecraftForge.EVENT_BUS.register(GuideBookEntries.class);
            this.modEventBus.addListener(this::clientInit);
            this.modEventBus.register(GuiInit.class);
            this.modEventBus.register(KeybindInit.class);
            this.modEventBus.register(ParticleClientInit.class);
            this.modEventBus.register(TileEntityClientInit.class);
            this.modEventBus.register(BlockClientInit.class);
            this.modEventBus.register(ItemClientInit.class);
            this.modEventBus.register(EntityClientInit.class);
            this.proxy = new ClientProxy();
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            this.proxy = new ISidedProxy(){

                @Override
                public World getClientWorld() {
                    return null;
                }

                @Override
                public PlayerEntity getClientPlayer() {
                    return null;
                }

                @Override
                public long getGameTicks() {
                    return 0L;
                }

                @Override
                public void incrementTick() {
                }

                @Override
                public void openConstructDiagnostics(EntityAnimatedConstruct target) {
                }

                @Override
                public boolean isUIModifierKeyDown() {
                    return false;
                }

                @Override
                public EntityAnimatedConstruct getDummyConstructForRender() {
                    return null;
                }
            };
        });
        MinecraftForge.EVENT_BUS.register(CommandInit.class);
        GeckoLib.initialize();
        LOGGER.info("M&A -> Mod Event Bus Handlers Registered");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit(FMLClientSetupEvent event) {
        ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.THAUMATURGIC_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, ClientWorld world, LivingEntity entityLiving) {
                LivingEntity entity;
                if (entityLiving == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean entityExists = entityLiving != null;
                Object object = entity = entityExists ? entityLiving : stack.func_82836_z();
                if (world == null && entity.field_70170_p instanceof ClientWorld) {
                    world = (ClientWorld)entity.field_70170_p;
                }
                double rotation = entityExists ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                double adjusted = Math.PI - (((rotation %= 360.0) - 90.0) * 0.01745329238474369 - this.getAngle(world, (Entity)entity, stack));
                if (entityExists) {
                    adjusted = this.wobble(world, adjusted);
                }
                float f = (float)(adjusted / (Math.PI * 2));
                return MathHelper.func_188207_b((float)f, (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(ClientWorld world, double amount) {
                if (world.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.func_82737_E();
                    double d0 = amount - this.rotation;
                    d0 %= Math.PI * 2;
                    d0 = MathHelper.func_151237_a((double)d0, (double)-1.0, (double)1.0);
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation += this.rota;
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrameEntity itemFrame) {
                return MathHelper.func_188209_b((int)(180 + itemFrame.func_174811_aO().func_176736_b() * 90));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getAngle(ClientWorld world, Entity entity, ItemStack stack) {
                if (stack.func_77973_b() == ItemInit.THAUMATURGIC_COMPASS.get()) {
                    ItemThaumaturgicCompass compassItem = (ItemThaumaturgicCompass)stack.func_77973_b();
                    BlockPos pos = compassItem.getTrackedPosition(stack, (RegistryKey<World>)world.func_234923_W_());
                    if (pos == null) {
                        pos = world.func_239140_u_();
                    }
                    return Math.atan2((double)pos.func_177952_p() - entity.func_213303_ch().field_72449_c, (double)pos.func_177958_n() - entity.func_213303_ch().field_72450_a);
                }
                return 0.0;
            }
        });
    }

    static {
        EMPTY = new ResourceLocation("mana-and-artifice", "empty");
    }
}

