/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.entities;

import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;

public class FactionRaidRegistry {
    private static final HashMap<EntityType<? extends IFactionEnemy<? extends LivingEntity>>, Integer> councilSoldiers = new HashMap();
    private static final HashMap<EntityType<? extends IFactionEnemy<? extends LivingEntity>>, Integer> feySoldiers = new HashMap();
    private static final HashMap<EntityType<? extends IFactionEnemy<? extends LivingEntity>>, Integer> demonSoldiers = new HashMap();

    public static int getStrengthRating(Faction faction, EntityType<? extends IFactionEnemy<? extends LivingEntity>> entityType) {
        switch (faction) {
            case ANCIENT_WIZARDS: {
                return councilSoldiers.containsKey(entityType) ? councilSoldiers.get(entityType) : 0;
            }
            case DEMONS: {
                return demonSoldiers.containsKey(entityType) ? demonSoldiers.get(entityType) : 0;
            }
            case FEY_COURT: {
                return feySoldiers.containsKey(entityType) ? feySoldiers.get(entityType) : 0;
            }
        }
        return 0;
    }

    public static void registerSoldier(Faction faction, EntityType<? extends IFactionEnemy<? extends LivingEntity>> entityType, int strengthRating) {
        if (strengthRating <= 0) {
            throw new InvalidParameterException("Strength rating must be greater than zero or you risk infinite loops!");
        }
        switch (faction) {
            case ANCIENT_WIZARDS: {
                councilSoldiers.put(entityType, strengthRating);
                break;
            }
            case DEMONS: {
                demonSoldiers.put(entityType, strengthRating);
                break;
            }
            case FEY_COURT: {
                feySoldiers.put(entityType, strengthRating);
                break;
            }
            default: {
                throw new InvalidParameterException("Cannot register faction enemies for faction " + faction.toString());
            }
        }
    }

    @Nullable
    public static EntityType<? extends IFactionEnemy<? extends LivingEntity>> getSoldier(Faction faction, int raidStrength) {
        switch (faction) {
            case ANCIENT_WIZARDS: {
                return FactionRaidRegistry.pickSoldier(councilSoldiers, raidStrength);
            }
            case DEMONS: {
                return FactionRaidRegistry.pickSoldier(demonSoldiers, raidStrength);
            }
            case FEY_COURT: {
                return FactionRaidRegistry.pickSoldier(feySoldiers, raidStrength);
            }
        }
        return null;
    }

    @Nullable
    private static EntityType<? extends IFactionEnemy<? extends LivingEntity>> pickSoldier(HashMap<EntityType<? extends IFactionEnemy<? extends LivingEntity>>, Integer> list, int raidStrength) {
        if (list.size() == 0) {
            return null;
        }
        List possibles = list.entrySet().stream().filter(e -> (Integer)e.getValue() <= raidStrength).map(e -> (EntityType)e.getKey()).collect(Collectors.toList());
        if (possibles.size() == 0) {
            return null;
        }
        if (possibles.size() == 1) {
            return (EntityType)possibles.get(0);
        }
        return (EntityType)possibles.get(new Random().nextInt(possibles.size()));
    }
}

