/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.items;

import com.ma.api.ManaAndArtificeMod;
import com.ma.api.capabilities.CurioItemCapability;
import com.ma.api.items.IShowHud;
import com.ma.api.items.ManaBatteryItem;
import com.ma.api.particles.ParticleInit;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItem;
import org.apache.commons.lang3.mutable.MutableBoolean;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class ChargeableItem
extends Item
implements IShowHud,
IForgeItem {
    private static final String KEY_NBT_MANA = "mana";
    private float max_mana;

    public ChargeableItem(Item.Properties properties, float maxMana) {
        super(properties.func_200918_c(100));
        this.max_mana = maxMana;
    }

    public boolean consumeMana(ItemStack stack, float amount, @Nullable PlayerEntity player) {
        CompoundNBT tag;
        if (player != null && !(this instanceof ManaBatteryItem)) {
            List invItems = player.field_71071_by.field_70462_a.stream().filter(i -> i.func_77973_b() instanceof ManaBatteryItem).collect(Collectors.toList());
            for (ItemStack invStack : invItems) {
                ManaBatteryItem item = (ManaBatteryItem)invStack.func_77973_b();
                float contained = item.getMana(invStack);
                float toConsume = amount;
                if (contained < amount) {
                    toConsume = contained;
                }
                if (item.consumeMana(invStack, toConsume, player)) {
                    amount -= toConsume;
                }
                if (!(amount <= 0.0f)) continue;
                return true;
            }
        }
        if ((tag = stack.func_77978_p()) == null) {
            return false;
        }
        float curMana = tag.func_74760_g(KEY_NBT_MANA);
        if (curMana < amount) {
            return false;
        }
        tag.func_74776_a(KEY_NBT_MANA, curMana -= amount);
        return true;
    }

    public float refundMana(ItemStack stack, float amount, @Nullable PlayerEntity player) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return 0.0f;
        }
        float curMana = tag.func_74760_g(KEY_NBT_MANA);
        if (curMana + amount > this.max_mana) {
            amount = this.max_mana - curMana;
        }
        tag.func_74776_a(KEY_NBT_MANA, curMana += amount);
        return amount;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        if (this.tickCurio()) {
            return CurioItemCapability.createProvider(new ICurio(){

                public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                    ChargeableItem.this.internalInventoryTick((Entity)livingEntity, index, stack, false);
                }
            });
        }
        return super.initCapabilities(stack, nbt);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.tickInventory()) {
            this.internalInventoryTick(entityIn, itemSlot, stack, isSelected);
        }
    }

    private final void internalInventoryTick(Entity entity, int slot, ItemStack stack, boolean selected) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            float mana = this.getMana(stack);
            if (mana >= this.manaPerOperation() && this.tickEffect(stack, player, player.field_70170_p, slot, mana, selected)) {
                this.consumeMana(stack, this.manaPerOperation(), player);
            }
        }
    }

    public final boolean applyEffect(ItemStack stack, PlayerEntity player, World world, int slot, float mana, boolean selected) {
        float curMana = this.getMana(stack);
        if (curMana < mana) {
            return false;
        }
        if (this.tickEffect(stack, player, world, slot, curMana, selected)) {
            this.consumeMana(stack, this.manaPerOperation(), player);
            return true;
        }
        return false;
    }

    protected abstract boolean tickEffect(ItemStack var1, PlayerEntity var2, World var3, int var4, float var5, boolean var6);

    protected float manaPerRechargeTick() {
        return 10.0f;
    }

    public final float getMana(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74760_g(KEY_NBT_MANA);
        }
        return 0.0f;
    }

    public final float getMaxMana() {
        return this.max_mana;
    }

    protected boolean tickCurio() {
        return true;
    }

    protected boolean tickInventory() {
        return false;
    }

    protected float manaPerOperation() {
        return 1.0f;
    }

    protected float minimumManaToStartChanneling() {
        return this.manaPerRechargeTick() * 5.0f;
    }

    protected int repairPerRechargeTick() {
        return 10;
    }

    protected boolean canChannelRepair() {
        return true;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return this.canChannelRepair();
    }

    public int func_77626_a(ItemStack stack) {
        return 9999;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77973_b() != this) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (this.canChannelRepair() && this.getMana(stack) < this.max_mana) {
            MutableBoolean hasMana = new MutableBoolean(false);
            playerIn.getCapability(ManaAndArtificeMod.getMagicCapability()).ifPresent(m -> {
                if (m.getMana() >= this.minimumManaToStartChanneling()) {
                    playerIn.func_184598_c(handIn);
                }
            });
            if (hasMana.getValue().booleanValue()) {
                return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
            }
        }
        return ActionResult.func_226251_d_((Object)playerIn.func_184586_b(handIn));
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof PlayerEntity) {
            if (!player.field_70170_p.field_72995_K) {
                ((PlayerEntity)player).getCapability(ManaAndArtificeMod.getMagicCapability()).ifPresent(m -> {
                    if (m.getMana() >= this.manaPerRechargeTick()) {
                        m.consume(this.manaPerRechargeTick());
                        this.refundMana(stack, ((PlayerEntity)player).func_184812_l_() ? (float)(this.repairPerRechargeTick() * 100) : (float)this.repairPerRechargeTick(), (PlayerEntity)player);
                    } else {
                        ((PlayerEntity)player).func_184602_cy();
                    }
                });
            } else {
                player.field_70170_p.func_195594_a((IParticleData)ParticleInit.BLUE_SPARKLE_GRAVITY.get(), player.func_226277_ct_() - 0.5 + Math.random(), player.func_226278_cu_() + Math.random(), player.func_226281_cx_() - 0.5 + Math.random(), 0.0, (double)0.1f, 0.0);
            }
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.chargeable.mana", new Object[]{Float.valueOf(this.getMana(stack)), Float.valueOf(this.max_mana)}).func_240699_a_(TextFormatting.AQUA));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.chargeable.pedestalCharge").func_240699_a_(TextFormatting.AQUA));
        if (this.canChannelRepair()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.chargeable.rightClickCharge").func_240699_a_(TextFormatting.AQUA));
        }
    }

    public boolean isEquippedAndHasMana(LivingEntity living, float mana, boolean autoConsume) {
        MutableBoolean valid = new MutableBoolean(false);
        CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, living).ifPresent(t -> {
            if (this.getMana((ItemStack)t.right) >= mana) {
                if (autoConsume && living instanceof PlayerEntity) {
                    this.consumeMana((ItemStack)t.right, mana, (PlayerEntity)living);
                }
                valid.setTrue();
            }
        });
        return valid.booleanValue();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ColorHelper.PackedColor.func_233006_a_((int)255, (int)128, (int)64, (int)255);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        float mana = this.getMana(stack);
        return 1.0f - mana / this.max_mana;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }
}

