/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.progression;

import com.ma.api.events.CantripCastEvent;
import com.ma.api.events.ConstructCraftedEvent;
import com.ma.api.events.ManaweaveCraftingEvent;
import com.ma.api.events.ManaweavePatternDrawnEvent;
import com.ma.api.events.PlayerMagicLevelUpEvent;
import com.ma.api.events.RitualCompleteEvent;
import com.ma.api.events.RuneforgeCraftingEvent;
import com.ma.api.events.RuneforgeEnchantEvent;
import com.ma.api.events.RunescribeCraftingEvent;
import com.ma.api.events.SpellCastEvent;
import com.ma.api.events.SpellCraftedEvent;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ProgressionCondition<T extends Event>
extends ForgeRegistryEntry<ProgressionCondition<?>> {
    private int tier;
    private EventType<T> checkOn;
    private Function<T, Boolean> metCheck;
    private Class<T> type;

    public ProgressionCondition(String name, int tier, EventType<T> eventType, Function<T, Boolean> check) {
        this.tier = tier;
        this.metCheck = check;
        this.checkOn = eventType;
        this.type = eventType.getClassType();
        this.setRegistryName(name);
    }

    public int getTier() {
        return this.tier;
    }

    public EventType<T> getType() {
        return this.checkOn;
    }

    public Class<T> getClassType() {
        return this.type;
    }

    public boolean isMet(T event) {
        if (this.metCheck != null) {
            return this.metCheck.apply(event);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProgressionCondition) {
            return ((ProgressionCondition)((Object)obj)).getRegistryName().equals((Object)this.getRegistryName());
        }
        return false;
    }

    public static class EventType<V extends Event> {
        public static final EventType<TickEvent.PlayerTickEvent> TICK = new EventType<TickEvent.PlayerTickEvent>(TickEvent.PlayerTickEvent.class);
        public static final EventType<RitualCompleteEvent> RITUAL = new EventType<RitualCompleteEvent>(RitualCompleteEvent.class);
        public static final EventType<PlayerEvent.ItemCraftedEvent> CRAFT = new EventType<PlayerEvent.ItemCraftedEvent>(PlayerEvent.ItemCraftedEvent.class);
        public static final EventType<ManaweaveCraftingEvent> MANAWEAVE_CRAFT = new EventType<ManaweaveCraftingEvent>(ManaweaveCraftingEvent.class);
        public static final EventType<ManaweavePatternDrawnEvent> MANAWEAVE_PATTERN_DRAWN = new EventType<ManaweavePatternDrawnEvent>(ManaweavePatternDrawnEvent.class);
        public static final EventType<RuneforgeCraftingEvent> RUNEFORGE_CRAFT = new EventType<RuneforgeCraftingEvent>(RuneforgeCraftingEvent.class);
        public static final EventType<RuneforgeEnchantEvent> RUNEFORGE_ENCHANT = new EventType<RuneforgeEnchantEvent>(RuneforgeEnchantEvent.class);
        public static final EventType<RunescribeCraftingEvent> RUNESCRIBE = new EventType<RunescribeCraftingEvent>(RunescribeCraftingEvent.class);
        public static final EventType<PlayerEvent.PlayerChangedDimensionEvent> DIMENSION_CHANGE = new EventType<PlayerEvent.PlayerChangedDimensionEvent>(PlayerEvent.PlayerChangedDimensionEvent.class);
        public static final EventType<PlayerMagicLevelUpEvent> MAGIC_LEVEL_UP = new EventType<PlayerMagicLevelUpEvent>(PlayerMagicLevelUpEvent.class);
        public static final EventType<SpellCraftedEvent> SPELL_CRAFTED = new EventType<SpellCraftedEvent>(SpellCraftedEvent.class);
        public static final EventType<SpellCastEvent> SPELL_CAST = new EventType<SpellCastEvent>(SpellCastEvent.class);
        public static final EventType<ConstructCraftedEvent> CONSTRUCT_CRAFT = new EventType<ConstructCraftedEvent>(ConstructCraftedEvent.class);
        public static final EventType<CantripCastEvent> CANTRIP_CAST = new EventType<CantripCastEvent>(CantripCastEvent.class);
        public static final EventType<AdvancementEvent> ADVANCEMENT = new EventType<AdvancementEvent>(AdvancementEvent.class);
        public static final EventType<PlayerInteractEvent.RightClickBlock> RIGHT_CLICK_BLOCK = new EventType<PlayerInteractEvent.RightClickBlock>(PlayerInteractEvent.RightClickBlock.class);
        public static final EventType<LivingEquipmentChangeEvent> EQUIPMENT_CHANGE = new EventType<LivingEquipmentChangeEvent>(LivingEquipmentChangeEvent.class);
        private Class<V> clazz;

        private EventType(Class<V> clazz) {
            this.clazz = clazz;
        }

        public Class<V> getClassType() {
            return this.clazz;
        }
    }

    public static class PhantomProgressionCondition
    extends ProgressionCondition<TickEvent.PlayerTickEvent> {
        public PhantomProgressionCondition(ResourceLocation id) {
            super("phantom", 0, EventType.TICK, null);
        }
    }
}

