/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.parts;

import com.google.common.collect.ImmutableList;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.ISpellComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Modifier
extends ForgeRegistryEntry<Modifier>
implements ISpellComponent {
    private final ResourceLocation guiIcon;
    private ImmutableList<Attribute> governed;
    private int xpToRote;

    public Modifier(ResourceLocation guiIcon, int xpToRote, Attribute ... modified_attributes) {
        this.governed = ImmutableList.copyOf((Object[])modified_attributes);
        this.guiIcon = guiIcon;
        this.xpToRote = xpToRote;
    }

    public final boolean modifiesType(Attribute governing_attribute) {
        return this.governed.contains((Object)governing_attribute);
    }

    public final ImmutableList<Attribute> getModifiedAttributes() {
        return this.governed;
    }

    @Override
    public final ResourceLocation getGuiIcon() {
        return this.guiIcon;
    }

    @Override
    public boolean isCraftable() {
        return true;
    }

    @Override
    public boolean isUseableByPlayers() {
        return true;
    }

    @Override
    public int requiredXPForRote() {
        return this.xpToRote;
    }

    public static class PhantomModifier
    extends Modifier {
        private static final ResourceLocation _default = new ResourceLocation("mana-and-artifice:modifier_default");

        public PhantomModifier() {
            super(_default, -1, new Attribute[0]);
        }
    }
}

