/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.parts;

import com.google.common.collect.ImmutableList;
import com.ma.api.spells.SpellReagent;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.config.MASpellConfig;
import com.ma.config.SpellModConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Shape
extends ForgeRegistryEntry<Shape>
implements IModifiable,
ISpellComponent {
    private final ResourceLocation guiIcon;
    private final ImmutableList<AttributeValuePair> modifiableAttributes;

    public Shape(ResourceLocation registryName, ResourceLocation guiIcon, AttributeValuePair ... attributeValuePairs) {
        this.guiIcon = guiIcon;
        this.setRegistryName(registryName);
        SpellModConfig.initForPart(MASpellConfig.BUILDER, this, attributeValuePairs);
        this.modifiableAttributes = ImmutableList.copyOf((Object[])attributeValuePairs);
    }

    @Override
    public final ImmutableList<AttributeValuePair> getModifiableAttributes() {
        return AttributeValuePair.deepCopy(this.modifiableAttributes);
    }

    public final void lookupAttributeConfig() {
        this.modifiableAttributes.forEach(m -> m.lookupConfig(this));
    }

    public abstract SpellTarget Target(SpellSource var1, World var2, IModifiedSpellPart<Shape> var3, ISpellDefinition var4);

    public boolean spawnsTargetEntity() {
        return false;
    }

    @Override
    public boolean isCraftable() {
        return true;
    }

    public boolean isChanneled() {
        return false;
    }

    public abstract float initialComplexity();

    public int maxChannelTime(IModifiedSpellPart<Shape> shape) {
        return (int)shape.getValue(Attribute.DURATION) * 20;
    }

    @Override
    public boolean isUseableByPlayers() {
        return true;
    }

    @Override
    public final ResourceLocation getGuiIcon() {
        return this.guiIcon;
    }

    @Nullable
    public List<SpellReagent> getRequiredReagents(@Nullable PlayerEntity caster) {
        return null;
    }

    public static class PhantomShape
    extends Shape {
        public static PhantomShape instance = new PhantomShape();
        private static final ResourceLocation _default = new ResourceLocation("mana-and-artifice:shape_default");

        public PhantomShape() {
            super(_default, _default, new AttributeValuePair[0]);
        }

        @Override
        public SpellTarget Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
            return SpellTarget.NONE;
        }

        @Override
        public float initialComplexity() {
            return 0.0f;
        }

        @Override
        public int requiredXPForRote() {
            return -1;
        }
    }
}

