/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.targeting;

import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public final class SpellSource {
    private LivingEntity caster;
    private Vector3d origin;
    private Vector3d forward;

    public SpellSource(LivingEntity caster) {
        this.caster = caster;
        this.origin = caster.func_213303_ch().func_72441_c(0.0, (double)caster.func_70047_e(), 0.0);
        this.forward = caster.func_70040_Z();
    }

    public SpellSource(Vector3d origin, Vector3d forward) {
        this.origin = origin;
        this.forward = forward;
    }

    public Vector3d getOrigin() {
        return this.origin;
    }

    public Vector3d getForward() {
        return this.forward;
    }

    @Nullable
    public LivingEntity getCaster() {
        return this.caster;
    }

    @Nullable
    public PlayerEntity getPlayer() {
        if (this.isPlayerCaster()) {
            return (PlayerEntity)this.caster;
        }
        return null;
    }

    public boolean hasCasterReference() {
        return this.caster != null;
    }

    public boolean isPlayerCaster() {
        return this.caster != null && this.caster instanceof PlayerEntity;
    }

    public AxisAlignedBB getBoundingBox() {
        if (this.caster != null) {
            return this.caster.func_174813_aQ();
        }
        return new AxisAlignedBB(new BlockPos(this.origin));
    }
}

