/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.artifice;

import com.ma.blocks.ICustomCategory;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.tileentities.TileEntityConstructWorkbench;
import com.ma.items.MAItemGroups;
import com.ma.items.constructs.parts._base.ConstructSlot;
import com.ma.items.constructs.parts._base.ItemConstructPart;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockConstructWorkbench
extends WaterloggableBlock
implements ICustomCategory {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockConstructWorkbench() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_().func_200943_b(3.0f).func_235838_a_(b -> 15), false);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack activeStack = player.func_184586_b(handIn);
        TileEntityConstructWorkbench te = (TileEntityConstructWorkbench)worldIn.func_175625_s(pos);
        if (te == null) {
            return ActionResultType.FAIL;
        }
        if (activeStack.func_190926_b() && te.startCrafting(player)) {
            return ActionResultType.SUCCESS;
        }
        if (!(activeStack.func_77973_b() instanceof ItemConstructPart)) {
            return ActionResultType.PASS;
        }
        ItemStack result = te.placePart(activeStack);
        if (result.equals(activeStack)) {
            return ActionResultType.PASS;
        }
        if (!player.func_184812_l_()) {
            activeStack.func_190918_g(1);
        }
        if (!result.func_190926_b() && !player.func_191521_c(result)) {
            player.func_199701_a_(result);
        }
        return ActionResultType.SUCCESS;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityConstructWorkbench();
    }

    @Override
    public ItemGroup getItemGroup() {
        return MAItemGroups.constructs;
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        this.dropInventory(world, pos, null);
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.dropInventory(worldIn, pos, null);
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        this.dropInventory(worldIn, pos, te);
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    private void dropInventory(World world, BlockPos pos, @Nullable TileEntity te) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityConstructWorkbench wb = (TileEntityConstructWorkbench)(te != null ? te : world.func_175625_s(pos));
        if (wb != null) {
            for (ConstructSlot slot : ConstructSlot.values()) {
                wb.getConstruct().getPart(slot).ifPresent(p -> {
                    ItemEntity ie = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    ie.func_92058_a(new ItemStack((IItemProvider)p));
                    ie.func_174869_p();
                    world.func_217376_c((Entity)ie);
                });
            }
        }
    }
}

