/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.multiblock;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class MultiblockStructure {
    private Map<BlockPos, BlockState> requiredBlocks = new HashMap<BlockPos, BlockState>();

    public MultiblockStructure AddRequiredBlock(BlockPos vec, BlockState state) {
        this.requiredBlocks.put(vec, state);
        return this;
    }

    public boolean match(World world, BlockPos center, Property<?> ... ignoreProperties) {
        boolean matched = true;
        for (BlockPos pos : this.requiredBlocks.keySet()) {
            BlockState state = world.func_180495_p(center.func_177971_a((Vector3i)pos));
            matched &= this.compareBlockStates(this.requiredBlocks.get(pos), state, ignoreProperties);
        }
        return matched;
    }

    private boolean compareBlockStates(BlockState requirement, BlockState world, Property<?>[] ignoreThese) {
        if (requirement.func_177230_c() != world.func_177230_c()) {
            return false;
        }
        for (Property prop : world.func_235904_r_()) {
            if (!requirement.func_235901_b_(prop)) continue;
            boolean skip = false;
            for (Property<?> ignore : ignoreThese) {
                if (!prop.equals(ignore)) continue;
                skip = true;
                break;
            }
            if (skip || requirement.func_177229_b(prop).equals(world.func_177229_b(prop))) continue;
            return false;
        }
        return true;
    }

    public Collection<BlockPos> getBlockOffsets() {
        return this.requiredBlocks.keySet();
    }
}

