/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.ritual;

import com.ma.api.capabilities.IWorldMagic;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.interfaces.IDontCreateBlockItem;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.utility.EntityDisplayReagents;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;

public class BlockRitualTeleportLocation
extends Block
implements IDontCreateBlockItem {
    public BlockRitualTeleportLocation() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_222380_e().func_200944_c().func_200948_a(3.0f, 10000.0f));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        LazyOptional worldMagicContainer = worldIn.getCapability(WorldMagicProvider.MAGIC);
        if (worldMagicContainer.isPresent()) {
            IWorldMagic worldMagic = (IWorldMagic)worldMagicContainer.orElse(null);
            List<ResourceLocation> reagents = worldMagic.getRitualTeleportBlockReagents(pos);
            Entity displayEntity = ((EntityType)EntityInit.REAGENT_ENTITY.get()).func_220331_a((ServerWorld)worldIn, null, player, pos.func_177984_a(), SpawnReason.SPAWN_EGG, true, true);
            if (displayEntity != null && displayEntity instanceof EntityDisplayReagents) {
                ((EntityDisplayReagents)displayEntity).setResourceLocations(reagents);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 16;
    }

    public int getHarvestLevel(BlockState state) {
        return 3;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        LazyOptional worldMagicContainer = worldIn.getCapability(WorldMagicProvider.MAGIC);
        if (worldMagicContainer.isPresent()) {
            IWorldMagic worldMagic = (IWorldMagic)worldMagicContainer.orElse(null);
            worldMagic.removeRitualTeleportLocation(pos);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.field_72995_K) {
            worldIn.func_195594_a((IParticleData)ParticleInit.SPARKLE_VELOCITY.get(), (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177984_a().func_177956_o(), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, (double)0.1f, 0.0);
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }
}

