/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.runeforging;

import com.ma.blocks.ICustomCategory;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.interfaces.ICutoutBlock;
import com.ma.blocks.tileentities.TileEntityInit;
import com.ma.blocks.tileentities.TileEntityPedestal;
import com.ma.items.MAItemGroups;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockPedestal
extends WaterloggableBlock
implements ICutoutBlock,
ICustomCategory {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public BlockPedestal() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200943_b(3.0f).func_226896_b_().func_200947_a(SoundType.field_185851_d), false);
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.PEDESTAL.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack activeStack = player.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityPedestal) {
            TileEntityPedestal te = (TileEntityPedestal)tileEntity;
            if (!te.func_191420_l()) {
                ItemStack stack = te.func_70304_b(0);
                if (!player.func_191521_c(stack)) {
                    player.func_71019_a(stack, true);
                }
                worldIn.func_184138_a(pos, state, state, 2);
                worldIn.func_175666_e(pos, state.func_177230_c());
            } else if (!activeStack.func_190926_b() && te.func_191420_l()) {
                ItemStack single = activeStack.func_77946_l();
                single.func_190920_e(1);
                te.func_70299_a(0, single);
                worldIn.func_184138_a(pos, state, state, 2);
                worldIn.func_175666_e(pos, state.func_177230_c());
                if (!player.func_184812_l_()) {
                    activeStack.func_190918_g(1);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        this.dropInventory(world, pos);
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.dropInventory(worldIn, pos);
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        this.dropInventory(worldIn, pos);
        super.func_176208_a(worldIn, pos, state, player);
    }

    private void dropInventory(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityPedestal) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityPedestal) {
            return Container.func_94526_b((IInventory)((TileEntityPedestal)te));
        }
        return 0;
    }

    @Override
    public ItemGroup getItemGroup() {
        return MAItemGroups.runes;
    }
}

