/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.runeforging;

import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.blocks.ICustomCategory;
import com.ma.blocks.tileentities.TileEntityRuneForge;
import com.ma.items.ItemInit;
import com.ma.items.MAItemGroups;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockRuneforge
extends Block
implements ICustomCategory {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final BooleanProperty ORE_DOUBLING = BooleanProperty.func_177716_a((String)"doubling");
    public static final IntegerProperty MATERIAL = IntegerProperty.func_177719_a((String)"material", (int)0, (int)1);

    public BlockRuneforge() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f).harvestTool(ToolType.PICKAXE).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)MATERIAL, (Comparable)Integer.valueOf(0)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRuneForge();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ACTIVE, MATERIAL, ORE_DOUBLING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack activeStack = player.func_184586_b(handIn);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityRuneForge) {
            TileEntityRuneForge te = (TileEntityRuneForge)tileEntity;
            if (activeStack.func_77973_b() == ItemInit.BRIMSTONE_CHARM.get()) {
                if ((Integer)state.func_177229_b((Property)MATERIAL) == 0) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)MATERIAL, (Comparable)Integer.valueOf(1)), 3);
                        worldIn.func_184133_a(null, pos, SFX.Spell.Buff.FIRE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        if (!player.func_184812_l_()) {
                            activeStack.func_190918_g(1);
                        }
                    } else {
                        for (int i = 0; i < 150; ++i) {
                            worldIn.func_195594_a((IParticleData)ParticleInit.FLAME.get(), (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random() * 2.0, (double)pos.func_177952_p() + Math.random(), 0.0, Math.random() * 0.01 + 0.01, 0.0);
                        }
                    }
                }
            } else if (!te.func_191420_l()) {
                if (!worldIn.field_72995_K) {
                    ItemStack stack = te.func_70304_b(0);
                    if (!player.func_191521_c(stack)) {
                        player.func_71019_a(stack, true);
                    }
                    worldIn.func_184138_a(pos, state, state, 2);
                }
            } else if (!worldIn.field_72995_K && !activeStack.func_190926_b() && te.func_191420_l()) {
                ItemStack insert = activeStack.func_77946_l();
                int quantity = Math.min(16, insert.func_190916_E());
                insert.func_190920_e(quantity);
                te.func_70299_a(0, insert);
                worldIn.func_184138_a(pos, state, state, 2);
                if (!player.func_184812_l_()) {
                    activeStack.func_190918_g(quantity);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            return 15;
        }
        return super.getLightValue(state, world, pos);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        this.dropInventory(world, pos, state);
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.dropInventory(worldIn, pos, worldIn.func_180495_p(pos));
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        this.dropInventory(worldIn, pos, state);
        super.func_176208_a(worldIn, pos, state, player);
    }

    private void dropInventory(World world, BlockPos pos, BlockState state) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityRuneForge) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
        if ((Integer)state.func_177229_b((Property)MATERIAL) == 1) {
            InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)ItemInit.BRIMSTONE_CHARM.get())}));
        }
    }

    @Override
    public ItemGroup getItemGroup() {
        return MAItemGroups.runes;
    }
}

