/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.runeforging;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.sound.SFX;
import com.ma.blocks.ICustomCategory;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.interfaces.ICutoutBlock;
import com.ma.blocks.tileentities.TileEntityInit;
import com.ma.blocks.tileentities.TileEntityRunicAnvil;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.items.ItemInit;
import com.ma.items.MAItemGroups;
import com.ma.items.armor.BrokenMageArmor;
import com.ma.items.runes.ItemRune;
import com.ma.items.runes.ItemRunescribingRecipe;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.runeforging.RuneforgingRecipe;
import com.ma.recipes.runeforging.RunescribingRecipe;
import com.ma.tools.MATags;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class BlockRunicAnvil
extends WaterloggableBlock
implements ICutoutBlock,
ICustomCategory {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final ResourceLocation TAG_COALS = new ResourceLocation("coals");

    public BlockRunicAnvil() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200943_b(3.0f).func_226896_b_().func_200947_a(SoundType.field_185858_k), false);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, ACTIVE});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.RUNIC_ANVIL.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack activeStack = player.func_184586_b(handIn);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null && !(tileEntity instanceof TileEntityRunicAnvil)) {
            return ActionResultType.SUCCESS;
        }
        TileEntityRunicAnvil te = (TileEntityRunicAnvil)tileEntity;
        if (activeStack.func_77973_b() == ItemInit.RUNESMITH_HAMMER.get()) {
            return this.onHammerUse(activeStack, player, worldIn, pos, state, te);
        }
        if (MATags.isItemEqual(activeStack, TAG_COALS)) {
            return this.onCharcoalUse(activeStack, player, worldIn, pos, state, te);
        }
        if (activeStack.func_77973_b() == ItemInit.SORCEROUS_SEWING_SET.get()) {
            return this.onSewingKitUse(activeStack, player, worldIn, pos, state, te);
        }
        return this.onGenericItemUse(activeStack, player, worldIn, pos, state, te);
    }

    private ActionResultType onGenericItemUse(ItemStack activeStack, PlayerEntity player, World worldIn, BlockPos pos, BlockState state, TileEntityRunicAnvil te) {
        if (!worldIn.field_72995_K) {
            IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (progression == null) {
                return ActionResultType.FAIL;
            }
            if (!this.insertItems(te, player, activeStack, worldIn, pos, state, progression.getTier())) {
                this.removeItems(te, player, activeStack, worldIn, pos, state);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private ActionResultType onCharcoalUse(ItemStack activeStack, PlayerEntity player, World worldIn, BlockPos pos, BlockState state, TileEntityRunicAnvil te) {
        ItemStack rune = te.func_70301_a(0);
        if (!(rune.func_77973_b() instanceof ItemRune)) {
            return ActionResultType.FAIL;
        }
        if (te.func_70301_a(1).func_77973_b() != Items.field_151121_aF) {
            return ActionResultType.FAIL;
        }
        Optional<RuneforgingRecipe> forgeRecipe = worldIn.func_199532_z().func_241447_a_(RecipeInit.RUNEFORGING_TYPE).stream().filter(r -> r.getOutputResource().toString().equals(rune.func_77973_b().getRegistryName().toString())).findFirst();
        if (!forgeRecipe.isPresent()) {
            return ActionResultType.FAIL;
        }
        Optional<RunescribingRecipe> scribeRecipe = worldIn.func_199532_z().func_241447_a_(RecipeInit.RUNESCRIBING_TYPE).stream().filter(r -> r.getOutputResource().toString().equals(((RuneforgingRecipe)forgeRecipe.get()).getPatternResource().toString())).findFirst();
        if (!scribeRecipe.isPresent()) {
            return ActionResultType.FAIL;
        }
        ItemStack patternStack = new ItemStack((IItemProvider)ItemInit.RECIPE_SCRAP_RUNESCRIBING.get());
        ItemRunescribingRecipe.setRecipe(patternStack, scribeRecipe.get());
        if (!worldIn.field_72995_K) {
            te.func_70299_a(1, patternStack);
        }
        worldIn.func_184148_a(player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SFX.Gui.CHARCOAL_SCRIBBLE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.func_184812_l_()) {
            activeStack.func_190918_g(1);
        }
        if (!worldIn.field_72995_K) {
            BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)patternStack, (IInventory)new Inventory(new ItemStack[]{rune, patternStack}));
        }
        return ActionResultType.SUCCESS;
    }

    private ActionResultType onHammerUse(ItemStack activeStack, PlayerEntity player, World worldIn, BlockPos pos, BlockState state, TileEntityRunicAnvil te) {
        if (player.func_184811_cZ().func_185143_a((Item)ItemInit.RUNESMITH_HAMMER.get(), 0.0f) > 0.0f) {
            return ActionResultType.SUCCESS;
        }
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return ActionResultType.FAIL;
        }
        if (worldIn.field_72995_K) {
            Item item = te.func_70301_a(1).func_77973_b();
            this.spawnParticles(item, worldIn, pos);
        }
        int advanceResponse = te.advanceCrafting(player, progression.getTier());
        if (!worldIn.field_72995_K) {
            if (advanceResponse == 0 || advanceResponse == 4) {
                player.func_184811_cZ().func_185145_a((Item)ItemInit.RUNESMITH_HAMMER.get(), 10);
            } else if (advanceResponse == 2) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("block.mana-and-artifice.runic_anvil.low_tier"), Util.field_240973_b_);
            } else if (te.func_70301_a(0).func_190926_b()) {
                this.insertItems(te, player, activeStack, worldIn, pos, state, progression.getTier());
            }
        }
        return ActionResultType.SUCCESS;
    }

    private ActionResultType onSewingKitUse(ItemStack activeStack, PlayerEntity player, World worldIn, BlockPos pos, BlockState state, TileEntityRunicAnvil te) {
        ItemStack armor = te.func_70301_a(0);
        if (!(armor.func_77973_b() instanceof BrokenMageArmor)) {
            return ActionResultType.FAIL;
        }
        if (te.func_70301_a(1).func_77973_b() != ItemInit.INFUSED_SILK.get()) {
            return ActionResultType.FAIL;
        }
        BrokenMageArmor restoredItem = (BrokenMageArmor)armor.func_77973_b();
        ItemStack restoredStack = restoredItem.restore(armor);
        restoredStack.func_196085_b(0);
        te.func_70299_a(1, ItemStack.field_190927_a);
        activeStack.func_222118_a(1, (LivingEntity)player, e -> {});
        worldIn.func_184148_a(player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187719_p, SoundCategory.BLOCKS, 1.0f, 1.0f);
        te.func_70299_a(0, restoredStack);
        return ActionResultType.SUCCESS;
    }

    private void spawnParticles(Item item, World worldIn, BlockPos pos) {
        if (item == ItemInit.VINTEUM_INGOT_SUPERHEATED.get()) {
            for (int i = 0; i < 3; ++i) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + 0.5f), -0.5 + Math.random(), Math.random(), -0.5 + Math.random());
            }
        } else if (item instanceof ItemRune) {
            for (int i = 0; i < 3; ++i) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197614_g, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + 0.5f), -0.5 + Math.random(), Math.random(), -0.5 + Math.random());
            }
        }
        worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.5f, (float)Math.random() * 0.1f + 0.9f, false);
    }

    private boolean insertItems(TileEntityRunicAnvil te, PlayerEntity player, ItemStack heldStack, World world, BlockPos pos, BlockState state, int playerTier) {
        ItemStack single = heldStack.func_77946_l();
        single.func_190920_e(1);
        if (te.pushItemStack(single, playerTier)) {
            if (!player.func_184812_l_() || heldStack.func_77973_b() == ItemInit.RUNESMITH_HAMMER.get()) {
                heldStack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private void removeItems(TileEntityRunicAnvil te, PlayerEntity player, ItemStack heldStack, World world, BlockPos pos, BlockState state) {
        ItemStack stack = te.popItemStack();
        if (!stack.func_190926_b() && !player.func_191521_c(stack)) {
            player.func_71019_a(stack, true);
        }
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        this.dropInventory(world, pos);
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.dropInventory(worldIn, pos);
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        this.dropInventory(worldIn, pos);
        super.func_176208_a(worldIn, pos, state, player);
    }

    private void dropInventory(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
    }

    @Override
    public ItemGroup getItemGroup() {
        return MAItemGroups.runes;
    }
}

