/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.sorcery;

import com.ma.api.particles.ParticleInit;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.interfaces.ITranslucentBlock;
import com.ma.blocks.tileentities.TileEntityManaCrystal;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockManaCrystal
extends WaterloggableBlock
implements ITranslucentBlock {
    protected static final VoxelShape SHAPE_NORMAL = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)25.5, (double)16.0);
    protected static final VoxelShape SHAPE_HANGING = Block.func_208617_a((double)0.0, (double)-9.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BooleanProperty HANGING = BooleanProperty.func_177716_a((String)"hanging");

    public BlockManaCrystal() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(2.0f).func_226896_b_().func_200947_a(SoundType.field_185853_f).func_208770_d(), false);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean hanging = false;
        if (context.func_196000_l() == Direction.DOWN) {
            hanging = true;
        }
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HANGING});
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.field_72995_K && rand.nextBoolean()) {
            Vector3d origin = this.getRandomPointAroundBlock(pos, stateIn, true);
            Vector3d dest = this.getRandomPointAroundBlock(pos, stateIn, false);
            worldIn.func_195594_a((IParticleData)ParticleInit.LIGHTNING_BOLT.get(), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, dest.field_72450_a, dest.field_72448_b, dest.field_72449_c);
        }
    }

    private Vector3d getRandomPointAroundBlock(BlockPos pos, BlockState state, boolean touch) {
        return new Vector3d(touch ? (double)pos.func_177958_n() + 0.25 + Math.random() * 0.5 : (double)pos.func_177958_n() + Math.random(), (double)(pos.func_177956_o() + ((Boolean)state.func_177229_b((Property)HANGING) != false ? 0 : 1)) - 0.5 + Math.random(), touch ? (double)pos.func_177952_p() + 0.25 + Math.random() * 0.5 : (double)pos.func_177952_p() + Math.random());
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityManaCrystal();
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 10;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)HANGING) != false ? SHAPE_HANGING : SHAPE_NORMAL;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

