/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.blocks.artifice.BlockArcaneSentry;
import com.ma.blocks.tileentities.TileEntityInit;
import com.ma.blocks.tileentities.TileEntityWithInventory;
import com.ma.entities.projectile.EntitySentryProjectile;
import com.ma.gui.containers.ContainerArcaneSentry;
import com.ma.items.ItemInit;
import com.ma.network.ClientMessageDispatcher;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.scoreboard.Team;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.extensions.IForgeTileEntity;

public class TileEntityArcaneSentry
extends TileEntityWithInventory
implements INamedContainerProvider,
ITickableTileEntity,
IForgeTileEntity,
Consumer<PacketBuffer> {
    private static final int TARGET_TIME = 100;
    private static final int SHOOT_INTERVAL = 60;
    private static final int WARMUP_INTERVAL = 40;
    private LivingEntity target = null;
    private int findTargetCounter = 0;
    private int ammoCount = 0;
    private int shootCounter = 0;
    private int warmupCounter = 0;
    public float nextPageTurningSpeed;
    public float pageTurningSpeed;
    public float nextPageAngle;
    public float pageAngle;
    public float field_195523_f;
    public float field_195524_g;
    public float field_195525_h;
    public float field_195526_i;
    public float yaw;
    public int ticks;
    public int ticksSinceTargetChange;
    private static final Random random = new Random();
    private static float radius = 0.5f;
    private static float yOffset = 1.3f;
    private UUID ownerID;
    private String teamName;
    private PlayerEntity _cachedOwner;
    private Team _cachedOwnerTeam;
    private boolean targetPlayers = false;

    public TileEntityArcaneSentry() {
        super((TileEntityType)TileEntityInit.ARCANE_SENTRY.get(), 1);
    }

    public void func_73660_a() {
        if (!this.hasTarget()) {
            this.getTarget();
        } else {
            this.shoot();
        }
        if (this.field_145850_b.field_72995_K) {
            this.updatePageTurning();
            this.spawnParticles();
        }
    }

    private void updatePageTurning() {
        float f2;
        this.pageTurningSpeed = this.nextPageTurningSpeed;
        this.pageAngle = this.nextPageAngle;
        if (this.target != null) {
            double d0 = this.target.func_226277_ct_() - ((double)this.field_174879_c.func_177958_n() + 0.5);
            double d1 = this.target.func_226281_cx_() - ((double)this.field_174879_c.func_177952_p() + 0.5);
            this.yaw = (float)MathHelper.func_181159_b((double)d1, (double)d0);
            this.nextPageTurningSpeed += 0.1f;
            if (this.nextPageTurningSpeed < 0.5f || random.nextInt(40) == 0) {
                float f1 = this.field_195525_h;
                do {
                    this.field_195525_h += (float)(random.nextInt(4) - random.nextInt(4));
                } while (f1 == this.field_195525_h);
            }
        } else {
            this.yaw += 0.02f;
            this.nextPageTurningSpeed -= 0.1f;
        }
        while (this.nextPageAngle >= (float)Math.PI) {
            this.nextPageAngle -= (float)Math.PI * 2;
        }
        while (this.nextPageAngle < (float)(-Math.PI)) {
            this.nextPageAngle += (float)Math.PI * 2;
        }
        while (this.yaw >= (float)Math.PI) {
            this.yaw -= (float)Math.PI * 2;
        }
        while (this.yaw < (float)(-Math.PI)) {
            this.yaw += (float)Math.PI * 2;
        }
        for (f2 = this.yaw - this.nextPageAngle; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.nextPageAngle += f2 * 0.4f;
        this.nextPageTurningSpeed = MathHelper.func_76131_a((float)this.nextPageTurningSpeed, (float)0.0f, (float)1.0f);
        ++this.ticks;
        ++this.ticksSinceTargetChange;
        this.field_195524_g = this.field_195523_f;
        float f = (this.field_195525_h - this.field_195523_f) * 0.4f;
        f = MathHelper.func_76131_a((float)f, (float)-0.2f, (float)0.2f);
        this.field_195526_i += (f - this.field_195526_i) * 0.9f;
        this.field_195523_f += this.field_195526_i;
    }

    private Vector3d getPointInFront() {
        Vector3d pos = new Vector3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + yOffset), (double)((float)this.func_174877_v().func_177952_p() + 0.5f));
        Vector3f front = new Vector3f(0.5f, 0.0f, 0.0f);
        Quaternion q = new Quaternion(Vector3f.field_229181_d_, this.yaw, false);
        front.func_214905_a(q);
        return pos.func_178787_e(new Vector3d(front));
    }

    private void spawnParticles() {
        if (((Boolean)this.func_195044_w().func_177229_b((Property)BlockArcaneSentry.SHOOTING)).booleanValue()) {
            int numParticles = 5;
            Vector3d pos = this.getPointInFront();
            for (int i = 0; i < numParticles; ++i) {
                Vector3d offset = new Vector3d(random.nextGaussian(), random.nextGaussian(), random.nextGaussian()).func_72432_b().func_186678_a((double)radius);
                this.field_145850_b.func_195594_a((IParticleData)ParticleInit.ARCANE_LERP.get(), pos.field_72450_a + offset.field_72450_a, pos.field_72448_b + offset.field_72448_b, pos.field_72449_c + offset.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            }
        }
    }

    public boolean hasTarget() {
        block2: {
            block4: {
                block3: {
                    if (this.target == null) break block2;
                    if (!this.target.func_70089_S()) break block3;
                    Vector3d vector3d = new Vector3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
                    if (!(this.target.func_195048_a(vector3d) > 144.0)) break block4;
                }
                this.clearTarget();
                this.getTarget(true);
                return false;
            }
            return true;
        }
        return false;
    }

    private void getTarget() {
        this.getTarget(false);
    }

    public PlayerEntity getOwner() {
        if (this._cachedOwner == null && this.ownerID != null) {
            this._cachedOwner = this.field_145850_b.func_217371_b(this.ownerID);
        }
        return this._cachedOwner;
    }

    @Nullable
    public Team getOwnerTeam() {
        if (this.getOwner() != null) {
            this._cachedOwnerTeam = this.getOwner().func_96124_cp();
        } else if (this.teamName != null) {
            this._cachedOwnerTeam = this.field_145850_b.func_96441_U().func_96508_e(this.teamName);
        }
        return this._cachedOwnerTeam;
    }

    public void setOwner(PlayerEntity owner) {
        this.ownerID = owner.func_110124_au();
    }

    public void setTargetPlayers(boolean target) {
        this.targetPlayers = target;
        if (this.field_145850_b.field_72995_K) {
            ClientMessageDispatcher.sendArcaneSentryTargetPlayersMessage(this);
        } else {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public boolean getTargetPlayers() {
        return this.targetPlayers;
    }

    private void getTarget(boolean force) {
        ++this.findTargetCounter;
        if (this.findTargetCounter >= 100 || force) {
            this.findTargetCounter = 0;
            Vector3d myPos = new Vector3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
            List potentialTargets = this.field_145850_b.func_175647_a(LivingEntity.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(10.0), e -> {
                Vector3d theirpos = new Vector3d(e.func_226277_ct_(), e.func_226280_cw_(), e.func_226281_cx_());
                boolean subPredicate = e instanceof IMob;
                if (this.targetPlayers && e instanceof PlayerEntity) {
                    if (e == this.getOwner()) {
                        subPredicate = false;
                    } else if (e.func_96124_cp() == null || !e.func_96124_cp().func_142054_a(this.getOwnerTeam())) {
                        subPredicate = true;
                    }
                }
                return e.func_70089_S() && subPredicate && this.field_145850_b.func_217299_a(new RayTraceContext(myPos, theirpos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null)).func_216346_c() == RayTraceResult.Type.MISS;
            });
            if (potentialTargets.size() > 0) {
                potentialTargets.sort((o1, o2) -> {
                    Double o1Dist = o1.func_195048_a(myPos);
                    Double o2Dist = o2.func_195048_a(myPos);
                    return o1Dist.compareTo(o2Dist);
                });
                this.target = (LivingEntity)potentialTargets.get(0);
                this.ticksSinceTargetChange = 0;
            }
        }
    }

    private void clearTarget() {
        this.target = null;
        this.ticksSinceTargetChange = 0;
        this.warmupCounter = 0;
        this.shootCounter = 0;
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockArcaneSentry.SHOOTING, (Comparable)Boolean.valueOf(false)));
    }

    private boolean consumeFuel() {
        if (this.ammoCount <= 0) {
            ItemStack stack = this.func_70301_a(0);
            if (stack.func_77973_b() == ItemInit.VINTEUM_DUST.get()) {
                stack.func_190918_g(1);
                this.ammoCount += 5;
            } else if (stack.func_77973_b() == ItemInit.PURIFIED_VINTEUM_DUST.get()) {
                stack.func_190918_g(1);
                this.ammoCount += 10;
            }
        }
        return this.ammoCount > 0;
    }

    private void shoot() {
        PlayerEntity playerTarget;
        if (this.shootCounter < 60) {
            ++this.shootCounter;
            return;
        }
        if (this.target instanceof PlayerEntity && (playerTarget = (PlayerEntity)this.target).func_96124_cp() != null && playerTarget.func_96124_cp().func_142054_a(this.getOwnerTeam())) {
            this.clearTarget();
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.consumeFuel()) {
            if (!((Boolean)this.func_195044_w().func_177229_b((Property)BlockArcaneSentry.SHOOTING)).booleanValue()) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockArcaneSentry.SHOOTING, (Comparable)Boolean.valueOf(true)));
            }
            if (this.warmupCounter < 40) {
                ++this.warmupCounter;
                return;
            }
            --this.ammoCount;
            this.warmupCounter = 0;
            this.shootCounter = 0;
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockArcaneSentry.SHOOTING, (Comparable)Boolean.valueOf(false)));
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SFX.Spell.Impact.AoE.ARCANE, SoundCategory.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.4f));
            Vector3d myPos = this.getPointInFront();
            EntitySentryProjectile projectile = new EntitySentryProjectile(this.field_145850_b, myPos.func_82615_a(), myPos.func_82617_b(), myPos.func_82616_c());
            Vector3d direction = this.target.func_174824_e(0.0f).func_178788_d(myPos).func_72432_b();
            projectile.func_70186_c(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c, 1.0f, 0.0f);
            this.field_145850_b.func_217376_c((Entity)projectile);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74778_a("ownerID", this.ownerID != null ? this.ownerID.toString() : "");
        compound.func_74778_a("team", this._cachedOwnerTeam != null ? this._cachedOwnerTeam.func_96661_b() : "");
        compound.func_74757_a("targetPlayers", this.targetPlayers);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("ownerID")) {
            try {
                this.ownerID = UUID.fromString(compound.func_74779_i("ownerID"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (compound.func_74764_b("team")) {
            this.teamName = compound.func_74779_i("team");
        }
        if (compound.func_74764_b("targetPlayers")) {
            this.targetPlayers = compound.func_74767_n("targetPlayers");
        }
        super.func_230337_a_(state, compound);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Arcane Sentry");
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerArcaneSentry(id, playerInventory, this);
    }

    @Override
    public void accept(PacketBuffer packetBuffer) {
        packetBuffer.func_179255_a(this.func_174877_v());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }
}

