/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.artifice.BlockConstructWorkbench;
import com.ma.blocks.tileentities.TileEntityInit;
import com.ma.entities.constructs.animated.AnimatedConstructConstruction;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.entities.sorcery.EntityAffinityIcon;
import com.ma.events.EventDispatcher;
import com.ma.items.constructs.parts._base.ItemConstructPart;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityConstructWorkbench
extends TileEntity
implements ITickableTileEntity {
    private static final String NBT_CRAFTING = "crafting";
    private static final String NBT_CRAFT_TICKS = "craft_ticks";
    private static final String NBT_CRAFTER = "crafter";
    private static final String NBT_KNOWN_POS = "known_pos";
    AnimatedConstructConstruction construct = new AnimatedConstructConstruction();
    private boolean crafting = false;
    private int craftTicks = 0;
    private UUID crafter;
    ArrayList<PosAffinityData> knownPositions = new ArrayList();

    public TileEntityConstructWorkbench() {
        super((TileEntityType)TileEntityInit.CONSTRUCT_WORKBENCH.get());
    }

    public void func_73660_a() {
        if (this.crafting) {
            if (this.field_145850_b.field_72995_K) {
                Vector3d me = new Vector3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.65f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f));
                for (PosAffinityData pos : this.knownPositions) {
                    Vector3d start = new Vector3d((double)((float)pos.getPos().func_177958_n() + 0.5f), (double)((float)pos.getPos().func_177956_o() + 0.5f), (double)((float)pos.getPos().func_177952_p() + 0.5f));
                    this.field_145850_b.func_195594_a(this.getForAffinity(pos.getAffinity()), start.func_82615_a(), start.func_82617_b(), start.func_82616_c(), me.func_82615_a(), me.func_82617_b(), me.func_82616_c());
                }
            }
            ++this.craftTicks;
            if (this.craftTicks >= 200 && !this.field_145850_b.field_72995_K) {
                this.spawnConstruct(this.crafter);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private IParticleData getForAffinity(Affinity aff) {
        switch (aff) {
            case ARCANE: {
                return (IParticleData)ParticleInit.ARCANE_LERP.get();
            }
            case EARTH: {
                return (IParticleData)ParticleInit.DUST_LERP.get();
            }
            case ENDER: {
                return (IParticleData)ParticleInit.ENDER.get();
            }
            case FIRE: 
            case HELLFIRE: {
                return (IParticleData)ParticleInit.FLAME_LERP.get();
            }
            case LIGHTNING: {
                return (IParticleData)ParticleInit.LIGHTNING_BOLT.get();
            }
            case WATER: {
                return (IParticleData)ParticleInit.WATER_LERP.get();
            }
            case ICE: {
                return (IParticleData)ParticleInit.FROST_LERP.get();
            }
            case WIND: {
                return (IParticleData)ParticleInit.AIR_LERP.get();
            }
        }
        return (IParticleData)ParticleInit.SPARKLE_LERP_POINT.get();
    }

    public int getCraftTicks() {
        return this.craftTicks;
    }

    public ArrayList<PosAffinityData> getKnownPositions() {
        return this.knownPositions;
    }

    public boolean getIsCrafting() {
        return this.crafting;
    }

    public ItemStack placePart(ItemStack stack) {
        if (this.crafting || stack.func_190916_E() != 1 || !(stack.func_77973_b() instanceof ItemConstructPart)) {
            return stack;
        }
        ItemConstructPart part = (ItemConstructPart)stack.func_77973_b();
        ItemStack output = this.construct.setPart(part);
        return output;
    }

    public void setConstructData(AnimatedConstructConstruction data) {
        if (!this.field_145850_b.field_72995_K) {
            this.construct = data.copy();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    private void spawnConstruct(UUID owner) {
        if (this.construct.isComplete() && !this.field_145850_b.field_72995_K) {
            this.crafting = false;
            this.craftTicks = 0;
            this.crafter = null;
            EntityAnimatedConstruct eac = new EntityAnimatedConstruct(this.field_145850_b);
            BlockPos pos = this.func_174877_v();
            Direction dir = (Direction)this.func_195044_w().func_177229_b((Property)BlockConstructWorkbench.FACING);
            eac.func_70107_b((float)pos.func_177958_n() + 0.5f + (float)dir.func_82601_c(), pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f + (float)dir.func_82599_e());
            eac.setConstructParts(this.construct);
            eac.setOwner(owner);
            HashMap affinities = new HashMap();
            this.getNearbyEntities().forEach(e -> {
                if (!affinities.containsKey((Object)e.getAffinity())) {
                    affinities.put(e.getAffinity(), 1);
                } else {
                    affinities.put(e.getAffinity(), (Integer)affinities.get((Object)e.getAffinity()) + 1);
                }
                e.remove(false);
            });
            for (Affinity aff : affinities.keySet()) {
                eac.getConstructData().setAffinityScore(aff, (Integer)affinities.get((Object)aff));
            }
            this.field_145850_b.func_217376_c((Entity)eac);
            this.construct = new AnimatedConstructConstruction();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            PlayerEntity player = this.field_145850_b.func_217371_b(owner);
            if (player != null) {
                EventDispatcher.DispatchConstructCrafted((Entity)eac, player);
            }
        }
    }

    private List<EntityAffinityIcon> getNearbyEntities() {
        int search_radius = 5;
        final Vector3d myVec = new Vector3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f));
        AxisAlignedBB bb = new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)search_radius);
        List<EntityAffinityIcon> entities = this.field_145850_b.func_217357_a(EntityAffinityIcon.class, bb).stream().map(e -> e).sorted(new Comparator<EntityAffinityIcon>(){

            @Override
            public int compare(EntityAffinityIcon o1, EntityAffinityIcon o2) {
                Double d1 = o1.func_213303_ch().func_72436_e(myVec);
                Double d2 = o2.func_213303_ch().func_72436_e(myVec);
                return d1.compareTo(d2);
            }
        }).limit(8L).collect(Collectors.toList());
        return entities;
    }

    private boolean findNearbyPoints() {
        List<EntityAffinityIcon> entities = this.getNearbyEntities();
        if (entities.size() < 8) {
            return false;
        }
        this.knownPositions.clear();
        entities.stream().forEach(e -> this.knownPositions.add(new PosAffinityData(new BlockPos(e.func_213303_ch()), e.getAffinity())));
        return true;
    }

    public boolean isEmpty() {
        return this.construct.isEmpty();
    }

    public boolean startCrafting(@Nonnull PlayerEntity player) {
        if (!this.crafting && this.construct.isComplete() && !this.field_145850_b.field_72995_K && this.findNearbyPoints()) {
            this.crafting = true;
            this.craftTicks = 0;
            this.crafter = player.func_110124_au();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            return true;
        }
        return false;
    }

    private void writeKnownPositions(CompoundNBT nbt) {
        CompoundNBT known = new CompoundNBT();
        known.func_74768_a("count", this.knownPositions.size());
        for (int i = 0; i < this.knownPositions.size(); ++i) {
            known.func_218657_a("pos" + i, (INBT)NBTUtil.func_186859_a((BlockPos)this.knownPositions.get(i).getPos()));
            known.func_74778_a("aff" + i, this.knownPositions.get(i).getAffinity().toString());
        }
        nbt.func_218657_a(NBT_KNOWN_POS, (INBT)known);
    }

    private void readKnownPositions(CompoundNBT nbt) {
        if (nbt.func_74764_b(NBT_KNOWN_POS)) {
            CompoundNBT known = nbt.func_74775_l(NBT_KNOWN_POS);
            int count = known.func_74762_e("count");
            this.knownPositions.clear();
            for (int i = 0; i < count; ++i) {
                try {
                    BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)known.func_74775_l("pos" + i));
                    Affinity aff = Affinity.valueOf(known.func_74779_i("aff" + i));
                    this.knownPositions.add(new PosAffinityData(pos, aff));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT base = super.func_189515_b(compound);
        this.construct.WriteNBT(base);
        base.func_74757_a(NBT_CRAFTING, this.crafting);
        base.func_74768_a(NBT_CRAFT_TICKS, this.craftTicks);
        base.func_74778_a(NBT_CRAFTER, this.crafter != null ? this.crafter.toString() : "");
        this.writeKnownPositions(base);
        return base;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        String crafterUUIDString;
        super.func_230337_a_(state, nbt);
        this.construct.ReadNBT(nbt);
        if (nbt.func_74764_b(NBT_CRAFTING)) {
            this.crafting = nbt.func_74767_n(NBT_CRAFTING);
        }
        if (nbt.func_74764_b(NBT_CRAFT_TICKS)) {
            this.craftTicks = nbt.func_74762_e(NBT_CRAFT_TICKS);
        }
        if (nbt.func_74764_b(NBT_CRAFTER) && !(crafterUUIDString = nbt.func_74779_i(NBT_CRAFTER)).isEmpty()) {
            this.crafter = UUID.fromString(crafterUUIDString);
        }
        this.readKnownPositions(nbt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT payload = new CompoundNBT();
        this.construct.WriteNBT(payload);
        payload.func_74757_a(NBT_CRAFTING, this.crafting);
        payload.func_74768_a(NBT_CRAFT_TICKS, this.craftTicks);
        this.writeKnownPositions(payload);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, payload);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.construct.ReadNBT(nbt);
        if (nbt.func_74764_b(NBT_CRAFTING)) {
            this.crafting = nbt.func_74767_n(NBT_CRAFTING);
        }
        if (nbt.func_74764_b(NBT_CRAFT_TICKS)) {
            this.craftTicks = nbt.func_74762_e(NBT_CRAFT_TICKS);
        }
        this.readKnownPositions(nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT payload = super.func_189517_E_();
        this.construct.WriteNBT(payload);
        payload.func_74757_a(NBT_CRAFTING, this.crafting);
        payload.func_74768_a(NBT_CRAFT_TICKS, this.craftTicks);
        return payload;
    }

    public AnimatedConstructConstruction getConstruct() {
        return this.construct;
    }

    class PosAffinityData {
        BlockPos pos;
        Affinity aff;

        public PosAffinityData(BlockPos pos, Affinity affinity) {
            this.aff = affinity;
            this.pos = pos;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Affinity getAffinity() {
            return this.aff;
        }
    }
}

