/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.BlockInit;
import com.ma.blocks.manaweaving.BlockManaweaveProjector;
import com.ma.blocks.tileentities.TileEntityInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.util.LazyOptional;

public class TileEntityManaResevoir
extends TileEntity
implements ITickableTileEntity {
    public static final float MAX_MANA = 100.0f;
    private static final float maxStealPerSecond = 5.0f;
    private static final int RADIUS = 2;
    private static final int CRYSTAL_RADIUS = 8;
    private int tickCount = 0;
    private float mana = 0.0f;
    private ArrayList<BlockPos> knownCrystalPositions = new ArrayList();
    private ArrayList<BlockPos> toRemove = new ArrayList();

    public TileEntityManaResevoir() {
        super((TileEntityType)TileEntityInit.MANA_RESEVOIR.get());
    }

    public void func_73660_a() {
        ++this.tickCount;
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles();
        } else {
            this.runLogic_server();
        }
    }

    private void spawnParticles() {
        BlockPos blockPos = this.func_174877_v();
        if ((Integer)this.func_195044_w().func_177229_b((Property)BlockManaweaveProjector.FILL_LEVEL) != 4) {
            if (this.tickCount % 40 == 0) {
                this.scanForNearbyCrystals(8);
            }
            if (this.tickCount % 2 == 0) {
                List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(2.0));
                for (PlayerEntity player : players) {
                    Vector3d pos = player.func_213303_ch();
                    this.field_145850_b.func_195594_a((IParticleData)ParticleInit.SPARKLE_LERP_POINT.get(), pos.func_82615_a(), pos.func_82617_b() + (double)1.2f, pos.func_82616_c(), (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
                }
                this.toRemove.clear();
                for (BlockPos pos : this.knownCrystalPositions) {
                    if (!this.field_145850_b.func_195588_v(pos)) continue;
                    if (this.field_145850_b.func_180495_p(pos).func_177230_c() == BlockInit.MANA_CRYSTAL.get()) {
                        this.field_145850_b.func_195594_a((IParticleData)ParticleInit.SPARKLE_LERP_POINT.get(), (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.2f), (double)((float)pos.func_177952_p() + 0.5f), (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
                        continue;
                    }
                    this.toRemove.add(pos);
                }
                this.knownCrystalPositions.removeAll(this.toRemove);
            }
        }
    }

    private void runLogic_server() {
        if (this.mana < 100.0f && !this.field_145850_b.func_175640_z(this.func_174877_v())) {
            if (this.tickCount % 40 == 0) {
                this.scanForNearbyCrystals(8);
            }
            if (this.tickCount % 2 == 0) {
                this.getManaFromAllNearby();
                this.getManaFromCrystals();
                this.updateBlockState();
            }
        }
    }

    private void updateBlockState() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState state = this.func_195044_w();
        boolean hasChange = false;
        int fillAmt = (int)Math.floor(this.mana / 100.0f * 4.0f);
        if ((Integer)state.func_177229_b((Property)BlockManaweaveProjector.FILL_LEVEL) != fillAmt) {
            state = (BlockState)state.func_206870_a((Property)BlockManaweaveProjector.FILL_LEVEL, (Comparable)Integer.valueOf(fillAmt));
            hasChange = true;
        }
        if (hasChange) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), state, 2);
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    private void getManaFromAllNearby() {
        List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(2.0));
        for (PlayerEntity player : players) {
            this.getManaFromPlayer(player);
        }
    }

    private void getManaFromCrystals() {
        this.toRemove.clear();
        for (BlockPos pos : this.knownCrystalPositions) {
            if (!this.field_145850_b.func_195588_v(pos)) continue;
            if (this.field_145850_b.func_180495_p(pos).func_177230_c() == BlockInit.MANA_CRYSTAL.get()) {
                this.mana = Math.min(this.mana + 0.5f, 100.0f);
                continue;
            }
            this.toRemove.add(pos);
        }
        this.knownCrystalPositions.removeAll(this.toRemove);
    }

    private void scanForNearbyCrystals(int radius) {
        this.knownCrystalPositions.clear();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPos pos = this.func_174877_v().func_177982_a(i, j, k);
                    if (!this.field_145850_b.func_195588_v(pos) || this.field_145850_b.func_180495_p(pos).func_177230_c() != BlockInit.MANA_CRYSTAL.get()) continue;
                    this.knownCrystalPositions.add(pos);
                }
            }
        }
    }

    private void getManaFromPlayer(PlayerEntity player) {
        float stealAmount = Math.min(100.0f - this.mana, 5.0f);
        if (stealAmount == 0.0f) {
            return;
        }
        LazyOptional magicContainer = player.getCapability(PlayerMagicProvider.MAGIC);
        if (magicContainer.isPresent()) {
            IPlayerMagic magic = (IPlayerMagic)magicContainer.orElse(null);
            if (magic.getMana() < stealAmount) {
                stealAmount = magic.getMana();
            }
            magic.consume(stealAmount);
            this.mana += stealAmount;
        }
    }

    public float getMana() {
        return this.mana;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74776_a("mana", this.mana);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("mana")) {
            this.mana = compound.func_74760_g("mana");
        }
        super.func_230337_a_(state, compound);
    }
}

