/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.blocks.tileentities.TileEntityInit;
import com.ma.blocks.tileentities.TileEntityWithInventory;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.events.EventDispatcher;
import com.ma.recipes.ItemAndPatternCraftingInventory;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternHelper;
import com.ma.recipes.manaweaving.ManaweavingRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.extensions.IForgeTileEntity;

public class TileEntityManaweavingAltar
extends TileEntityWithInventory
implements IForgeTileEntity,
ITickableTileEntity {
    public static final int MAX_ITEMS = 9;
    private ArrayList<String> pendingPatterns;
    private ArrayList<ManaweavingPattern> addedPatterns = new ArrayList();
    private boolean crafting = false;
    private int craftTicks = 0;
    private ManaweavingRecipe __cachedRecipe;
    private ItemStack __cachedRecipeOutput;
    private PlayerEntity __crafter;
    private boolean copyNBT = false;

    public TileEntityManaweavingAltar(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, 9);
        this.pendingPatterns = new ArrayList();
    }

    public TileEntityManaweavingAltar() {
        this((TileEntityType)TileEntityInit.MANAWEAVING_ALTAR.get());
    }

    public void pushPattern(ManaweavingPattern pattern, PlayerEntity player) {
        if (this.crafting) {
            return;
        }
        this.__crafter = player;
        this.resolvePendingPatterns();
        if (this.addedPatterns.size() == 6) {
            return;
        }
        this.addedPatterns.add(pattern);
        if (this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    public void popPattern(PlayerEntity player) {
        if (this.crafting) {
            return;
        }
        this.__crafter = player;
        this.resolvePendingPatterns();
        if (this.addedPatterns.size() <= 0) {
            return;
        }
        this.addedPatterns.remove(this.addedPatterns.size() - 1);
        if (this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    public boolean pushItem(PlayerEntity player, ItemStack stack) {
        if (this.crafting) {
            return false;
        }
        this.__crafter = player;
        if (stack.func_190916_E() != 1) {
            return false;
        }
        boolean success = false;
        for (int i = 0; i < 9; ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.func_70299_a(i, stack);
            success = true;
            break;
        }
        if (success && this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        return success;
    }

    public ItemStack popItem(PlayerEntity player) {
        if (this.crafting) {
            return ItemStack.field_190927_a;
        }
        this.__crafter = player;
        ItemStack output = ItemStack.field_190927_a;
        for (int i = 8; i >= 0; --i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            output = this.func_70304_b(i);
            break;
        }
        if (this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        return output;
    }

    public void clearPatterns() {
        this.addedPatterns.clear();
    }

    public Collection<ManaweavingPattern> getAddedPatterns() {
        this.resolvePendingPatterns();
        return this.addedPatterns;
    }

    @Override
    public int func_70302_i_() {
        return 9;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        CompoundNBT sub = this.writeAdditonal(new CompoundNBT());
        base.func_218657_a("invSync", (INBT)sub);
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        CompoundNBT sub = tag.func_74775_l("invSync");
        this.readAdditional(sub);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT data = new CompoundNBT();
        this.writeAdditonal(data);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, data);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT data = pkt.func_148857_g();
        boolean wasCrafting = this.crafting;
        this.readAdditional(data);
        if (wasCrafting && !this.crafting) {
            this.spawnCraftCompleteParticles();
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public ItemStack[] getDisplayedItems() {
        ItemStack[] stacks = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            stacks[i] = this.func_70301_a(i);
        }
        return stacks;
    }

    private boolean MatchesRecipe(PlayerEntity player) {
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return false;
        }
        this.__cachedRecipe = null;
        this.__cachedRecipeOutput = null;
        ManaweavingRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeInit.MANAWEAVING_RECIPE_TYPE, (IInventory)this.createCraftingInventory(), this.field_145850_b).orElse(null);
        if (recipe != null && recipe.getTier() <= progression.getTier()) {
            this.__cachedRecipe = recipe;
            this.__cachedRecipeOutput = recipe.func_77571_b().func_77946_l();
            this.copyNBT = recipe.getCopyNBT();
        }
        if (this.__cachedRecipeOutput != null && !this.__cachedRecipeOutput.func_190926_b()) {
            if (this.__cachedRecipe.getFactionRequirement() != Faction.NONE && this.__cachedRecipe.getFactionRequirement() != progression.getAlliedFaction()) {
                this.__cachedRecipeOutput = ItemStack.field_190927_a;
                this.__cachedRecipe = null;
                player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.recipe.wrongfaction"), Util.field_240973_b_);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeAdditonal(compound);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.readAdditional(compound);
        super.func_230337_a_(state, compound);
    }

    private CompoundNBT writeAdditonal(CompoundNBT compound) {
        ItemStackHelper.func_191282_a((CompoundNBT)compound, (NonNullList)this.inventoryItems);
        this.resolvePendingPatterns();
        CompoundNBT patterns = new CompoundNBT();
        int count = 0;
        for (ManaweavingPattern pattern : this.addedPatterns) {
            patterns.func_74778_a("pattern_" + count++, pattern.func_199560_c().toString());
        }
        compound.func_218657_a("patterns", (INBT)patterns);
        compound.func_74757_a("crafting", this.crafting);
        compound.func_74757_a("copyNBT", this.copyNBT);
        compound.func_74768_a("craftTicks", this.craftTicks);
        return compound;
    }

    private void readAdditional(CompoundNBT compound) {
        this.func_174888_l();
        this.addedPatterns.clear();
        this.pendingPatterns.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)this.inventoryItems);
        if (compound.func_74764_b("patterns")) {
            CompoundNBT patterns = compound.func_74775_l("patterns");
            for (String s : patterns.func_150296_c()) {
                this.pendingPatterns.add(patterns.func_74779_i(s));
            }
        }
        this.crafting = compound.func_74767_n("crafting");
        this.craftTicks = compound.func_74762_e("craftTicks");
        this.copyNBT = compound.func_74767_n("copyNBT");
    }

    public void spawnCraftingParticles() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        Random rnd = new Random();
        BlockPos pos = this.func_174877_v();
        Vector3f srcPoint = new Vector3f((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 1.0f, (float)pos.func_177952_p() + 0.5f);
        for (int i = 0; i < 10; ++i) {
            Vector3f lightPoint = new Vector3f(srcPoint.func_195899_a() - 0.2f + rnd.nextFloat() * 0.4f, srcPoint.func_195900_b(), srcPoint.func_195902_c() - 0.2f + rnd.nextFloat() * 0.4f);
            this.field_145850_b.func_195594_a((IParticleData)ParticleInit.LIGHT_VELOCITY.get(), (double)lightPoint.func_195899_a(), (double)lightPoint.func_195900_b(), (double)lightPoint.func_195902_c(), 0.0, 0.01, 0.0);
        }
        float SPEED = 0.1f;
        float RADIUS = 0.25f;
        int i = 0;
        while ((double)i < (double)this.craftTicks * 1.5) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get(), (double)srcPoint.func_195899_a(), (double)(srcPoint.func_195900_b() + 0.4f), (double)srcPoint.func_195902_c(), (double)SPEED, (double)rnd.nextInt(360), (double)RADIUS);
            ++i;
        }
        if (this.getCraftTicks() > this.getMaxCraftTicks() - 20) {
            RADIUS = 0.6f - rnd.nextFloat() * 0.25f;
            for (i = 0; i < 100; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get(), (double)srcPoint.func_195899_a(), (double)srcPoint.func_195900_b(), (double)srcPoint.func_195902_c(), (double)SPEED + rnd.nextGaussian() * (double)0.1f, (double)(-30 + rnd.nextInt(30)), (double)RADIUS);
            }
        }
    }

    public void spawnCraftCompleteParticles() {
        int i;
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        Random rnd = new Random();
        Vector3f srcPoint = new Vector3f((float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 1.3f, (float)this.func_174877_v().func_177952_p() + 0.5f);
        for (i = 0; i < 150; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleInit.BLUE_SPARKLE_GRAVITY.get(), (double)srcPoint.func_195899_a(), (double)srcPoint.func_195900_b(), (double)srcPoint.func_195902_c(), -0.5 + (double)rnd.nextFloat(), (double)0.04f, -0.5 + (double)rnd.nextFloat());
        }
        for (i = 0; i < 50; ++i) {
            Vector3f lightPoint = new Vector3f(srcPoint.func_195899_a() - 0.2f + rnd.nextFloat() * 0.4f, srcPoint.func_195900_b() - 0.3f, srcPoint.func_195902_c() - 0.2f + rnd.nextFloat() * 0.4f);
            this.field_145850_b.func_195594_a((IParticleData)ParticleInit.LIGHT_VELOCITY.get(), (double)lightPoint.func_195899_a(), (double)lightPoint.func_195900_b(), (double)lightPoint.func_195902_c(), 0.0, 0.01, 0.0);
        }
    }

    private void resolvePendingPatterns() {
        if (this.field_145850_b != null && this.pendingPatterns.size() > 0) {
            for (String s : this.pendingPatterns) {
                ManaweavingPattern p = ManaweavingPatternHelper.GetManaweavingRecipe(this.field_145850_b, new ResourceLocation(s));
                if (p == null) continue;
                this.addedPatterns.add(p);
            }
            this.pendingPatterns.clear();
        }
    }

    private void setCrafting(boolean crafting) {
        this.crafting = crafting;
        if (!this.field_145850_b.field_72995_K && this.crafting) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SFX.Event.Block.MANAWEAVE_ALTAR_CRAFT, SoundCategory.BLOCKS, 1.0f, (float)((double)0.95f + Math.random() * (double)0.05f));
        }
    }

    public boolean isCrafting() {
        return this.crafting;
    }

    public int getCraftTicks() {
        return this.craftTicks;
    }

    public int getMaxCraftTicks() {
        return 85;
    }

    public void func_73660_a() {
        if (!this.crafting) {
            return;
        }
        this.spawnCraftingParticles();
        ++this.craftTicks;
        if (this.craftTicks >= this.getMaxCraftTicks()) {
            this.spawnCraftCompleteParticles();
            this.setCrafting(false);
            this.craftTicks = 0;
            this.pendingPatterns.clear();
            this.addedPatterns.clear();
            this.func_174888_l();
            if (!this.field_145850_b.field_72995_K) {
                if (!EventDispatcher.DispatchManaweaveCrafting(this.__cachedRecipe, this.__cachedRecipeOutput, this.__crafter)) {
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                    return;
                }
                if (this.copyNBT) {
                    CompoundNBT nbt = this.__cachedRecipeOutput.func_196082_o();
                    for (ItemStack stack : this.inventoryItems) {
                        if (!stack.func_77942_o()) continue;
                        nbt.func_197643_a(stack.func_77978_p());
                    }
                }
                this.ignoreQtyLimit = true;
                if (this.__cachedRecipeOutput != null) {
                    this.func_70299_a(0, this.__cachedRecipeOutput);
                }
                this.ignoreQtyLimit = false;
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.0, 1.0, 0.0);
    }

    private ItemAndPatternCraftingInventory createCraftingInventory() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (ManaweavingPattern p : this.addedPatterns) {
            patterns.add(p.func_199560_c().toString());
        }
        for (String s : this.pendingPatterns) {
            patterns.add(s);
        }
        ItemAndPatternCraftingInventory craftinginventory = new ItemAndPatternCraftingInventory(9, patterns);
        for (int i = 0; i < 9; ++i) {
            craftinginventory.func_70299_a(i, this.func_70301_a(i));
        }
        return craftinginventory;
    }
}

