/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.particles.ParticleInit;
import com.ma.blocks.BlockInit;
import com.ma.blocks.runeforging.BlockRuneforge;
import com.ma.blocks.tileentities.TileEntityInit;
import com.ma.blocks.tileentities.TileEntityPedestal;
import com.ma.blocks.tileentities.TileEntityWithInventory;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.arcanefurnace.ArcaneFurnaceRecipe;
import com.ma.tools.MATags;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.extensions.IForgeTileEntity;

public class TileEntityRuneForge
extends TileEntityWithInventory
implements IForgeTileEntity,
ITickableTileEntity {
    private static final int MAX_ITEMS = 64;
    public static final int INVENTORY_SLOT_INDEX = 0;
    int smeltTicks = 0;
    int burnTime = 0;
    private boolean ignoreRecipeCheck = false;
    private ItemStack __cachedRecipeOutput;

    public TileEntityRuneForge(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, 64);
    }

    public TileEntityRuneForge() {
        this((TileEntityType)TileEntityInit.RUNEFORGE.get());
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        if (!this.field_145850_b.field_72995_K) {
            if (!this.ignoreRecipeCheck) {
                this.cacheRecipe();
            }
            if (this.__cachedRecipeOutput != null) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)BlockRuneforge.ACTIVE, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)BlockRuneforge.ORE_DOUBLING, (Comparable)Boolean.valueOf(this.hasMultiUpgrade())));
                this.smeltTicks = 0;
            } else {
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)BlockRuneforge.ACTIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockRuneforge.ORE_DOUBLING, (Comparable)Boolean.valueOf(false)));
            }
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack output = super.func_70298_a(index, count);
        if (!output.func_190926_b()) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockRuneforge.ACTIVE, (Comparable)Boolean.valueOf(false)));
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
        return output;
    }

    private boolean cacheRecipe() {
        CraftingInventory inv = this.createDummyCraftingInventory();
        ArcaneFurnaceRecipe smeltRecipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeInit.ARCANE_FURNACE_TYPE, (IInventory)inv, this.field_145850_b).orElse(null);
        this.__cachedRecipeOutput = null;
        boolean ret = false;
        if (smeltRecipe != null) {
            this.__cachedRecipeOutput = smeltRecipe.func_77571_b();
            this.__cachedRecipeOutput.func_190920_e(this.__cachedRecipeOutput.func_190916_E() * this.func_70301_a(0).func_190916_E());
            this.burnTime = smeltRecipe.getBurnTime() * this.func_70301_a(0).func_190916_E();
            ret = true;
        } else {
            Optional cook_recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222153_e, (IInventory)inv, this.field_145850_b);
            if (cook_recipe.isPresent()) {
                this.__cachedRecipeOutput = ((CampfireCookingRecipe)cook_recipe.get()).func_77572_b((IInventory)inv);
                this.__cachedRecipeOutput.func_190920_e(this.__cachedRecipeOutput.func_190916_E() * this.func_70301_a(0).func_190916_E());
                this.burnTime = ((CampfireCookingRecipe)cook_recipe.get()).func_222137_e() / 2 * this.func_70301_a(0).func_190916_E();
                ret = true;
            } else {
                Optional furnace_recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)inv, this.field_145850_b);
                if (furnace_recipe.isPresent()) {
                    this.__cachedRecipeOutput = ((FurnaceRecipe)furnace_recipe.get()).func_77572_b((IInventory)inv);
                    this.__cachedRecipeOutput.func_190920_e(this.__cachedRecipeOutput.func_190916_E() * this.func_70301_a(0).func_190916_E());
                    this.burnTime = ((FurnaceRecipe)furnace_recipe.get()).func_222137_e() * 2 * this.func_70301_a(0).func_190916_E();
                    ret = true;
                } else {
                    Optional blasting_recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222151_c, (IInventory)inv, this.field_145850_b);
                    if (blasting_recipe.isPresent()) {
                        this.__cachedRecipeOutput = ((BlastingRecipe)blasting_recipe.get()).func_77572_b((IInventory)inv);
                        this.__cachedRecipeOutput.func_190920_e(this.__cachedRecipeOutput.func_190916_E() * this.func_70301_a(0).func_190916_E());
                        this.burnTime = ((BlastingRecipe)blasting_recipe.get()).func_222137_e() * 2 * this.func_70301_a(0).func_190916_E();
                        ret = true;
                    }
                }
            }
        }
        if ((Integer)this.func_195044_w().func_177229_b((Property)BlockRuneforge.MATERIAL) == 1) {
            this.burnTime /= 4;
        }
        if (ret && this.hasMultiUpgrade()) {
            this.__cachedRecipeOutput.func_190920_e(Math.min(this.__cachedRecipeOutput.func_190916_E() * 2, 64));
        }
        return ret;
    }

    private boolean hasMultiUpgrade() {
        switch ((Direction)this.func_195044_w().func_177229_b((Property)BlockRuneforge.FACING)) {
            case EAST: 
            case WEST: {
                return this.isPedestalAndHasCrystal(new BlockPos(Direction.NORTH.func_82601_c(), Direction.NORTH.func_96559_d(), Direction.NORTH.func_82599_e())) && this.isPedestalAndHasCrystal(new BlockPos(Direction.SOUTH.func_82601_c(), Direction.SOUTH.func_96559_d(), Direction.SOUTH.func_82599_e()));
            }
        }
        return this.isPedestalAndHasCrystal(new BlockPos(Direction.EAST.func_82601_c(), Direction.EAST.func_96559_d(), Direction.EAST.func_82599_e())) && this.isPedestalAndHasCrystal(new BlockPos(Direction.WEST.func_82601_c(), Direction.WEST.func_96559_d(), Direction.WEST.func_82599_e()));
    }

    private boolean isPedestalAndHasCrystal(BlockPos offset) {
        TileEntityPedestal pedestal;
        ItemStack stack;
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177971_a((Vector3i)offset)).func_177230_c() == BlockInit.PEDESTAL.get() && !(stack = (pedestal = (TileEntityPedestal)this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vector3i)offset))).func_70301_a(0)).func_190926_b() && stack.func_77973_b() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)stack.func_77973_b();
            return blockItem.func_179223_d() == BlockInit.CHIMERITE_CRYSTAL_ORANGE.get() || blockItem.func_179223_d() == BlockInit.CHIMERITE_CRYSTAL_RED.get() || blockItem.func_179223_d() == BlockInit.CHIMERITE_CRYSTAL_YELLOW.get();
        }
        return false;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack ret = super.func_70304_b(index);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockRuneforge.ACTIVE, (Comparable)Boolean.valueOf(false)));
            this.smeltTicks = 0;
        }
        return ret;
    }

    @Override
    public int func_70302_i_() {
        return 64;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        CompoundNBT sub = new CompoundNBT();
        this.func_70301_a(0).func_77955_b(sub);
        base.func_218657_a("invSync", (INBT)sub);
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        CompoundNBT sub = tag.func_74775_l("invSync");
        this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)sub));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT data = new CompoundNBT();
        this.func_70301_a(0).func_77955_b(data);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, data);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT data = pkt.func_148857_g();
        this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)data));
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack getDisplayedItem() {
        return this.func_70301_a(0);
    }

    public boolean MatchesReagent(ResourceLocation rLoc) {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        return MATags.isItemEqual(this.func_70301_a(0), rLoc);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("smelt_ticks", this.smeltTicks);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("smelt_ticks")) {
            this.smeltTicks = compound.func_74762_e("smelt_ticks");
        }
        super.func_230337_a_(state, compound);
    }

    public void func_73660_a() {
        if (((Boolean)this.func_195044_w().func_177229_b((Property)BlockRuneforge.ACTIVE)).booleanValue()) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.__cachedRecipeOutput == null && !this.cacheRecipe()) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockRuneforge.ACTIVE, (Comparable)Boolean.valueOf(false)));
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                    return;
                }
                ++this.smeltTicks;
                if (this.smeltTicks >= this.burnTime) {
                    this.ignoreRecipeCheck = true;
                    this.func_70299_a(0, this.__cachedRecipeOutput.func_77946_l());
                    this.smeltTicks = 0;
                    this.burnTime = 0;
                    this.ignoreRecipeCheck = false;
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockRuneforge.ACTIVE, (Comparable)Boolean.valueOf(false)));
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                }
            } else {
                BlockState state = this.func_195044_w();
                if (((Boolean)state.func_177229_b((Property)BlockRuneforge.ACTIVE)).booleanValue()) {
                    Direction dir = (Direction)state.func_177229_b((Property)BlockRuneforge.FACING);
                    float xOffset = 0.5f;
                    float zOffset = 0.5f;
                    switch (dir) {
                        default: {
                            xOffset = 0.5f;
                            zOffset = 0.35f;
                            break;
                        }
                        case SOUTH: {
                            xOffset = 0.5f;
                            zOffset = 0.65f;
                            break;
                        }
                        case EAST: {
                            xOffset = 0.65f;
                            zOffset = 0.5f;
                            break;
                        }
                        case WEST: {
                            xOffset = 0.35f;
                            zOffset = 0.5f;
                        }
                    }
                    for (int i = 0; i < 4; ++i) {
                        this.field_145850_b.func_195594_a((Integer)state.func_177229_b((Property)BlockRuneforge.MATERIAL) == 0 ? (IParticleData)ParticleInit.BLUE_FLAME.get() : (IParticleData)ParticleInit.FLAME.get(), (double)((float)this.field_174879_c.func_177958_n() + xOffset + (-0.1f + this.field_145850_b.func_201674_k().nextFloat() * 0.2f)), (double)((float)this.field_174879_c.func_177956_o() + 0.4f + (-0.3f + this.field_145850_b.func_201674_k().nextFloat() * 0.6f)), (double)((float)this.field_174879_c.func_177952_p() + zOffset + (-0.1f + this.field_145850_b.func_201674_k().nextFloat() * 0.2f)), 0.0, (double)0.01f, 0.0);
                    }
                }
                if (((Boolean)state.func_177229_b((Property)BlockRuneforge.ORE_DOUBLING)).booleanValue()) {
                    BlockPos offset_1 = null;
                    BlockPos offset_2 = null;
                    switch ((Direction)this.func_195044_w().func_177229_b((Property)BlockRuneforge.FACING)) {
                        case EAST: 
                        case WEST: {
                            offset_1 = new BlockPos(Direction.NORTH.func_82601_c(), Direction.NORTH.func_96559_d(), Direction.NORTH.func_82599_e());
                            offset_2 = new BlockPos(Direction.SOUTH.func_82601_c(), Direction.SOUTH.func_96559_d(), Direction.SOUTH.func_82599_e());
                            break;
                        }
                        default: {
                            offset_1 = new BlockPos(Direction.EAST.func_82601_c(), Direction.EAST.func_96559_d(), Direction.EAST.func_82599_e());
                            offset_2 = new BlockPos(Direction.WEST.func_82601_c(), Direction.WEST.func_96559_d(), Direction.WEST.func_82599_e());
                        }
                    }
                    if (offset_1 != null && offset_2 != null) {
                        for (int i = 0; i < 5; ++i) {
                            this.field_145850_b.func_195594_a((IParticleData)ParticleInit.FLAME_ORBIT.get(), (double)((float)(this.field_174879_c.func_177958_n() + offset_1.func_177958_n()) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() + offset_1.func_177956_o()) + 0.5f), (double)((float)(this.field_174879_c.func_177952_p() + offset_1.func_177952_p()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
                            this.field_145850_b.func_195594_a((IParticleData)ParticleInit.FLAME_ORBIT.get(), (double)((float)(this.field_174879_c.func_177958_n() + offset_2.func_177958_n()) + 0.5f), (double)((float)(this.field_174879_c.func_177956_o() + offset_2.func_177956_o()) + 0.5f), (double)((float)(this.field_174879_c.func_177952_p() + offset_2.func_177952_p()) + 0.5f), (double)0.1f, (double)0.02f, (double)0.1f);
                        }
                    }
                }
            }
        }
    }

    private CraftingInventory createDummyCraftingInventory() {
        CraftingInventory craftinginventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, 1, 1);
        craftinginventory.func_70299_a(0, this.func_70301_a(0));
        return craftinginventory;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        if (index == 0) {
            return this.func_70301_a(0).func_190926_b();
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (!ItemStack.func_179545_c((ItemStack)this.func_70301_a(index), (ItemStack)stack) || this.burnTime > 0) {
            return false;
        }
        if (index == 0) {
            return !this.func_70301_a(0).func_190926_b();
        }
        return false;
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return new int[]{0};
    }
}

