/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.blocks.BlockInit;
import com.ma.blocks.multiblock.MultiblockStructure;
import com.ma.blocks.ritual.BlockChalkRune;
import com.ma.blocks.runeforging.BlockRunicAnvil;
import com.ma.blocks.tileentities.TileEntityInit;
import com.ma.blocks.tileentities.TileEntityWithInventory;
import com.ma.events.EventDispatcher;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.manaweaving.ManaweavingRecipe;
import com.ma.recipes.runeforging.RuneforgingRecipe;
import com.ma.tools.MATags;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeTileEntity;

public class TileEntityRunicAnvil
extends TileEntityWithInventory
implements IForgeTileEntity,
ISidedInventory {
    private static final MultiblockStructure runesMultiblock = new MultiblockStructure().AddRequiredBlock(new BlockPos(-1, 0, -2), (BlockState)((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_206870_a((Property)BlockChalkRune.METAL, (Comparable)Boolean.valueOf(true))).AddRequiredBlock(new BlockPos(1, 0, -2), (BlockState)((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_206870_a((Property)BlockChalkRune.METAL, (Comparable)Boolean.valueOf(true))).AddRequiredBlock(new BlockPos(-1, 0, 2), (BlockState)((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_206870_a((Property)BlockChalkRune.METAL, (Comparable)Boolean.valueOf(true))).AddRequiredBlock(new BlockPos(1, 0, 2), (BlockState)((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_206870_a((Property)BlockChalkRune.METAL, (Comparable)Boolean.valueOf(true))).AddRequiredBlock(new BlockPos(-2, 0, -1), (BlockState)((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_206870_a((Property)BlockChalkRune.METAL, (Comparable)Boolean.valueOf(true))).AddRequiredBlock(new BlockPos(-2, 0, 1), (BlockState)((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_206870_a((Property)BlockChalkRune.METAL, (Comparable)Boolean.valueOf(true))).AddRequiredBlock(new BlockPos(2, 0, -1), (BlockState)((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_206870_a((Property)BlockChalkRune.METAL, (Comparable)Boolean.valueOf(true))).AddRequiredBlock(new BlockPos(2, 0, 1), (BlockState)((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_206870_a((Property)BlockChalkRune.METAL, (Comparable)Boolean.valueOf(true))).AddRequiredBlock(new BlockPos(2, 0, 2), ((Block)BlockInit.PEDESTAL.get()).func_176223_P()).AddRequiredBlock(new BlockPos(-2, 0, 2), ((Block)BlockInit.PEDESTAL.get()).func_176223_P()).AddRequiredBlock(new BlockPos(2, 0, -2), ((Block)BlockInit.PEDESTAL.get()).func_176223_P()).AddRequiredBlock(new BlockPos(-2, 0, -2), ((Block)BlockInit.PEDESTAL.get()).func_176223_P());
    private static final int MAX_ITEMS = 2;
    public static final int PATTERN_SLOT_INDEX = 0;
    public static final int MATERIAL_SLOT_INDEX = 1;
    public static final int ADVANCE_RESPONSE_ADVANCED = 0;
    public static final int ADVANCE_RESPONSE_NO_MATCH = 1;
    public static final int ADVANCE_RESPONSE_LOW_TIER = 2;
    public static final int ADVANCE_RESPONSE_CLIENT_WORLD = 3;
    public static final int ADVANCE_RESPONSE_CRAFTING_COMPLETE = 4;
    public int craftProgress = 0;
    public int maxCraftProgress = 10;
    private ItemStack __cachedRecipeOutput = ItemStack.field_190927_a;
    private RuneforgingRecipe __cachedRecipe;
    private Optional<ManaweavingRecipe> __cachedEnchantRecipe;
    private boolean autoCacheRecipe = true;
    private boolean settingCraftOutput = false;

    public TileEntityRunicAnvil(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, 2);
    }

    public TileEntityRunicAnvil() {
        this((TileEntityType)TileEntityInit.RUNIC_ANVIL.get());
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        CompoundNBT sub_1 = new CompoundNBT();
        this.func_70301_a(0).func_77955_b(sub_1);
        base.func_218657_a("invSync_1", (INBT)sub_1);
        CompoundNBT sub_2 = new CompoundNBT();
        this.func_70301_a(1).func_77955_b(sub_2);
        base.func_218657_a("invSync_2", (INBT)sub_2);
        base.func_74768_a("craft_progress", this.craftProgress);
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        CompoundNBT sub = tag.func_74775_l("invSync_1");
        this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)sub));
        CompoundNBT sub2 = tag.func_74775_l("invSync_2");
        this.func_70299_a(1, ItemStack.func_199557_a((CompoundNBT)sub2));
        this.craftProgress = tag.func_74762_e("craft_progress");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT data = new CompoundNBT();
        CompoundNBT sub_1 = new CompoundNBT();
        this.func_70301_a(0).func_77955_b(sub_1);
        data.func_218657_a("invSync_1", (INBT)sub_1);
        CompoundNBT sub_2 = new CompoundNBT();
        this.func_70301_a(1).func_77955_b(sub_2);
        data.func_218657_a("invSync_2", (INBT)sub_2);
        data.func_74768_a("craft_progress", this.craftProgress);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, data);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT data = pkt.func_148857_g();
        CompoundNBT sub = data.func_74775_l("invSync_1");
        this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)sub));
        CompoundNBT sub2 = data.func_74775_l("invSync_2");
        this.func_70299_a(1, ItemStack.func_199557_a((CompoundNBT)sub2));
        this.craftProgress = data.func_74762_e("craft_progress");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("craft_progress", this.craftProgress);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.craftProgress = compound.func_74762_e("craft_progress");
        super.func_230337_a_(state, compound);
    }

    public int func_70297_j_() {
        return this.settingCraftOutput ? 64 : 1;
    }

    public int getMaxCraftProgress() {
        return this.__cachedRecipe != null ? this.__cachedRecipe.getHits() : this.maxCraftProgress;
    }

    public ItemStack[] getDisplayedItems() {
        return new ItemStack[]{this.func_70301_a(0), this.func_70301_a(1)};
    }

    public boolean MatchesReagent(ResourceLocation rLoc) {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        return MATags.isItemEqual(this.func_70301_a(0), rLoc);
    }

    public boolean pushItemStack(ItemStack stack, int playerTier) {
        if (stack.func_190916_E() != 1) {
            return false;
        }
        if (this.func_70301_a(0).func_190926_b()) {
            this.func_70299_a(0, stack);
            return true;
        }
        if (this.func_70301_a(1).func_190926_b()) {
            this.setInventorySlotContentsNoCache(1, stack);
            this.cacheRecipe(playerTier);
            return true;
        }
        return false;
    }

    private void setInventorySlotContentsNoCache(int index, ItemStack stack) {
        this.autoCacheRecipe = false;
        this.func_70299_a(index, stack);
        this.autoCacheRecipe = true;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        if (this.autoCacheRecipe) {
            this.cacheRecipe(5);
        }
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        return this.func_70304_b(index);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack output = super.func_70304_b(index);
        if (!output.func_190926_b() && this.autoCacheRecipe) {
            this.cacheRecipe(5);
        }
        return output;
    }

    public ItemStack popItemStack() {
        if (this.craftProgress > 0) {
            return ItemStack.field_190927_a;
        }
        this.__cachedRecipeOutput = ItemStack.field_190927_a;
        if (!this.func_70301_a(1).func_190926_b()) {
            return this.func_70304_b(1);
        }
        if (!this.func_70301_a(0).func_190926_b()) {
            return this.func_70304_b(0);
        }
        return ItemStack.field_190927_a;
    }

    private int cacheRecipe(int playerTier) {
        CraftingInventory inv = this.createDummyCraftingInventory();
        this.__cachedRecipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeInit.RUNEFORGING_TYPE, (IInventory)inv, this.field_145850_b).orElse(null);
        this.__cachedRecipeOutput = ItemStack.field_190927_a;
        int output = 1;
        if (this.__cachedRecipe == null) {
            ItemStack rune = this.func_70301_a(1);
            if (!rune.func_190926_b()) {
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)rune);
                this.__cachedEnchantRecipe = this.field_145850_b.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == RecipeInit.MANAWEAVING_RECIPE_TYPE && ((ManaweavingRecipe)r).matches(enchantments)).map(r -> (ManaweavingRecipe)r).findFirst();
                if (this.__cachedEnchantRecipe.isPresent()) {
                    if (this.__cachedEnchantRecipe.get().getTier() > playerTier) {
                        this.__cachedEnchantRecipe = null;
                        this.__cachedRecipeOutput = ItemStack.field_190927_a;
                        output = 2;
                    } else {
                        this.__cachedRecipeOutput = this.func_70301_a(0).func_77946_l();
                        boolean compatible = true;
                        Map existingEnchants = EnchantmentHelper.func_82781_a((ItemStack)this.__cachedRecipeOutput);
                        block0: for (Map.Entry ee : existingEnchants.entrySet()) {
                            for (Map.Entry e2 : enchantments.entrySet()) {
                                if (e2.getKey() == ee.getKey() && (Integer)e2.getValue() <= (Integer)ee.getValue()) {
                                    compatible = false;
                                    continue block0;
                                }
                                if (((Enchantment)e2.getKey()).func_191560_c((Enchantment)ee.getKey())) continue;
                                compatible = false;
                                continue block0;
                            }
                        }
                        if (compatible) {
                            existingEnchants.forEach((e, i) -> enchantments.put(e, i));
                            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)this.__cachedRecipeOutput);
                            output = 0;
                        } else {
                            output = 1;
                            this.__cachedRecipeOutput = ItemStack.field_190927_a;
                        }
                    }
                }
            }
        } else if (this.__cachedRecipe.getTier() <= playerTier) {
            this.__cachedRecipeOutput = this.__cachedRecipe.func_77571_b();
            output = 0;
        } else {
            this.__cachedRecipe = null;
            this.__cachedRecipeOutput = ItemStack.field_190927_a;
            output = 2;
        }
        boolean hasActive = this.func_195044_w().func_235901_b_((Property)BlockRunicAnvil.ACTIVE);
        boolean isActive = (Boolean)this.func_195044_w().func_177229_b((Property)BlockRunicAnvil.ACTIVE);
        if (!this.__cachedRecipeOutput.func_190926_b()) {
            if (!hasActive || !isActive) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockRunicAnvil.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (!hasActive || isActive) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockRunicAnvil.ACTIVE, (Comparable)Boolean.valueOf(false)), 0);
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        return output;
    }

    public int advanceCrafting(PlayerEntity crafter, int playerTier) {
        int cacheResponse = this.cacheRecipe(playerTier);
        if (this.field_145850_b.field_72995_K) {
            return 3;
        }
        if (this.__cachedRecipeOutput.func_190926_b()) {
            this.abortCrafting();
            return cacheResponse;
        }
        ++this.craftProgress;
        int targetProgress = this.getMaxCraftProgress();
        if (this.craftProgress >= targetProgress) {
            this.craftProgress = 0;
            if (this.__cachedRecipe != null) {
                if (!EventDispatcher.DispatchRuneforgeCraft(this.__cachedRecipe, this.__cachedRecipeOutput, crafter)) {
                    this.abortCrafting();
                    return cacheResponse;
                }
            } else if (this.__cachedEnchantRecipe != null && !EventDispatcher.DispatchRuneforgeEnchant(this.__cachedRecipeOutput, crafter)) {
                this.abortCrafting();
                return cacheResponse;
            }
            this.completeCraftingAndReset();
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockRunicAnvil.ACTIVE, (Comparable)Boolean.valueOf(false)));
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
            return 4;
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        return 0;
    }

    private void abortCrafting() {
        InventoryHelper.func_180175_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IInventory)this);
        this.func_174888_l();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    private void completeCraftingAndReset() {
        this.settingCraftOutput = true;
        this.func_70299_a(0, this.__cachedRecipeOutput);
        this.settingCraftOutput = false;
        this.func_70299_a(1, ItemStack.field_190927_a);
        this.__cachedRecipeOutput = ItemStack.field_190927_a;
        this.__cachedRecipe = null;
        this.__cachedEnchantRecipe = null;
    }

    public ItemStack getOutputStack() {
        return this.__cachedRecipeOutput;
    }

    @Nullable
    public RuneforgingRecipe getCachedRecipe() {
        return this.__cachedRecipe;
    }

    private CraftingInventory createDummyCraftingInventory() {
        CraftingInventory craftinginventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, 2, 1);
        craftinginventory.func_70299_a(0, this.func_70301_a(0));
        craftinginventory.func_70299_a(1, this.func_70301_a(1));
        return craftinginventory;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        if (itemStackIn.func_190916_E() != 1) {
            return false;
        }
        if (index == 1) {
            return !this.func_70301_a(0).func_190926_b() && this.func_70301_a(1).func_190926_b();
        }
        if (index == 0) {
            return this.func_70301_a(1).func_190926_b() && this.func_70301_a(0).func_190926_b();
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (!ItemStack.func_179545_c((ItemStack)this.func_70301_a(index), (ItemStack)stack)) {
            return false;
        }
        if (index == 0) {
            return this.func_70301_a(1).func_190926_b() && !this.func_70301_a(0).func_190926_b();
        }
        if (index == 1) {
            return !this.func_70301_a(1).func_190926_b();
        }
        return false;
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1};
    }
}

